package com.alterioncorp.requestlogger;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryImpl implements ThreadFactory {

	private final boolean daemon;
	private final ThreadGroup group;
	private final String namePrefix;
	private final AtomicInteger threadNumber;

    public ThreadFactoryImpl(String poolName, boolean daemon) {
    	this.daemon = daemon;
    	this.group = System.getSecurityManager() != null ?
    					System.getSecurityManager().getThreadGroup() :
    					Thread.currentThread().getThreadGroup();
        this.namePrefix = poolName + "-thread-";
        this.threadNumber = new AtomicInteger(1);
    }

    public Thread newThread(Runnable runnable) {
        
    	Thread thread = new Thread(
        		group,
        		runnable,
        		namePrefix + threadNumber.getAndIncrement());
        
        thread.setDaemon(daemon);
        thread.setPriority(Thread.NORM_PRIORITY);
        
        return thread;
    }
}