package com.alterioncorp.requestlogger.perfjdbc;

import java.sql.Types;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alterioncorp.perfjdbc.StopWatch;
import com.alterioncorp.requestlogger.Persister;
import com.alterioncorp.requestlogger.PropertyRegistry;
import com.alterioncorp.requestlogger.Request;
import com.alterioncorp.requestlogger.RequestLoggerFilter;

public class RequestLoggerFilterPerfJdbc extends RequestLoggerFilter {

	public RequestLoggerFilterPerfJdbc() {
		super();
	}

	protected RequestLoggerFilterPerfJdbc(Persister requestLogger,
			PropertyRegistry propertyRegistry, boolean enabled,
			long persistPeriodInMillis, int queueMaxSize,
			Set<String> paramNamesToSanitize) {
		super(requestLogger, propertyRegistry, enabled, persistPeriodInMillis,
				queueMaxSize, paramNamesToSanitize);
	}

	@Override
	protected void modifyPropertyRegistry(PropertyRegistry dataTypeRegistry) {
		super.modifyPropertyRegistry(dataTypeRegistry);
		dataTypeRegistry.registerProperty(REQUEST_PROPERTY_SQL_DURATION, Types.BIGINT);
	}

	@Override
	protected void modifyRequestLogData(Request requestEntity,
			HttpServletRequest httpServletRequest,
			HttpServletResponse httpServletResponse) {
		super.modifyRequestLogData(requestEntity, httpServletRequest, httpServletResponse);
		requestEntity.getData().put(REQUEST_PROPERTY_SQL_DURATION, StopWatch.getTime());
	}

	@Override
	protected void beforeFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
		StopWatch.reset();
	}

	@Override
	protected void afterFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
		StopWatch.reset();
	}
}
