/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus;

import com.amadeus.Configuration;
import com.amadeus.HttpVerbs;
import com.amadeus.Params;
import com.amadeus.Request;
import com.amadeus.Response;
import com.amadeus.client.AccessToken;
import com.amadeus.exceptions.NetworkException;
import com.amadeus.exceptions.ResponseException;
import com.amadeus.resources.Resource;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import lombok.Generated;

public class HTTPClient {
    protected AccessToken accessToken = new AccessToken(this);
    private Configuration configuration;

    protected HTTPClient(Configuration configuration) {
        this.configuration = configuration;
    }

    public Response get(String path) throws ResponseException {
        return this.request(HttpVerbs.GET, path, null, null);
    }

    public Response get(String path, Params params) throws ResponseException {
        return this.request(HttpVerbs.GET, path, params, null);
    }

    public Response delete(String path, Params params) throws ResponseException {
        return this.request(HttpVerbs.DELETE, path, params, null);
    }

    public Response delete(String path) throws ResponseException {
        return this.request(HttpVerbs.DELETE, path, null, null);
    }

    public Response post(String path) throws ResponseException {
        return this.request(HttpVerbs.POST, path, null, null);
    }

    public Response post(String path, Params params) throws ResponseException {
        return this.request(HttpVerbs.POST, path, params, null);
    }

    public Response post(String path, String body) throws ResponseException {
        return this.request(HttpVerbs.POST, path, null, body);
    }

    public Response post(String path, JsonObject body) throws ResponseException {
        return this.request(HttpVerbs.POST, path, null, body.toString());
    }

    public Response post(String path, Params params, JsonObject body) throws ResponseException {
        return this.request(HttpVerbs.POST, path, params, body.toString());
    }

    public Response post(String path, Params params, String body) throws ResponseException {
        return this.request(HttpVerbs.POST, path, params, body);
    }

    public Response unauthenticatedRequest(HttpVerbs verb, String path, Params params, String body, String bearerToken) throws ResponseException {
        Request request = this.buildRequest(verb, path, params, body, bearerToken);
        this.log(request);
        return this.execute(request);
    }

    public Response previous(Response response) throws ResponseException {
        return this.page("previous", response);
    }

    public Resource[] previous(Resource resource) throws ResponseException {
        return this.page("previous", resource);
    }

    public Response next(Response response) throws ResponseException {
        return this.page("next", response);
    }

    public Resource[] next(Resource resource) throws ResponseException {
        return this.page("next", resource);
    }

    public Response first(Response response) throws ResponseException {
        return this.page("first", response);
    }

    public Resource[] first(Resource resource) throws ResponseException {
        return this.page("first", resource);
    }

    public Response last(Response response) throws ResponseException {
        return this.page("last", response);
    }

    public Resource[] last(Resource resource) throws ResponseException {
        return this.page("last", resource);
    }

    protected Response request(HttpVerbs verb, String path, Params params, String body) throws ResponseException {
        return this.unauthenticatedRequest(verb, path, params, body, this.accessToken.getBearerToken());
    }

    protected Request buildRequest(HttpVerbs verb, String path, Params params, String body, String bearerToken) {
        return new Request(verb, path, params, body, bearerToken, this);
    }

    private void log(Object object) {
        if (this.getConfiguration().getLogLevel() == "debug") {
            Logger logger = this.getConfiguration().getLogger();
            logger.info(object.toString());
        }
    }

    private Response execute(Request request) throws ResponseException {
        Response response = new Response(this.fetch(request));
        response.parse(this);
        this.log(response);
        response.detectError(this);
        return response;
    }

    private Request fetch(Request request) throws NetworkException {
        try {
            request.establishConnection();
            this.write(request);
        }
        catch (IOException e) {
            throw new NetworkException(new Response(request));
        }
        return request;
    }

    private void write(Request request) throws IOException {
        BufferedWriter writer;
        OutputStream os;
        String encoding = "UTF-8";
        if (request.getVerb() == HttpVerbs.POST && request.getParams() != null && request.getBearerToken() != null) {
            os = request.getConnection().getOutputStream();
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            if (request.getBody() != null) {
                writer.write(request.getBody());
            }
            writer.flush();
            writer.close();
            os.close();
        }
        if (request.getVerb() == HttpVerbs.POST && request.getParams() != null && request.getBearerToken() == null) {
            os = request.getConnection().getOutputStream();
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(request.getParams().toQueryString());
            writer.flush();
            writer.close();
            os.close();
        }
        if (request.getVerb() == HttpVerbs.POST && request.getParams() == null) {
            os = request.getConnection().getOutputStream();
            writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            if (request.getBody() != null) {
                writer.write(request.getBody());
            }
            writer.flush();
            writer.close();
            os.close();
        }
    }

    protected Response page(String pageName, Response response) throws ResponseException {
        JsonObject metaLinks = response.getResult().get("meta").getAsJsonObject().get("links").getAsJsonObject();
        JsonElement pageElement = metaLinks.get(pageName);
        if (pageElement == null) {
            return null;
        }
        String[] parts = pageElement.getAsString().split("page%5Boffset%5D=");
        String pageNumber = parts[1].split("&")[0];
        Request request = response.getRequest();
        Params params = (Params)request.getParams().clone();
        params.put("page[offset]", pageNumber);
        return this.request(request.getVerb(), request.getPath(), params, "emptyBody");
    }

    protected Resource[] page(String pageName, Resource resource) throws ResponseException {
        Response response = this.page(pageName, resource.getResponse());
        return Resource.fromArray(response, resource.getDeSerializationClass());
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

