/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus;

import com.amadeus.Configuration;
import com.amadeus.Constants;
import com.amadeus.HTTPClient;
import com.amadeus.HttpVerbs;
import com.amadeus.Params;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Request {
    private HttpVerbs verb;
    private String scheme;
    private String host;
    private String path;
    private Params params;
    private String body;
    private String bearerToken;
    private String clientVersion;
    private String languageVersion;
    private String appId;
    private String appVersion;
    private boolean ssl;
    private int port;
    private HashMap<String, String> headers;
    private String uri;
    private HttpURLConnection connection;

    protected Request(HttpVerbs verb, String path, Params params, String body, String bearerToken, HTTPClient client) {
        Configuration config = client.getConfiguration();
        this.verb = verb;
        this.host = config.getHost();
        this.path = path;
        this.params = params;
        this.body = body;
        this.bearerToken = bearerToken;
        this.languageVersion = System.getProperty("java.version");
        this.clientVersion = "7.1.0";
        this.appId = config.getCustomAppId();
        this.appVersion = config.getCustomAppVersion();
        this.port = config.getPort();
        this.ssl = config.isSsl();
        this.determineScheme();
        this.prepareUrl();
        this.prepareHeaders();
    }

    protected void establishConnection() throws IOException {
        this.connection = (HttpURLConnection)new URL(this.uri).openConnection();
        this.connection.setRequestMethod(this.verb.name());
        this.connection.setDoInput(true);
        if (this.verb == HttpVerbs.POST || this.verb == HttpVerbs.PUT) {
            this.connection.setDoOutput(true);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            this.connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private void determineScheme() {
        this.scheme = this.isSsl() ? "https" : "http";
    }

    private void prepareUrl() {
        this.uri = String.format("%s://%s:%s%s?%s", this.scheme, this.host, this.port, this.path, this.getQueryParams());
    }

    private void prepareHeaders() {
        this.headers = new HashMap();
        this.headers.put("User-Agent", this.buildUserAgent());
        this.headers.put("Accept", "application/json, application/vnd.amadeus+json");
        if (this.bearerToken != null) {
            this.headers.put("Authorization", this.bearerToken);
            this.headers.put("Content-Type", "application/vnd.amadeus+json");
            if (Constants.APIS_WITH_EXTRA_HEADER.contains(this.path) && this.verb == HttpVerbs.POST) {
                this.headers.put("X-HTTP-Method-Override", HttpVerbs.GET.name());
            }
        }
    }

    private String buildUserAgent() {
        String userAgent = String.format("amadeus-java/%s", this.clientVersion);
        userAgent = userAgent.concat(String.format(" java/%s", this.languageVersion));
        if (this.appId != null) {
            userAgent = userAgent.concat(String.format(" %s/%s", this.appId, this.appVersion));
        }
        return userAgent;
    }

    private String getQueryParams() {
        if (this.params != null) {
            return this.params.toQueryString();
        }
        return "";
    }

    @Generated
    public String toString() {
        return "Request(verb=" + (Object)((Object)this.getVerb()) + ", scheme=" + this.getScheme() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", params=" + this.getParams() + ", body=" + this.getBody() + ", bearerToken=" + this.getBearerToken() + ", clientVersion=" + this.getClientVersion() + ", languageVersion=" + this.getLanguageVersion() + ", appId=" + this.getAppId() + ", appVersion=" + this.getAppVersion() + ", ssl=" + this.isSsl() + ", port=" + this.getPort() + ", headers=" + this.getHeaders() + ", uri=" + this.getUri() + ", connection=" + this.getConnection() + ")";
    }

    @Generated
    public HttpVerbs getVerb() {
        return this.verb;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Params getParams() {
        return this.params;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Generated
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getAppVersion() {
        return this.appVersion;
    }

    @Generated
    public boolean isSsl() {
        return this.ssl;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public HttpURLConnection getConnection() {
        return this.connection;
    }
}

