/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus;

import com.amadeus.HTTPClient;
import com.amadeus.Request;
import com.amadeus.exceptions.AuthenticationException;
import com.amadeus.exceptions.ClientException;
import com.amadeus.exceptions.NotFoundException;
import com.amadeus.exceptions.ParserException;
import com.amadeus.exceptions.ResponseException;
import com.amadeus.exceptions.ServerException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Arrays;
import lombok.Generated;

public class Response {
    private int statusCode;
    private boolean parsed;
    private JsonObject result;
    private JsonElement data;
    private JsonElement warnings;
    private String body;
    private Request request;

    protected Response(Request request) {
        this.request = request;
    }

    protected void parse(HTTPClient client) {
        this.parseStatusCode();
        if (this.statusCode != 204) {
            this.parseData();
        }
    }

    protected void detectError(HTTPClient client) throws ResponseException {
        ResponseException exception = null;
        if (this.statusCode >= 500) {
            exception = new ServerException(this);
        } else if (this.statusCode == 404) {
            exception = new NotFoundException(this);
        } else if (this.statusCode == 401) {
            exception = new AuthenticationException(this);
        } else if (this.statusCode >= 400) {
            exception = new ClientException(this);
        } else {
            if (this.statusCode == 204) {
                return;
            }
            if (!this.parsed) {
                exception = new ParserException(this);
            }
        }
        if (exception != null) {
            exception.log(client.getConfiguration());
            throw exception;
        }
    }

    private void parseStatusCode() {
        try {
            this.statusCode = this.getRequest().getConnection().getResponseCode();
        }
        catch (IOException e) {
            this.statusCode = 0;
        }
    }

    private void parseData() {
        String warningsValue = "warnings";
        this.parsed = false;
        this.body = this.readBody();
        this.result = this.parseJson();
        boolean bl = this.parsed = this.result != null;
        if (this.parsed && this.result.has("data")) {
            if (this.result.get("data").isJsonArray()) {
                this.data = this.result.get("data").getAsJsonArray();
            }
            if (this.result.get("data").isJsonObject()) {
                this.data = this.result.get("data").getAsJsonObject();
            }
        }
        if (this.parsed && this.result.has("warnings")) {
            if (this.result.get("warnings").isJsonArray()) {
                this.warnings = this.result.get("warnings").getAsJsonArray();
            }
            if (this.result.get("warnings").isJsonObject()) {
                this.warnings = this.result.get("warnings").getAsJsonObject();
            }
        }
    }

    private String readBody() {
        HttpURLConnection connection = this.getRequest().getConnection();
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException e) {
            inputStream = connection.getErrorStream();
        }
        try {
            String inputLine;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer body = new StringBuffer();
            while ((inputLine = bufferedReader.readLine()) != null) {
                body.append(inputLine);
            }
            bufferedReader.close();
            return body.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private JsonObject parseJson() {
        if (this.isJson()) {
            return new JsonParser().parse(this.getBody()).getAsJsonObject();
        }
        return null;
    }

    private boolean isJson() {
        return this.hasJsonHeader() && this.hasBody();
    }

    private boolean hasJsonHeader() {
        String contentType = this.getRequest().getConnection().getHeaderField("Content-Type");
        String[] expectedContentTypes = new String[]{"application/json", "application/vnd.amadeus+json"};
        return Arrays.asList(expectedContentTypes).contains(contentType);
    }

    private boolean hasBody() {
        return this.body != null && !this.body.isEmpty();
    }

    @Generated
    public String toString() {
        return "Response(statusCode=" + this.getStatusCode() + ", parsed=" + this.isParsed() + ", result=" + this.getResult() + ", data=" + this.getData() + ", warnings=" + this.getWarnings() + ", body=" + this.getBody() + ", request=" + this.getRequest() + ")";
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public boolean isParsed() {
        return this.parsed;
    }

    @Generated
    public JsonObject getResult() {
        return this.result;
    }

    @Generated
    public JsonElement getData() {
        return this.data;
    }

    @Generated
    public JsonElement getWarnings() {
        return this.warnings;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public Request getRequest() {
        return this.request;
    }
}

