/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.booking;

import com.amadeus.Amadeus;
import com.amadeus.Response;
import com.amadeus.exceptions.ResponseException;
import com.amadeus.resources.FlightOfferSearch;
import com.amadeus.resources.FlightOrder;
import com.amadeus.resources.FlightPrice;
import com.amadeus.resources.Resource;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class FlightOrders {
    private Amadeus client;
    private static final String FLIGHT_ORDERS_URL = "/v1/booking/flight-orders";

    public FlightOrders(Amadeus client) {
        this.client = client;
    }

    private JsonArray buildTravelersJSON(FlightOrder.Traveler[] travelers) {
        Gson gson = new GsonBuilder().create();
        JsonArray travelerArray = new JsonArray();
        for (int i = 0; i < travelers.length; ++i) {
            JsonElement traveler = gson.toJsonTree((Object)travelers[i], FlightOrder.Traveler.class);
            travelerArray.add(traveler);
        }
        return travelerArray;
    }

    private JsonArray buildFlightOffersJSON(FlightOfferSearch[] flightOffers) {
        Gson gson = new GsonBuilder().create();
        JsonArray flightOffersArray = new JsonArray();
        for (int i = 0; i < flightOffers.length; ++i) {
            JsonElement flightOffer = gson.toJsonTree((Object)flightOffers[i], FlightOfferSearch.class);
            flightOffersArray.add(flightOffer);
        }
        return flightOffersArray;
    }

    public FlightOrder post(JsonObject body) throws ResponseException {
        Response response = this.client.post(FLIGHT_ORDERS_URL, body);
        return (FlightOrder)Resource.fromObject(response, FlightOrder.class);
    }

    public FlightOrder post(String body) throws ResponseException {
        Response response = this.client.post(FLIGHT_ORDERS_URL, body);
        return (FlightOrder)Resource.fromObject(response, FlightOrder.class);
    }

    public FlightOrder post(FlightOfferSearch[] flightOffersSearches, FlightOrder.Traveler[] travelers) throws ResponseException {
        JsonObject typeObject = new JsonObject();
        typeObject.addProperty("type", "flight-order");
        JsonArray flightOffersArray = this.buildFlightOffersJSON(flightOffersSearches);
        typeObject.add("flightOffers", (JsonElement)flightOffersArray);
        JsonArray travelerArray = this.buildTravelersJSON(travelers);
        typeObject.add("travelers", (JsonElement)travelerArray);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("data", (JsonElement)typeObject);
        Response response = this.client.post(FLIGHT_ORDERS_URL, jsonObject);
        return (FlightOrder)Resource.fromObject(response, FlightOrder.class);
    }

    public FlightOrder post(FlightOfferSearch flightOffersSearch, FlightOrder.Traveler[] travelers) throws ResponseException {
        FlightOfferSearch[] flightOffersSearchArray = new FlightOfferSearch[]{flightOffersSearch};
        return this.post(flightOffersSearchArray, travelers);
    }

    public FlightOrder post(FlightPrice flightPrice, FlightOrder.Traveler[] travelers) throws ResponseException {
        JsonObject typeObject = new JsonObject();
        typeObject.addProperty("type", "flight-order");
        JsonArray flightOffersArray = this.buildFlightOffersJSON(flightPrice.getFlightOffers());
        typeObject.add("flightOffers", (JsonElement)flightOffersArray);
        JsonArray travelerArray = this.buildTravelersJSON(travelers);
        typeObject.add("travelers", (JsonElement)travelerArray);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("data", (JsonElement)typeObject);
        Response response = this.client.post(FLIGHT_ORDERS_URL, jsonObject);
        return (FlightOrder)Resource.fromObject(response, FlightOrder.class);
    }

    public FlightOrder post() throws ResponseException {
        return this.post((String)null);
    }
}

