/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.client;

import com.amadeus.Configuration;
import com.amadeus.HTTPClient;
import com.amadeus.HttpVerbs;
import com.amadeus.Params;
import com.amadeus.Response;
import com.amadeus.exceptions.ResponseException;
import com.google.gson.JsonObject;

public class AccessToken {
    private static final long TOKEN_BUFFER = 10000L;
    private final HTTPClient client;
    private String accessToken = null;
    private long expiresAt;

    public AccessToken(HTTPClient client) {
        this.client = client;
    }

    public String getBearerToken() throws ResponseException {
        this.lazyUpdateAccessToken();
        return String.format("Bearer %s", this.accessToken);
    }

    private void lazyUpdateAccessToken() throws ResponseException {
        if (this.needsRefresh()) {
            this.updateAccessToken();
        }
    }

    private void updateAccessToken() throws ResponseException {
        Response response = this.fetchAccessToken();
        this.storeAccessToken(response.getResult());
    }

    private boolean needsRefresh() {
        boolean isNull = this.accessToken == null;
        boolean expired = System.currentTimeMillis() + 10000L > this.expiresAt;
        return isNull || expired;
    }

    private Response fetchAccessToken() throws ResponseException {
        Configuration config = this.client.getConfiguration();
        return this.client.unauthenticatedRequest(HttpVerbs.POST, "/v1/security/oauth2/token", Params.with("grant_type", "client_credentials").and("client_id", config.getClientId()).and("client_secret", config.getClientSecret()), null, null);
    }

    private void storeAccessToken(JsonObject result) {
        this.accessToken = result.get("access_token").getAsString();
        int expiresIn = result.get("expires_in").getAsInt();
        this.expiresAt = System.currentTimeMillis() + (long)expiresIn * 1000L;
    }
}

