/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.exceptions;

import com.amadeus.Configuration;
import com.amadeus.Response;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Generated;

public class ResponseException
extends Exception {
    private String code;
    private Response response;
    private String description;

    public ResponseException(Response response) {
        super(ResponseException.determineDescription(response));
        this.response = response;
        this.description = ResponseException.determineDescription(response);
        this.determineCode();
    }

    public void log(Configuration configuration) {
        if (configuration.getLogLevel() == "warn") {
            String warning = String.format("Amadeus %s %s", this.code, this.description);
            configuration.getLogger().warning(warning);
        }
    }

    private void determineCode() {
        this.code = this.getClass().getSimpleName();
    }

    private static String determineDescription(Response response) {
        StringBuffer description = ResponseException.determineShortDescription(response);
        description.append(ResponseException.determineLongDescription(response));
        return description.toString();
    }

    private static StringBuffer determineShortDescription(Response response) {
        StringBuffer message = new StringBuffer();
        if (response == null || response.getStatusCode() == 0) {
            message.append("[---]");
        } else {
            message.append(String.format("[%s]", response.getStatusCode()));
        }
        return message;
    }

    private static StringBuffer determineLongDescription(Response response) {
        StringBuffer description = new StringBuffer();
        if (response != null && response.isParsed()) {
            if (response.getResult().has("error_description")) {
                description.append(ResponseException.getErrorDescription(response));
            }
            if (response.getResult().has("errors")) {
                description.append(ResponseException.getErrorsDescription(response));
            }
        }
        return description;
    }

    private static StringBuffer getErrorDescription(Response response) {
        JsonObject result = response.getResult();
        StringBuffer message = new StringBuffer();
        if (response.getResult().has("error")) {
            message.append(String.format("\n%s", result.get("error").getAsString()));
        }
        message.append(String.format("\n%s", result.get("error_description").getAsString()));
        return message;
    }

    private static StringBuffer getErrorsDescription(Response response) {
        StringBuffer message = new StringBuffer();
        String detail = "detail";
        for (JsonElement error : response.getResult().get("errors").getAsJsonArray()) {
            JsonObject source;
            JsonObject json = error.getAsJsonObject();
            message.append("\n");
            if (json.has("source") && (source = json.get("source").getAsJsonObject()).has("parameter")) {
                message.append(String.format("[%s] ", source.get("parameter").getAsString()));
            }
            if (!json.has("detail") || json.get("detail").isJsonNull()) continue;
            message.append(String.format("%s", json.get("detail").getAsString()));
        }
        return message;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Response getResponse() {
        return this.response;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

