/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.referencedata;

import com.amadeus.Amadeus;
import com.amadeus.Params;
import com.amadeus.Response;
import com.amadeus.exceptions.ResponseException;
import com.amadeus.referencedata.locations.Airports;
import com.amadeus.referencedata.locations.Cities;
import com.amadeus.referencedata.locations.Hotel;
import com.amadeus.referencedata.locations.Hotels;
import com.amadeus.referencedata.locations.PointOfInterest;
import com.amadeus.referencedata.locations.PointsOfInterest;
import com.amadeus.resources.Location;
import com.amadeus.resources.Resource;

public class Locations {
    public static String ANY = "AIRPORT,CITY";
    public static String AIRPORT = "AIRPORT";
    public static String CITY = "CITY";
    private Amadeus client;
    public Airports airports;
    public PointsOfInterest pointsOfInterest;
    public PointOfInterest pointOfInterest;
    public Hotels hotels;
    public Hotel hotel;
    public Cities cities;

    public Locations(Amadeus client) {
        this.client = client;
        this.airports = new Airports(client);
        this.pointsOfInterest = new PointsOfInterest(client);
        this.hotels = new Hotels(client);
        this.hotel = new Hotel(client);
        this.cities = new Cities(client);
    }

    public Location[] get(Params params) throws ResponseException {
        Response response = this.client.get("/v1/reference-data/locations", params);
        return (Location[])Resource.fromArray(response, Location[].class);
    }

    public Location[] get() throws ResponseException {
        return this.get(null);
    }

    public PointOfInterest pointOfInterest(String id) {
        return new PointOfInterest(this.client, id);
    }
}

