/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.travel;

import com.amadeus.Amadeus;
import com.amadeus.Response;
import com.amadeus.exceptions.ResponseException;
import com.amadeus.resources.Resource;
import com.amadeus.resources.TripDetail;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Base64;

public class TripParser {
    private Amadeus client;
    private static final String TRIP_PARSER_URL = "/v3/travel/trip-parser";

    public TripParser(Amadeus client) {
        this.client = client;
    }

    public TripDetail post(JsonObject body) throws ResponseException {
        Response response = this.client.post(TRIP_PARSER_URL, body);
        return (TripDetail)Resource.fromObject(response, TripDetail.class);
    }

    public TripDetail post(String body) throws ResponseException {
        Response response = this.client.post(TRIP_PARSER_URL, body);
        return (TripDetail)Resource.fromObject(response, TripDetail.class);
    }

    public TripDetail post(File file) throws ResponseException, IOException {
        try (FileInputStream fileInputStreamReader = new FileInputStream(file);){
            byte[] bytes = new byte[(int)file.length()];
            int count = 0;
            if (fileInputStreamReader.read(bytes) > 0) {
                String encodedFile = Base64.getEncoder().encodeToString(bytes);
                JsonObject body = new JsonObject();
                body.addProperty("payload", encodedFile);
                count += fileInputStreamReader.read(bytes);
                Response response = this.client.post(TRIP_PARSER_URL, body);
                TripDetail tripDetail = (TripDetail)Resource.fromObject(response, TripDetail.class);
                return tripDetail;
            }
        }
        return null;
    }

    public TripDetail post() throws ResponseException {
        return this.post((String)null);
    }
}

