/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import com.amap.api.col.3nl.hx;
import com.amap.api.col.3nl.ib;
import com.amap.api.col.3nl.kz;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.navi.model.AMapNaviCameraInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"NewApi"})
public class AmapCameraOverlay {
    private BitmapDescriptor mCameraIcon = null;
    private BitmapDescriptor mBusLeftIcon = null;
    private BitmapDescriptor mBusRightIcon = null;
    private BitmapDescriptor mCameraRightIcon = null;
    private BitmapDescriptor mCameraLeftIcon = null;
    private BitmapDescriptor mYingjiRightIcon = null;
    private BitmapDescriptor mYingjiLeftIcon = null;
    private BitmapDescriptor mRedRightIcon = null;
    private BitmapDescriptor mRedLeftIcon = null;
    private Bitmap mSpeedRightIcon = null;
    private Bitmap mSpeedLeftIcon = null;
    private Map<String, List<Marker>> markerMap = new HashMap<String, List<Marker>>();
    private Context mContext;
    private Resources mResources;
    private boolean mLastFlag = false;
    private boolean mIsCameraVisible = true;
    private boolean mIsRouteVisible = true;

    public AmapCameraOverlay(Context object) {
        try {
            this.mContext = object;
            this.mResources = ib.b(object);
            this.mCameraIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837546));
            this.mBusLeftIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837572));
            this.mBusRightIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837573));
            this.mCameraLeftIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837574));
            this.mCameraRightIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837575));
            this.mYingjiLeftIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837576));
            this.mYingjiRightIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837577));
            this.mRedLeftIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837578));
            this.mRedRightIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837579));
            this.mSpeedRightIcon = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837581);
            this.mSpeedLeftIcon = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837580);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            kz.c((Throwable)object, "CameraOverlay", "CameraOverlay()");
            return;
        }
    }

    public void draw(AMap aMap, AMapNaviCameraInfo[] aMapNaviCameraInfoArray) {
        if (aMap == null) {
            return;
        }
        try {
            Object object;
            if (aMapNaviCameraInfoArray == null || aMapNaviCameraInfoArray.length == 0) {
                this.removeAllCamera();
                return;
            }
            Object object2 = aMapNaviCameraInfoArray;
            int n2 = aMapNaviCameraInfoArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                boolean bl2;
                Object object3 = object2[i2];
                object = ((AMapNaviCameraInfo)object3).getX() + "-" + ((AMapNaviCameraInfo)object3).getCameraType() + "-" + ((AMapNaviCameraInfo)object3).getY();
                if (this.markerMap.containsKey(object)) {
                    new StringBuilder("key \u5305\u542b\u5728 map \u4e2d,\u8ddd\u79bb\u6444\u50cf\u5934:").append(((AMapNaviCameraInfo)object3).getCameraDistance()).append("\u7c73");
                    continue;
                }
                if (this.mLastFlag) {
                    bl2 = false;
                    this.mLastFlag = false;
                } else {
                    bl2 = true;
                    this.mLastFlag = true;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n3 = ((AMapNaviCameraInfo)object3).getCameraType();
                float f2 = 0.0f;
                if (bl2) {
                    f2 = 1.0f;
                }
                Marker marker = aMap.addMarker(new MarkerOptions().position(new LatLng(((AMapNaviCameraInfo)object3).getY(), ((AMapNaviCameraInfo)object3).getX())).anchor(0.5f, 0.5f).icon(this.mCameraIcon));
                marker.setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                arrayList.add(marker);
                new StringBuilder("key \u4e0d\u5305\u542b\u5728 map \u4e2d,\u6444\u50cf\u5934\u7c7b\u578b=").append(n3).append(",\u8ddd\u79bb:").append(((AMapNaviCameraInfo)object3).getCameraDistance());
                switch (n3) {
                    case 0: {
                        Object object4;
                        int n4;
                        TextView textView = new TextView(this.mContext);
                        textView.setTextColor(-16777216);
                        textView.setGravity(49);
                        int n5 = ((AMapNaviCameraInfo)object3).getCameraSpeed();
                        int n6 = 0;
                        int n7 = 0;
                        if (n5 > 99 || n5 <= 0) {
                            textView.setTextSize(1, 17.0f);
                            n4 = hx.a(this.mContext, 10);
                        } else {
                            textView.setTextSize(1, 20.0f);
                            n4 = hx.a(this.mContext, 8);
                        }
                        if (bl2) {
                            n7 = hx.a(this.mContext, 3);
                        } else {
                            n6 = hx.a(this.mContext, 3);
                        }
                        textView.setPadding(n6, n4, n7, 0);
                        textView.setText((CharSequence)(n5 > 0 ? String.valueOf(n5) : "\u6d4b\u901f"));
                        Bitmap bitmap = object4 = bl2 ? this.mSpeedLeftIcon : this.mSpeedRightIcon;
                        if (Build.VERSION.SDK_INT >= 17) {
                            textView.setBackground((Drawable)new BitmapDrawable(this.mResources, object4));
                        } else {
                            textView.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mResources, object4));
                        }
                        object4 = BitmapDescriptorFactory.fromView((View)textView);
                        object3 = aMap.addMarker(new MarkerOptions().position(new LatLng(((AMapNaviCameraInfo)object3).getY(), ((AMapNaviCameraInfo)object3).getX())).anchor(f2, 0.7f).icon((BitmapDescriptor)object4));
                        ((Marker)object3).setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                        arrayList.add(object3);
                        break;
                    }
                    case 1: 
                    case 3: {
                        object3 = aMap.addMarker(new MarkerOptions().position(new LatLng(((AMapNaviCameraInfo)object3).getY(), ((AMapNaviCameraInfo)object3).getX())).anchor(f2, 0.7f).icon(bl2 ? this.mCameraLeftIcon : this.mCameraRightIcon));
                        ((Marker)object3).setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                        arrayList.add(object3);
                        break;
                    }
                    case 2: {
                        object3 = aMap.addMarker(new MarkerOptions().position(new LatLng(((AMapNaviCameraInfo)object3).getY(), ((AMapNaviCameraInfo)object3).getX())).anchor(f2, 0.7f).icon(bl2 ? this.mRedLeftIcon : this.mRedRightIcon));
                        ((Marker)object3).setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                        arrayList.add(object3);
                        break;
                    }
                    case 5: {
                        object3 = aMap.addMarker(new MarkerOptions().position(new LatLng(((AMapNaviCameraInfo)object3).getY(), ((AMapNaviCameraInfo)object3).getX())).anchor(f2, 0.7f).icon(bl2 ? this.mYingjiLeftIcon : this.mYingjiRightIcon));
                        ((Marker)object3).setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                        arrayList.add(object3);
                        break;
                    }
                    case 4: {
                        object3 = aMap.addMarker(new MarkerOptions().position(new LatLng(((AMapNaviCameraInfo)object3).getY(), ((AMapNaviCameraInfo)object3).getX())).anchor(f2, 0.7f).icon(bl2 ? this.mBusLeftIcon : this.mBusRightIcon));
                        ((Marker)object3).setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                        arrayList.add(object3);
                    }
                }
                this.markerMap.put((String)object, arrayList);
            }
            object2 = new ArrayList();
            for (Map.Entry<String, List<Marker>> entry : this.markerMap.entrySet()) {
                boolean bl3 = false;
                object = aMapNaviCameraInfoArray;
                int n8 = aMapNaviCameraInfoArray.length;
                for (int i3 = 0; i3 < n8; ++i3) {
                    AMapNaviCameraInfo aMapNaviCameraInfo = object[i3];
                    if (!(aMapNaviCameraInfo.getX() + "-" + aMapNaviCameraInfo.getCameraType() + "-" + aMapNaviCameraInfo.getY()).equals(entry.getKey())) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                object2.add(entry.getKey());
                object = entry.getValue().iterator();
                while (object.hasNext()) {
                    ((Marker)object.next()).remove();
                }
            }
            Iterator<Map.Entry<String, List<Marker>>> iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)((Object)iterator.next());
                this.markerMap.remove(string2);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "CameraOverlay", "draw(AMap aMap, LatLng latLng)");
            return;
        }
    }

    public void removeAllCamera() {
        try {
            Iterator<List<Marker>> iterator = this.markerMap.values().iterator();
            while (iterator.hasNext()) {
                Iterator<Marker> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().remove();
                }
            }
            this.markerMap.clear();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setRouteOverlayVisible(boolean bl2) {
        try {
            this.mIsRouteVisible = bl2;
            Iterator<List<Marker>> iterator = this.markerMap.values().iterator();
            while (iterator.hasNext()) {
                Iterator<Marker> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setAllCameraVisible(boolean bl2) {
        try {
            this.mIsCameraVisible = bl2;
            Iterator<List<Marker>> iterator = this.markerMap.values().iterator();
            while (iterator.hasNext()) {
                Iterator<Marker> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().setVisible(this.mIsCameraVisible && this.mIsRouteVisible);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void destroy() {
        try {
            this.removeAllCamera();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setCameraBitmap(Bitmap bitmap) {
        try {
            if (bitmap != null) {
                this.mCameraIcon = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setBusBitmap(Bitmap bitmap, Bitmap bitmap2) {
        try {
            if (bitmap != null) {
                this.mBusLeftIcon = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            if (bitmap2 != null) {
                this.mBusRightIcon = BitmapDescriptorFactory.fromBitmap(bitmap2);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setCameraMoniterBitmap(Bitmap bitmap, Bitmap bitmap2) {
        try {
            if (bitmap != null) {
                this.mCameraLeftIcon = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            if (bitmap2 != null) {
                this.mCameraRightIcon = BitmapDescriptorFactory.fromBitmap(bitmap2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setEmergencyBitmap(Bitmap bitmap, Bitmap bitmap2) {
        try {
            if (bitmap != null) {
                this.mYingjiLeftIcon = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            if (bitmap2 != null) {
                this.mYingjiRightIcon = BitmapDescriptorFactory.fromBitmap(bitmap2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setRedLightBitmap(Bitmap bitmap, Bitmap bitmap2) {
        try {
            if (bitmap != null) {
                this.mRedLeftIcon = BitmapDescriptorFactory.fromBitmap(bitmap);
            }
            if (bitmap2 != null) {
                this.mRedRightIcon = BitmapDescriptorFactory.fromBitmap(bitmap2);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

