/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.util.Pair;
import com.amap.api.col.3nl.hw;
import com.amap.api.col.3nl.hx;
import com.amap.api.col.3nl.kz;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.maps.utils.SpatialRelationUtil;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.model.AMapNaviLink;
import com.amap.api.navi.model.AMapNaviLocation;
import com.amap.api.navi.model.AMapNaviPath;
import com.amap.api.navi.model.AMapNaviStep;
import com.amap.api.navi.model.NaviLatLng;
import com.amap.api.navi.model.RouteOverlayOptions;
import com.amap.api.navi.view.BaseRouteOverLay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RouteOverLay
extends BaseRouteOverLay {
    public RouteOverLay(AMap aMap, AMapNaviPath aMapNaviPath, Context context) {
        try {
            this.init(context, aMap, aMapNaviPath);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    protected void init(Context object, AMap aMap, AMapNaviPath aMapNaviPath) {
        super.init((Context)object, aMap, aMapNaviPath);
        try {
            this.mTrafficColorfulPolylineOptions = new PolylineOptions().transparency(1.0f).lineJoinType(PolylineOptions.LineJoinType.LineJoinRound).lineCapType(PolylineOptions.LineCapType.LineCapRound);
            this.mTrafficColorfulPolyline = this.mAMap.addPolyline(this.mTrafficColorfulPolylineOptions);
            this.updateColorfulPolylineOptions();
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            kz.c((Throwable)object, "RouteOverLay", "init(AMap amap, AMapNaviPath aMapNaviPath)");
            return;
        }
    }

    private void updateColorfulPolylineOptions() {
        ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
        arrayList.add(this.unknownTraffic);
        arrayList.add(this.smoothTraffic);
        arrayList.add(this.slowTraffic);
        arrayList.add(this.jamTraffic);
        arrayList.add(this.veryJamTraffic);
        arrayList.add(this.fairWayRes);
        this.mTrafficColorfulPolylineOptions.setCustomTextureList(arrayList);
        this.mTrafficColorfulPolylineOptions.width(this.mWidth);
        this.mTrafficColorfulPolylineOptions.showPolylineRangeEnabled(true);
        this.mTrafficColorfulPolylineOptions.setEraseTexture(true, this.passRoute);
        this.mTrafficColorfulPolylineOptions.setFootPrintTexture(this.showArrowOnRoute ? this.arrowOnRoute : null);
        this.mTrafficColorfulPolyline.setOptions(this.mTrafficColorfulPolylineOptions);
    }

    @Override
    public void setRouteOverlayOptions(RouteOverlayOptions routeOverlayOptions) {
        if (routeOverlayOptions == null) {
            return;
        }
        try {
            this.mRouteOverlayOptions = routeOverlayOptions;
            if (routeOverlayOptions.getArrowOnTrafficRoute() != null) {
                this.arrowOnRoute = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getArrowOnTrafficRoute());
            }
            if (routeOverlayOptions.getUnknownTraffic() != null) {
                this.unknownTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getUnknownTraffic());
            }
            if (routeOverlayOptions.getSmoothTraffic() != null) {
                this.smoothTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getSmoothTraffic());
            }
            if (routeOverlayOptions.getSlowTraffic() != null) {
                this.slowTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getSlowTraffic());
            }
            if (routeOverlayOptions.getJamTraffic() != null) {
                this.jamTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getJamTraffic());
            }
            if (routeOverlayOptions.getVeryJamTraffic() != null) {
                this.veryJamTraffic = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getVeryJamTraffic());
            }
            if (routeOverlayOptions.getPassRoute() != null) {
                this.passRoute = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getPassRoute());
            }
            if (routeOverlayOptions.getFairWayRes() != null) {
                this.fairWayRes = BitmapDescriptorFactory.fromBitmap(routeOverlayOptions.getFairWayRes());
            }
            if (routeOverlayOptions.getLineWidth() > 0.0f) {
                this.mWidth = routeOverlayOptions.getLineWidth();
            }
            this.turnArrowIs3D = routeOverlayOptions.isTurnArrowIs3D();
            this.arrowColor = routeOverlayOptions.getArrowColor();
            this.arrowSideColor = routeOverlayOptions.getArrowSideColor();
            this.updateColorfulPolylineOptions();
            if (this.mTurnArrow != null) {
                this.mTurnArrow.setTopColor(this.arrowColor);
                this.mTurnArrow.setSideColor(this.arrowSideColor);
                this.mTurnArrow.setWidth(this.mWidth * 0.7f);
                this.mTurnArrow.set3DModel(this.turnArrowIs3D);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public void addToMap() {
        try {
            if (!this.isAllOverlayVisible) {
                return;
            }
            this.removeFromMap();
            this.drawMarker();
            boolean bl2 = this.isTrafficLine && this.mAMapNaviPath.getTrafficStatuses() != null && !this.mAMapNaviPath.getTrafficStatuses().isEmpty();
            this.drawColorfulPolyline(bl2);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "addToMap()");
            return;
        }
    }

    private void drawMarker() {
        this.handleLimitAndForbiddenInfos();
        this.drawLights();
        this.drawPoi();
        RouteOverLay routeOverLay = this;
        routeOverLay.drawArrow(routeOverLay.arrowPoints);
    }

    @Override
    public void removeFromMap() {
        try {
            this.clearMarkers();
            this.clearCustomPolyline();
            this.clearTrafficLine();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "removeFromMap()");
            return;
        }
    }

    private void clearCustomPolyline() {
        for (Polyline polyline : this.mCustomPolyLines) {
            if (polyline == null) continue;
            polyline.remove();
        }
        this.mCustomPolyLines.clear();
    }

    private void clearTrafficLine() {
        Iterator iterator = this.ferryMarkers.iterator();
        while (iterator.hasNext()) {
            ((Marker)iterator.next()).remove();
        }
        this.ferryMarkers.clear();
        if (this.mTrafficColorfulPolylineOptions != null) {
            this.mTrafficColorfulPolylineOptions.setPoints(new ArrayList<LatLng>());
            this.mTrafficColorfulPolylineOptions.setCustomTextureIndex(new ArrayList<Integer>());
            this.mTrafficColorfulPolylineOptions.visible(false);
        }
        if (this.mTrafficColorfulPolyline != null) {
            this.mTrafficColorfulPolyline.setVisible(false);
        }
    }

    protected void drawColorfulPolyline(boolean bl2) {
        try {
            hw<LatLng> hw2 = new hw<LatLng>();
            hw<LatLng> hw3 = new hw<LatLng>();
            NaviLatLng naviLatLng = this.mAMapNaviPath.getCarToFootPoint();
            List<AMapNaviStep> list = this.mAMapNaviPath.getSteps();
            ArrayList<AMapNaviLink> arrayList = new ArrayList<AMapNaviLink>();
            boolean bl3 = false;
            boolean bl4 = false;
            int n2 = -1;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AMapNaviStep aMapNaviStep = list.get(i2);
                List<AMapNaviLink> list2 = aMapNaviStep.getLinks();
                if (list2.get(0).getLinkType() == 1) {
                    if (hw2.size() > 1) {
                        this.drawTrafficPolyline(hw2, n2, bl2);
                    }
                    this.drawFairWayPositionIcon(aMapNaviStep);
                    this.drawFairWayLine(list2);
                    hw2.clear();
                    n2 = -1;
                    continue;
                }
                float f2 = -1.0f;
                if (naviLatLng != null) {
                    f2 = hx.a(this.mAMapNaviPath.getStartPoint(), naviLatLng);
                }
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    AMapNaviLink aMapNaviLink = list2.get(i3);
                    int n3 = aMapNaviLink.getRoadClass();
                    String string2 = aMapNaviLink.getRoadName();
                    if (!bl3 && ("\u5185\u90e8\u9053\u8def".equals(string2) || "\u65e0\u540d\u9053\u8def".equals(string2)) && n3 == 10) {
                        arrayList.add(aMapNaviLink);
                        continue;
                    }
                    if (!bl3 && arrayList.size() > 0) {
                        this.drawFairWayLine(arrayList);
                        arrayList.clear();
                    }
                    bl3 = true;
                    n3 = aMapNaviLink.getTrafficStatus();
                    if (hw2.size() > 0 && n2 != -1 && (n2 != n3 || bl4)) {
                        this.drawTrafficPolyline(hw2, n2, bl2);
                    }
                    n2 = n3;
                    for (int i4 = 0; i4 < aMapNaviLink.getCoords().size(); ++i4) {
                        LatLng latLng = hx.a(aMapNaviLink.getCoords().get(i4), false);
                        if (!bl4 && f2 != -1.0f && Math.abs(latLng.latitude - naviLatLng.getLatitude()) < 5.0E-6 && Math.abs(latLng.longitude - naviLatLng.getLongitude()) < 5.0E-6) {
                            if (hw2.size() > 0) {
                                this.drawTrafficPolyline(hw2, n3, bl2);
                            }
                            bl4 = true;
                        }
                        if (!bl4) {
                            if (!hw2.isEmpty()) {
                                hw<LatLng> hw4 = hw2;
                                if (((LatLng)hw4.get(hw4.size() - 1)).equals(latLng)) continue;
                            }
                            hw2.add(latLng);
                            continue;
                        }
                        if (!hw3.isEmpty()) {
                            hw<LatLng> hw5 = hw3;
                            if (((LatLng)hw5.get(hw5.size() - 1)).equals(latLng)) continue;
                        }
                        hw3.add(latLng);
                    }
                    if (i2 != list.size() - 1 || i3 != list2.size() - 1) continue;
                    if (hw2.size() > 0) {
                        this.drawTrafficPolyline(hw2, n3, bl2);
                    }
                    if (hw3.size() <= 0) continue;
                    this.drawTrafficPolyline(hw3, 5, bl2);
                }
            }
            this.mTrafficColorfulPolylineOptions.setPolylineShowRange(0.0f, this.mTrafficColorfulPolylineOptions.getPoints().size() - 1);
            this.mTrafficColorfulPolylineOptions.visible(true);
            this.mTrafficColorfulPolyline.setOptions(this.mTrafficColorfulPolylineOptions);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    protected void drawTrafficPolyline(List<LatLng> list, int n2, boolean bl2) {
        List<BitmapDescriptor> list2 = this.mTrafficColorfulPolylineOptions.getCustomTextureList();
        boolean bl3 = n2 >= 0 && n2 < list2.size();
        hw<LatLng> hw2 = new hw<LatLng>((Collection<LatLng>)this.mTrafficColorfulPolylineOptions.getPoints());
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mTrafficColorfulPolylineOptions.getCustomTextureIndex());
        for (LatLng latLng : list) {
            if (!hw2.add(latLng)) continue;
            if (bl3 && bl2) {
                arrayList.add(n2);
                continue;
            }
            arrayList.add(0);
        }
        this.mTrafficColorfulPolylineOptions.setPoints(hw2);
        this.mTrafficColorfulPolylineOptions.setCustomTextureIndex(arrayList);
        list.clear();
    }

    protected void drawFairWayLine(List<AMapNaviLink> hw2) {
        Object object2 = new ArrayList();
        hw2 = hw2.iterator();
        while (hw2.hasNext()) {
            for (NaviLatLng naviLatLng : ((AMapNaviLink)hw2.next()).getCoords()) {
                LatLng object3 = new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude(), false);
                if (!object2.isEmpty()) {
                    Object object = object2;
                    if (((LatLng)object.get(object.size() - 1)).equals(object3)) continue;
                }
                object2.add(object3);
            }
        }
        hw2 = new hw<LatLng>();
        hw2.addAll((Collection<LatLng>)this.mTrafficColorfulPolylineOptions.getPoints());
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mTrafficColorfulPolylineOptions.getCustomTextureIndex());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            LatLng latLng = (LatLng)object2.next();
            if (!hw2.add(latLng)) continue;
            arrayList.add(5);
        }
        this.mTrafficColorfulPolylineOptions.setPoints(hw2);
        this.mTrafficColorfulPolylineOptions.setCustomTextureIndex(arrayList);
    }

    private void drawFairWayPositionIcon(AMapNaviStep object) {
        object = hx.a(((AMapNaviStep)object).getCoords().get(0), true);
        object = this.mAMap.addMarker(new MarkerOptions().position((LatLng)object).anchor(0.5f, 0.5f).icon(BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837538))));
        ((Marker)object).setVisible(this.showFootFerryMarker);
        this.ferryMarkers.add(object);
    }

    @Override
    public void destroy() {
        try {
            this.removeFromMap();
            if (this.mTrafficColorfulPolyline != null) {
                this.mTrafficColorfulPolyline.remove();
                this.mTrafficColorfulPolyline = null;
            }
            this.mAMapNaviPath = null;
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "destroy()");
            return;
        }
    }

    @Override
    public void setArrowOnRoute(boolean bl2) {
        this.showArrowOnRoute = bl2;
        if (this.mTrafficColorfulPolylineOptions != null) {
            this.mTrafficColorfulPolylineOptions.setFootPrintTexture(this.showArrowOnRoute ? this.arrowOnRoute : null);
        }
    }

    @Override
    public void addToMap(int[] nArray, int[] nArray2) {
        try {
            if (nArray == null || nArray.length == 0) {
                return;
            }
            if (!this.isAllOverlayVisible) {
                return;
            }
            this.removeFromMap();
            this.drawMarker();
            this.drawCustomPolyline(nArray, nArray2, null);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public void addToMap(BitmapDescriptor[] bitmapDescriptorArray, int[] nArray) {
        try {
            if (bitmapDescriptorArray == null || bitmapDescriptorArray.length == 0) {
                return;
            }
            if (!this.isAllOverlayVisible) {
                return;
            }
            this.removeFromMap();
            this.drawMarker();
            this.drawCustomPolyline(null, nArray, bitmapDescriptorArray);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public void setTransparency(float f2) {
        try {
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (this.mTrafficColorfulPolyline != null) {
                this.mTrafficColorfulPolyline.setTransparency(f2);
            }
            if (this.mTrafficColorfulPolylineOptions != null) {
                this.mTrafficColorfulPolylineOptions.transparency(f2);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public void setZindex(int n2) {
        try {
            if (this.mTrafficColorfulPolylineOptions != null) {
                this.mTrafficColorfulPolylineOptions.zIndex(n2);
            }
            if (this.mTrafficColorfulPolyline != null) {
                this.mTrafficColorfulPolyline.setZIndex(n2);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void handleLimitAndForbiddenInfos() {
        try {
            if (this.naviLimitOverlay != null) {
                this.naviLimitOverlay.removeAllMarker();
                if (this.mAMapNaviPath.getLimitInfos() != null) {
                    this.naviLimitOverlay.drawLimitInfo(this.mAMapNaviPath.getLimitInfos());
                }
                if (this.mAMapNaviPath.getForbiddenInfos() != null) {
                    this.naviLimitOverlay.drawForbiddenInfo(this.mAMapNaviPath.getForbiddenInfos());
                }
                if (this.mAMapNaviPath.getTrafficIncidentInfo() != null) {
                    this.naviLimitOverlay.drawIncidentInfo(this.mAMapNaviPath.getTrafficIncidentInfo());
                }
                this.naviLimitOverlay.setVisible(this.showForbiddenMarker);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public void updatePolyline(AMapNaviLocation object) {
        try {
            this.mCurrentLocation = object;
            if (!this.isAllOverlayVisible) {
                return;
            }
            if (!this.isLocationValid((AMapNaviLocation)object)) {
                return;
            }
            if (!this.showPassRoute) {
                return;
            }
            int n2 = ((AMapNaviLocation)object).getCurStepIndex();
            int n3 = ((AMapNaviLocation)object).getCurLinkIndex();
            int n4 = ((AMapNaviLocation)object).getCurPointIndex();
            NaviLatLng naviLatLng = ((AMapNaviLocation)object).getCoord();
            NaviLatLng naviLatLng2 = null;
            NaviLatLng naviLatLng3 = null;
            object = ((AMapNaviLocation)object).getCoord();
            List<AMapNaviStep> list = this.mAMapNaviPath.getSteps();
            block2: for (int i2 = n2; i2 < list.size(); ++i2) {
                List<AMapNaviLink> list2 = list.get(i2).getLinks();
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    List<NaviLatLng> list3 = list2.get(i3).getCoords();
                    for (int i4 = 0; i4 < list3.size(); ++i4) {
                        if (naviLatLng2 != null) {
                            naviLatLng3 = list3.get(i4);
                            if (naviLatLng2.getLatitude() != naviLatLng3.getLatitude() || naviLatLng2.getLongitude() != naviLatLng3.getLongitude()) break block2;
                        }
                        if (i2 != n2 || i3 != n3 || i4 != n4) continue;
                        naviLatLng2 = list3.get(i4);
                    }
                }
            }
            float f2 = hx.a(naviLatLng2, (NaviLatLng)object);
            float f3 = hx.a(naviLatLng2, naviLatLng3);
            f3 = f2 / f3;
            hw<LatLng> hw2 = this.getPassedPoint(naviLatLng, n2, n3, n4);
            this.mTrafficColorfulPolyline.setPolylineShowRange((float)(hw2.size() - 2) + f3, this.mTrafficColorfulPolyline.getPoints().size() - 1);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private boolean isLocationValid(AMapNaviLocation aMapNaviLocation) {
        if (this.mContext == null || this.mAMapNaviPath == null || aMapNaviLocation == null) {
            return false;
        }
        try {
            int n2 = AMapNavi.getInstance(this.mContext).getNaviType();
            if (n2 != 1 && n2 != 2) {
                return false;
            }
            if (!aMapNaviLocation.isMatchNaviPath()) {
                return false;
            }
            int n3 = aMapNaviLocation.getCurStepIndex();
            if (n3 < 0 || n3 >= this.mAMapNaviPath.getStepsCount()) {
                return false;
            }
            Iterator<NaviLatLng> iterator = this.mAMapNaviPath.getSteps().get(n3);
            int n4 = aMapNaviLocation.getCurLinkIndex();
            if (iterator == null || n4 < 0 || n4 >= ((AMapNaviStep)((Object)iterator)).getLinks().size()) {
                return false;
            }
            if ((iterator = ((AMapNaviStep)((Object)iterator)).getLinks().get(n4)) == null) {
                return false;
            }
            if (AMapNavi.getInstance(this.mContext).getEngineType() != 0 && n2 == 1) {
                ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
                for (NaviLatLng naviLatLng : ((AMapNaviLink)((Object)iterator)).getCoords()) {
                    arrayList.add(new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude()));
                }
                iterator = SpatialRelationUtil.calShortestDistancePoint(arrayList, new LatLng(aMapNaviLocation.getCoord().getLatitude(), aMapNaviLocation.getCoord().getLongitude()));
                return hx.a(new NaviLatLng(((LatLng)((Pair)iterator).second).latitude, ((LatLng)((Pair)iterator).second).longitude), aMapNaviLocation.getCoord()) <= 0.5f;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private hw<LatLng> getPassedPoint(NaviLatLng naviLatLng, int n2, int n3, int n4) {
        NaviLatLng naviLatLng2;
        int n5;
        List<AMapNaviLink> list;
        List<Object> list2 = this.mAMapNaviPath.getSteps();
        hw<LatLng> hw2 = new hw<LatLng>();
        for (int i2 = 0; i2 < n2; ++i2) {
            list = list2.get(i2).getLinks();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                List<NaviLatLng> list3 = list.get(i3).getCoords();
                for (n5 = 0; n5 < list3.size(); ++n5) {
                    naviLatLng2 = list3.get(n5);
                    hw2.add(new LatLng(naviLatLng2.getLatitude(), naviLatLng2.getLongitude()));
                }
            }
        }
        list = list2.get(n2).getLinks();
        for (n2 = 0; n2 < n3 && n2 < list.size(); ++n2) {
            list2 = list.get(n2).getCoords();
            int n6 = list2.size();
            for (n5 = 0; n5 < n6; ++n5) {
                naviLatLng2 = (NaviLatLng)list2.get(n5);
                hw2.add(new LatLng(naviLatLng2.getLatitude(), naviLatLng2.getLongitude()));
            }
        }
        List<NaviLatLng> list4 = list.get(n3).getCoords();
        for (int i4 = 0; i4 < n4 + 1; ++i4) {
            NaviLatLng naviLatLng3 = list4.get(i4);
            hw2.add(new LatLng(naviLatLng3.getLatitude(), naviLatLng3.getLongitude()));
        }
        hw2.add(new LatLng(naviLatLng.getLatitude(), naviLatLng.getLongitude()));
        return hw2;
    }

    @Override
    public void onArriveDestination() {
        super.onArriveDestination();
        if (this.showPassRoute && this.mTrafficColorfulPolyline != null) {
            this.mTrafficColorfulPolyline.setPolylineShowRange(0.0f, 0.0f);
        }
    }

    @Override
    public void setPassRouteVisible(boolean bl2) {
        this.showPassRoute = bl2;
        if (this.showPassRoute) {
            RouteOverLay routeOverLay = this;
            routeOverLay.updatePolyline(routeOverLay.mCurrentLocation);
            return;
        }
        if (this.mTrafficColorfulPolyline != null) {
            this.mTrafficColorfulPolyline.setPolylineShowRange(0.0f, this.mTrafficColorfulPolyline.getPoints().size() - 1);
        }
    }

    @Override
    public List<String> getPolylineIdList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mTrafficColorfulPolyline != null) {
            arrayList.add(this.mTrafficColorfulPolyline.getId());
        }
        return arrayList;
    }
}

