/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import com.autonavi.ae.svg.CSSParser;
import com.autonavi.ae.svg.PreserveAspectRatio;
import com.autonavi.ae.svg.SVG;

public class RenderOptions {
    CSSParser.Ruleset css = null;
    PreserveAspectRatio preserveAspectRatio = null;
    String targetId = null;
    SVG.Box viewBox = null;
    String viewId = null;
    SVG.Box viewPort = null;

    public RenderOptions() {
    }

    public static RenderOptions create() {
        return new RenderOptions();
    }

    public RenderOptions(RenderOptions renderOptions) {
        if (renderOptions != null) {
            this.css = renderOptions.css;
            this.preserveAspectRatio = renderOptions.preserveAspectRatio;
            this.viewBox = renderOptions.viewBox;
            this.viewId = renderOptions.viewId;
            this.viewPort = renderOptions.viewPort;
        }
    }

    public RenderOptions css(String string2) {
        CSSParser cSSParser = new CSSParser(CSSParser.Source.RenderOptions);
        this.css = cSSParser.parse(string2);
        return this;
    }

    public boolean hasCss() {
        return this.css != null && this.css.ruleCount() > 0;
    }

    public RenderOptions preserveAspectRatio(PreserveAspectRatio preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
        return this;
    }

    public boolean hasPreserveAspectRatio() {
        return this.preserveAspectRatio != null;
    }

    public RenderOptions view(String string2) {
        this.viewId = string2;
        return this;
    }

    public boolean hasView() {
        return this.viewId != null;
    }

    public RenderOptions viewBox(float f2, float f3, float f4, float f5) {
        this.viewBox = new SVG.Box(f2, f3, f4, f5);
        return this;
    }

    public boolean hasViewBox() {
        return this.viewBox != null;
    }

    public RenderOptions viewPort(float f2, float f3, float f4, float f5) {
        this.viewPort = new SVG.Box(f2, f3, f4, f5);
        return this;
    }

    public boolean hasViewPort() {
        return this.viewPort != null;
    }

    public RenderOptions target(String string2) {
        this.targetId = string2;
        return this;
    }

    public boolean hasTarget() {
        return this.targetId != null;
    }
}

