/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.CommitMessages;
import com.amashchenko.maven.plugin.gitflow.GitFlowConfig;
import com.amashchenko.maven.plugin.gitflow.StringBufferStreamConsumer;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractGitFlowMojo
extends AbstractMojo {
    private static final String VERSIONS_MAVEN_PLUGIN_SET_GOAL = "org.codehaus.mojo:versions-maven-plugin:set";
    private static final String TYCHO_VERSIONS_PLUGIN_SET_GOAL = "org.eclipse.tycho:tycho-versions-plugin:set-version";
    protected static final String LS = System.getProperty("line.separator");
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final Pattern MAVEN_DISALLOWED_PATTERN = Pattern.compile("[&|;]");
    private final Commandline cmdGit = new Commandline();
    private final Commandline cmdMvn = new Commandline();
    @Parameter(defaultValue="${gitFlowConfig}")
    protected GitFlowConfig gitFlowConfig;
    @Parameter(defaultValue="${commitMessages}")
    protected CommitMessages commitMessages;
    @Parameter(defaultValue="false")
    protected boolean tychoBuild;
    @Parameter(property="installProject", defaultValue="false")
    protected boolean installProject = false;
    @Parameter(property="fetchRemote", defaultValue="true")
    protected boolean fetchRemote;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose = false;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter(property="gpgSignCommit", defaultValue="false")
    private boolean gpgSignCommit = false;
    @Parameter(property="versionsForceUpdate", defaultValue="false")
    private boolean versionsForceUpdate = false;
    @Parameter(property="mvnExecutable")
    private String mvnExecutable;
    @Parameter(property="gitExecutable")
    private String gitExecutable;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    protected Prompter prompter;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;

    private void initExecutables() {
        if (StringUtils.isBlank((String)this.cmdMvn.getExecutable())) {
            if (StringUtils.isBlank((String)this.mvnExecutable)) {
                this.mvnExecutable = "mvn";
            }
            this.cmdMvn.setExecutable(this.mvnExecutable);
        }
        if (StringUtils.isBlank((String)this.cmdGit.getExecutable())) {
            if (StringUtils.isBlank((String)this.gitExecutable)) {
                this.gitExecutable = "git";
            }
            this.cmdGit.setExecutable(this.gitExecutable);
        }
    }

    protected void validateConfiguration(String ... params) throws MojoFailureException {
        if (StringUtils.isNotBlank((String)this.argLine) && MAVEN_DISALLOWED_PATTERN.matcher(this.argLine).find()) {
            throw new MojoFailureException("The argLine doesn't match allowed pattern.");
        }
        if (params != null && params.length > 0) {
            for (String p : params) {
                if (!StringUtils.isNotBlank((String)p) || !MAVEN_DISALLOWED_PATTERN.matcher(p).find()) continue;
                throw new MojoFailureException("The '" + p + "' value doesn't match allowed pattern.");
            }
        }
    }

    protected String getCurrentProjectVersion() throws MojoFailureException {
        Model model = this.readModel(this.mavenSession.getCurrentProject());
        if (model.getVersion() == null) {
            throw new MojoFailureException("Cannot get current project version. This plugin should be executed from the parent project.");
        }
        return model.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model readModel(MavenProject project) throws MojoFailureException {
        try {
            Model model;
            FileReader fileReader = new FileReader(project.getFile().getAbsoluteFile());
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            try {
                model = mavenReader.read((Reader)fileReader);
            }
            finally {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            return model;
        }
        catch (Exception e) {
            throw new MojoFailureException("", (Throwable)e);
        }
    }

    protected boolean notSameProdDevName() {
        return !this.gitFlowConfig.getProductionBranch().equals(this.gitFlowConfig.getDevelopmentBranch());
    }

    protected void checkUncommittedChanges() throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)"Checking for uncommitted changes.");
        if (this.executeGitHasUncommitted()) {
            throw new MojoFailureException("You have some uncommitted files. Commit or discard local changes in order to proceed.");
        }
    }

    protected void checkSnapshotDependencies() throws MojoFailureException {
        this.getLog().info((CharSequence)"Checking for SNAPSHOT versions in dependencies.");
        ArrayList<String> snapshots = new ArrayList<String>();
        ArrayList<String> builtArtifacts = new ArrayList<String>();
        List projects = this.mavenSession.getProjects();
        for (MavenProject project : projects) {
            Model model = this.readModel(project);
            builtArtifacts.add(model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion());
            List dependencies = model.getDependencies();
            for (Dependency d : dependencies) {
                String id = d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getVersion();
                if (builtArtifacts.contains(id) || !ArtifactUtils.isSnapshot((String)d.getVersion())) continue;
                snapshots.add(model + " -> " + d);
            }
        }
        if (!snapshots.isEmpty()) {
            for (String s : snapshots) {
                this.getLog().warn((CharSequence)s);
            }
            throw new MojoFailureException("There is some SNAPSHOT dependencies in the project, see warnings above. Change them or ignore with `allowSnapshots` property.");
        }
    }

    protected boolean validBranchName(String branchName) throws MojoFailureException, CommandLineException {
        CommandResult r = this.executeGitCommandExitCode("check-ref-format", "--allow-onelevel", branchName);
        return r.getExitCode() == 0;
    }

    private boolean executeGitHasUncommitted() throws MojoFailureException, CommandLineException {
        boolean uncommited = false;
        CommandResult diffCommandResult = this.executeGitCommandExitCode("diff", "--no-ext-diff", "--ignore-submodules", "--quiet", "--exit-code");
        String error = null;
        if (diffCommandResult.getExitCode() == 0) {
            CommandResult diffIndexCommandResult = this.executeGitCommandExitCode("diff-index", "--cached", "--quiet", "--ignore-submodules", "HEAD", "--");
            if (diffIndexCommandResult.getExitCode() != 0) {
                error = diffIndexCommandResult.getError();
                uncommited = true;
            }
        } else {
            error = diffCommandResult.getError();
            uncommited = true;
        }
        if (StringUtils.isNotBlank((String)error)) {
            throw new MojoFailureException(error);
        }
        return uncommited;
    }

    protected void initGitFlowConfig() throws MojoFailureException, CommandLineException {
        this.gitSetConfig("gitflow.branch.master", this.gitFlowConfig.getProductionBranch());
        this.gitSetConfig("gitflow.branch.develop", this.gitFlowConfig.getDevelopmentBranch());
        this.gitSetConfig("gitflow.prefix.feature", this.gitFlowConfig.getFeatureBranchPrefix());
        this.gitSetConfig("gitflow.prefix.release", this.gitFlowConfig.getReleaseBranchPrefix());
        this.gitSetConfig("gitflow.prefix.hotfix", this.gitFlowConfig.getHotfixBranchPrefix());
        this.gitSetConfig("gitflow.prefix.support", this.gitFlowConfig.getSupportBranchPrefix());
        this.gitSetConfig("gitflow.prefix.versiontag", this.gitFlowConfig.getVersionTagPrefix());
        this.gitSetConfig("gitflow.origin", this.gitFlowConfig.getOrigin());
    }

    private void gitSetConfig(String name, String value) throws MojoFailureException, CommandLineException {
        if (value == null || value.isEmpty()) {
            value = "\"\"";
        }
        this.executeGitCommandExitCode("config", name, value);
    }

    protected String gitFindBranches(String branchName, boolean firstMatch) throws MojoFailureException, CommandLineException {
        String wildcard = "*";
        if (branchName.endsWith("/")) {
            wildcard = "**";
        }
        String branches = firstMatch ? this.executeGitCommandReturn("for-each-ref", "--count=1", "--format=\"%(refname:short)\"", "refs/heads/" + branchName + wildcard) : this.executeGitCommandReturn("for-each-ref", "--format=\"%(refname:short)\"", "refs/heads/" + branchName + wildcard);
        branches = this.removeQuotes(branches);
        return branches;
    }

    protected String gitFindTags() throws MojoFailureException, CommandLineException {
        String tags = this.executeGitCommandReturn("for-each-ref", "--sort=*authordate", "--format=\"%(refname:short)\"", "refs/tags/");
        tags = this.removeQuotes(tags);
        return tags;
    }

    protected String gitFindLastTag() throws MojoFailureException, CommandLineException {
        String tag = this.executeGitCommandReturn("for-each-ref", "--sort=-*authordate", "--count=1", "--format=\"%(refname:short)\"", "refs/tags/");
        tag = this.removeQuotes(tag);
        tag = tag.replaceAll("\\r?\\n", "");
        return tag;
    }

    private String removeQuotes(String str) {
        if (str != null && !str.isEmpty()) {
            str = str.replaceAll("\"", "");
        }
        return str;
    }

    protected boolean gitCheckBranchExists(String branchName) throws MojoFailureException, CommandLineException {
        CommandResult commandResult = this.executeGitCommandExitCode("show-ref", "--verify", "--quiet", "refs/heads/" + branchName);
        return commandResult.getExitCode() == 0;
    }

    protected boolean gitCheckTagExists(String tagName) throws MojoFailureException, CommandLineException {
        CommandResult commandResult = this.executeGitCommandExitCode("show-ref", "--verify", "--quiet", "refs/tags/" + tagName);
        return commandResult.getExitCode() == 0;
    }

    protected void gitCheckout(String branchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Checking out '" + branchName + "' branch."));
        this.executeGitCommand("checkout", branchName);
    }

    protected void gitCreateAndCheckout(String newBranchName, String fromBranchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Creating a new branch '" + newBranchName + "' from '" + fromBranchName + "' and checking it out."));
        this.executeGitCommand("checkout", "-b", newBranchName, fromBranchName);
    }

    protected void gitCreateBranch(String newBranchName, String fromBranchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Creating a new branch '" + newBranchName + "' from '" + fromBranchName + "'."));
        this.executeGitCommand("branch", newBranchName, fromBranchName);
    }

    private String replaceProperties(String message, Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entr : map.entrySet()) {
                message = StringUtils.replace((String)message, (String)("@{" + entr.getKey() + "}"), (String)entr.getValue());
            }
        }
        return message;
    }

    protected void gitCommit(String message) throws MojoFailureException, CommandLineException {
        this.gitCommit(message, null);
    }

    protected void gitCommit(String message, Map<String, String> messageProperties) throws MojoFailureException, CommandLineException {
        message = this.replaceProperties(message, messageProperties);
        if (this.gpgSignCommit) {
            this.getLog().info((CharSequence)"Committing changes. GPG-signed.");
            this.executeGitCommand("commit", "-a", "-S", "-m", message);
        } else {
            this.getLog().info((CharSequence)"Committing changes.");
            this.executeGitCommand("commit", "-a", "-m", message);
        }
    }

    protected void gitMerge(String branchName, boolean rebase, boolean noff, boolean ffonly, String message, Map<String, String> messageProperties) throws MojoFailureException, CommandLineException {
        String sign = "";
        if (this.gpgSignCommit) {
            sign = "-S";
        }
        String msgParam = "";
        String msg = "";
        if (StringUtils.isNotBlank((String)message)) {
            msgParam = "-m";
            msg = this.replaceProperties(message, messageProperties);
        }
        if (rebase) {
            this.getLog().info((CharSequence)("Rebasing '" + branchName + "' branch."));
            this.executeGitCommand("rebase", sign, branchName);
        } else if (ffonly) {
            this.getLog().info((CharSequence)("Merging (--ff-only) '" + branchName + "' branch."));
            this.executeGitCommand("merge", "--ff-only", sign, branchName);
        } else if (noff) {
            this.getLog().info((CharSequence)("Merging (--no-ff) '" + branchName + "' branch."));
            this.executeGitCommand("merge", "--no-ff", sign, branchName, msgParam, msg);
        } else {
            this.getLog().info((CharSequence)("Merging '" + branchName + "' branch."));
            this.executeGitCommand("merge", sign, branchName, msgParam, msg);
        }
    }

    protected void gitMergeNoff(String branchName) throws MojoFailureException, CommandLineException {
        this.gitMerge(branchName, false, true, false, null, null);
    }

    protected void gitMergeSquash(String branchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Squashing '" + branchName + "' branch."));
        this.executeGitCommand("merge", "--squash", branchName);
    }

    protected void gitTag(String tagName, String message, boolean gpgSignTag, Map<String, String> messageProperties) throws MojoFailureException, CommandLineException {
        message = this.replaceProperties(message, messageProperties);
        if (gpgSignTag) {
            this.getLog().info((CharSequence)("Creating GPG-signed '" + tagName + "' tag."));
            this.executeGitCommand("tag", "-a", "-s", tagName, "-m", message);
        } else {
            this.getLog().info((CharSequence)("Creating '" + tagName + "' tag."));
            this.executeGitCommand("tag", "-a", tagName, "-m", message);
        }
    }

    protected void gitBranchDelete(String branchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Deleting '" + branchName + "' branch."));
        this.executeGitCommand("branch", "-d", branchName);
    }

    protected void gitBranchDeleteForce(String branchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Deleting (-D) '" + branchName + "' branch."));
        this.executeGitCommand("branch", "-D", branchName);
    }

    protected void gitFetchRemoteAndCreate(String branchName) throws MojoFailureException, CommandLineException {
        if (!this.gitCheckBranchExists(branchName)) {
            this.getLog().info((CharSequence)("Local branch '" + branchName + "' doesn't exist. Trying to fetch and check it out from '" + this.gitFlowConfig.getOrigin() + "'."));
            this.gitFetchRemote(branchName);
            this.gitCreateAndCheckout(branchName, this.gitFlowConfig.getOrigin() + "/" + branchName);
        }
    }

    protected void gitFetchRemoteAndCompare(String branchName) throws MojoFailureException, CommandLineException {
        if (this.gitFetchRemote(branchName)) {
            this.getLog().info((CharSequence)("Comparing local branch '" + branchName + "' with remote '" + this.gitFlowConfig.getOrigin() + "/" + branchName + "'."));
            String revlistout = this.executeGitCommandReturn("rev-list", "--left-right", "--count", branchName + "..." + this.gitFlowConfig.getOrigin() + "/" + branchName);
            String[] counts = org.apache.commons.lang3.StringUtils.split((String)revlistout, (char)'\t');
            if (counts != null && counts.length > 1 && !"0".equals(org.apache.commons.lang3.StringUtils.deleteWhitespace((String)counts[1]))) {
                throw new MojoFailureException("Remote branch '" + this.gitFlowConfig.getOrigin() + "/" + branchName + "' is ahead of the local branch '" + branchName + "'. Execute git pull.");
            }
        }
    }

    private boolean gitFetchRemote(String branchName) throws MojoFailureException, CommandLineException {
        boolean success;
        this.getLog().info((CharSequence)("Fetching remote branch '" + this.gitFlowConfig.getOrigin() + " " + branchName + "'."));
        CommandResult result = this.executeGitCommandExitCode("fetch", "--quiet", this.gitFlowConfig.getOrigin(), branchName);
        boolean bl = success = result.getExitCode() == 0;
        if (!success) {
            this.getLog().warn((CharSequence)("There were some problems fetching remote branch '" + this.gitFlowConfig.getOrigin() + " " + branchName + "'. You can turn off remote branch fetching by setting the 'fetchRemote' parameter to false."));
        }
        return success;
    }

    protected void gitPush(String branchName, boolean pushTags) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Pushing '" + branchName + "' branch to '" + this.gitFlowConfig.getOrigin() + "'."));
        if (pushTags) {
            this.executeGitCommand("push", "--quiet", "-u", "--follow-tags", this.gitFlowConfig.getOrigin(), branchName);
        } else {
            this.executeGitCommand("push", "--quiet", "-u", this.gitFlowConfig.getOrigin(), branchName);
        }
    }

    protected void gitPushDelete(String branchName) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Deleting remote branch '" + branchName + "' from '" + this.gitFlowConfig.getOrigin() + "'."));
        CommandResult result = this.executeGitCommandExitCode("push", "--delete", this.gitFlowConfig.getOrigin(), branchName);
        if (result.getExitCode() != 0) {
            this.getLog().warn((CharSequence)("There were some problems deleting remote branch '" + branchName + "' from '" + this.gitFlowConfig.getOrigin() + "'."));
        }
    }

    protected void mvnSetVersions(String version) throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)("Updating version(s) to '" + version + "'."));
        String g = "";
        String a = "";
        if (this.versionsForceUpdate) {
            g = "-DgroupId=";
            a = "-DartifactId=";
        }
        if (this.tychoBuild) {
            this.executeMvnCommand(TYCHO_VERSIONS_PLUGIN_SET_GOAL, "-DnewVersion=" + version, "-Dtycho.mode=maven");
        } else {
            this.executeMvnCommand(VERSIONS_MAVEN_PLUGIN_SET_GOAL, g, a, "-DnewVersion=" + version, "-DgenerateBackupPoms=false");
        }
    }

    protected void mvnCleanTest() throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)"Cleaning and testing the project.");
        if (this.tychoBuild) {
            this.executeMvnCommand("clean", "verify");
        } else {
            this.executeMvnCommand("clean", "test");
        }
    }

    protected void mvnCleanInstall() throws MojoFailureException, CommandLineException {
        this.getLog().info((CharSequence)"Cleaning and installing the project.");
        this.executeMvnCommand("clean", "install");
    }

    protected void mvnRun(String goals) throws Exception {
        this.getLog().info((CharSequence)("Running Maven goals: " + goals));
        this.executeMvnCommand(CommandLineUtils.translateCommandline((String)goals));
    }

    private String executeGitCommandReturn(String ... args) throws CommandLineException, MojoFailureException {
        return this.executeCommand(this.cmdGit, true, null, args).getOut();
    }

    private CommandResult executeGitCommandExitCode(String ... args) throws CommandLineException, MojoFailureException {
        return this.executeCommand(this.cmdGit, false, null, args);
    }

    private void executeGitCommand(String ... args) throws CommandLineException, MojoFailureException {
        this.executeCommand(this.cmdGit, true, null, args);
    }

    private void executeMvnCommand(String ... args) throws CommandLineException, MojoFailureException {
        this.executeCommand(this.cmdMvn, true, this.argLine, args);
    }

    private CommandResult executeCommand(Commandline cmd, boolean failOnError, String argStr, String ... args) throws CommandLineException, MojoFailureException {
        this.initExecutables();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(cmd.getExecutable() + " " + StringUtils.join((Object[])args, (String)" ") + (argStr == null ? "" : " " + argStr)));
        }
        cmd.clearArgs();
        cmd.addArguments(args);
        if (StringUtils.isNotBlank((String)argStr)) {
            cmd.createArg().setLine(argStr);
        }
        StringBufferStreamConsumer out = new StringBufferStreamConsumer(this.verbose);
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        String errorStr = err.getOutput();
        String outStr = out.getOutput();
        if (failOnError && exitCode != 0) {
            if (StringUtils.isBlank((String)errorStr) && StringUtils.isNotBlank((String)outStr)) {
                errorStr = outStr;
            }
            throw new MojoFailureException(errorStr);
        }
        return new CommandResult(exitCode, outStr, errorStr);
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    private static class CommandResult {
        private final int exitCode;
        private final String out;
        private final String error;

        private CommandResult(int exitCode, String out, String error) {
            this.exitCode = exitCode;
            this.out = out;
            this.error = error;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOut() {
            return this.out;
        }

        public String getError() {
            return this.error;
        }
    }
}

