/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.attributes.persistence.impl;

import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.attributes.persistence.impl.PartitionKeyGenerators;
import com.amazon.ask.exception.PersistenceException;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.util.ValidationUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.ItemUtils;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class DynamoDbPersistenceAdapter
implements PersistenceAdapter {
    private final AmazonDynamoDB dynamoDb;
    private final String tableName;
    private final String partitionKeyName;
    private final String attributesKeyName;
    private final Function<RequestEnvelope, String> partitionKeyGenerator;
    private boolean autoCreateTable;
    private static final String DEFAULT_PARTITION_KEY_NAME = "id";
    private static final String DEFAULT_ATTRIBUTES_KEY_NAME = "attributes";
    private static final boolean DEFAULT_AUTO_CREATE_TABLE = false;
    private static final Function<RequestEnvelope, String> DEFAULT_PARTITION_KEY_GENERATOR = PartitionKeyGenerators.userId();
    private static final Long DEFAULT_READ_CAPACITY_UNITS = 5L;

    private DynamoDbPersistenceAdapter(Builder builder) {
        this.tableName = ValidationUtils.assertStringNotEmpty((String)builder.tableName, (String)"table name");
        this.dynamoDb = builder.dynamoDb != null ? builder.dynamoDb : (AmazonDynamoDB)AmazonDynamoDBClientBuilder.standard().build();
        this.partitionKeyName = builder.partitionKeyName;
        this.attributesKeyName = builder.attributesKeyName;
        this.partitionKeyGenerator = builder.partitionKeyGenerator;
        this.autoCreateTable = builder.autoCreateTable;
        this.autoCreateTableIfNotExists();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Map<String, Object>> getAttributes(RequestEnvelope envelope) throws PersistenceException {
        String partitionKey = this.partitionKeyGenerator.apply(envelope);
        GetItemRequest request = new GetItemRequest().withTableName(this.tableName).withKey(Collections.singletonMap(this.partitionKeyName, new AttributeValue().withS(partitionKey))).withConsistentRead(Boolean.valueOf(true));
        Map result = null;
        try {
            result = this.dynamoDb.getItem(request).getItem();
        }
        catch (ResourceNotFoundException e) {
            throw new PersistenceException(String.format("Table %s does not exist or is in the process of being created", this.tableName), (Throwable)e);
        }
        catch (AmazonDynamoDBException e) {
            throw new PersistenceException("Failed to retrieve attributes from DynamoDB", (Throwable)e);
        }
        if (result != null && result.containsKey(this.attributesKeyName)) {
            Map attributes = ItemUtils.toSimpleMapValue((Map)((AttributeValue)result.get(this.attributesKeyName)).getM());
            return Optional.of(attributes);
        }
        return Optional.empty();
    }

    public void saveAttributes(RequestEnvelope envelope, Map<String, Object> attributes) throws PersistenceException {
        String partitionKey = this.partitionKeyGenerator.apply(envelope);
        PutItemRequest request = new PutItemRequest().withTableName(this.tableName).withItem(this.getItem(partitionKey, attributes));
        try {
            this.dynamoDb.putItem(request);
        }
        catch (ResourceNotFoundException e) {
            throw new PersistenceException(String.format("Table %s does not exist or is in the process of being created", this.tableName), (Throwable)e);
        }
        catch (AmazonDynamoDBException e) {
            throw new PersistenceException("Failed to save attributes to DynamoDB", (Throwable)e);
        }
    }

    public void deleteAttributes(RequestEnvelope envelope) throws PersistenceException {
        String partitionKey = this.partitionKeyGenerator.apply(envelope);
        DeleteItemRequest deleteItemRequest = new DeleteItemRequest().withTableName(this.tableName).withKey(this.getItem(partitionKey, this.getAttributes(envelope).get()));
        try {
            this.dynamoDb.deleteItem(deleteItemRequest);
        }
        catch (ResourceNotFoundException e) {
            throw new PersistenceException(String.format("Table %s does not exist", this.tableName), (Throwable)e);
        }
        catch (AmazonDynamoDBException e) {
            throw new PersistenceException("Failed to delete attributes from DynamoDB", (Throwable)e);
        }
    }

    private Map<String, AttributeValue> getItem(String id, Map<String, Object> attributes) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(this.partitionKeyName, new AttributeValue().withS(id));
        item.put(this.attributesKeyName, new AttributeValue().withM(ItemUtils.fromSimpleMap(attributes)));
        return item;
    }

    private void autoCreateTableIfNotExists() {
        if (this.autoCreateTable) {
            AttributeDefinition partitionKeyDefinition = new AttributeDefinition().withAttributeName(this.partitionKeyName).withAttributeType(ScalarAttributeType.S);
            KeySchemaElement partitionKeySchema = new KeySchemaElement().withAttributeName(this.partitionKeyName).withKeyType(KeyType.HASH);
            ProvisionedThroughput throughput = new ProvisionedThroughput().withReadCapacityUnits(DEFAULT_READ_CAPACITY_UNITS).withWriteCapacityUnits(DEFAULT_READ_CAPACITY_UNITS);
            try {
                TableUtils.createTableIfNotExists((AmazonDynamoDB)this.dynamoDb, (CreateTableRequest)new CreateTableRequest().withTableName(this.tableName).withAttributeDefinitions(new AttributeDefinition[]{partitionKeyDefinition}).withKeySchema(new KeySchemaElement[]{partitionKeySchema}).withProvisionedThroughput(throughput));
            }
            catch (AmazonDynamoDBException e) {
                throw new PersistenceException("Create table request failed", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Function access$700() {
        return DEFAULT_PARTITION_KEY_GENERATOR;
    }

    public static final class Builder {
        private AmazonDynamoDB dynamoDb;
        private String tableName;
        private String partitionKeyName = "id";
        private String attributesKeyName = "attributes";
        private Function<RequestEnvelope, String> partitionKeyGenerator = DynamoDbPersistenceAdapter.access$700();
        private boolean autoCreateTable = false;

        private Builder() {
        }

        public Builder withDynamoDbClient(AmazonDynamoDB dynamoDb) {
            this.dynamoDb = dynamoDb;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withPartitionKeyName(String partitionKeyName) {
            this.partitionKeyName = partitionKeyName;
            return this;
        }

        public Builder withAttributesKeyName(String attributesKeyName) {
            this.attributesKeyName = attributesKeyName;
            return this;
        }

        public Builder withPartitionKeyGenerator(Function<RequestEnvelope, String> partitionKeyGenerator) {
            this.partitionKeyGenerator = partitionKeyGenerator;
            return this;
        }

        public Builder withAutoCreateTable(boolean autoCreateTable) {
            this.autoCreateTable = autoCreateTable;
            return this;
        }

        public DynamoDbPersistenceAdapter build() {
            return new DynamoDbPersistenceAdapter(this);
        }
    }
}

