/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Cause;
import com.amazon.ask.model.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ConnectionCompleted
extends Cause {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="status")
    private Status status = null;
    @JsonProperty(value="result")
    private Object result = null;

    private ConnectionCompleted() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ConnectionCompleted(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "ConnectionCompleted";
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.result != null) {
            this.result = builder.result;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="result")
    public Object getResult() {
        return this.result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionCompleted connectionCompleted = (ConnectionCompleted)o;
        return Objects.equals(this.token, connectionCompleted.token) && Objects.equals(this.status, connectionCompleted.status) && Objects.equals(this.result, connectionCompleted.result) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.token, this.status, this.result, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionCompleted {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String token;
        private Status status;
        private Object result;

        private Builder() {
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="result")
        public Builder withResult(Object result) {
            this.result = result;
            return this;
        }

        public ConnectionCompleted build() {
            return new ConnectionCompleted(this);
        }
    }
}

