/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.er.dynamic;

import com.amazon.ask.model.er.dynamic.EntityValueAndSynonyms;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Entity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private EntityValueAndSynonyms name = null;

    private Entity() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Entity(Builder builder) {
        if (builder.id != null) {
            this.id = builder.id;
        }
        if (builder.name != null) {
            this.name = builder.name;
        }
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public EntityValueAndSynonyms getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity erDynamicEntity = (Entity)o;
        return Objects.equals(this.id, erDynamicEntity.id) && Objects.equals(this.name, erDynamicEntity.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Entity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String id;
        private EntityValueAndSynonyms name;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(EntityValueAndSynonyms name) {
            this.name = name;
            return this;
        }

        public Entity build() {
            return new Entity(this);
        }
    }
}

