/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AutoPageCommand
extends Command {
    @JsonProperty(value="componentId")
    private String componentId = null;
    @JsonProperty(value="count")
    private String count = null;
    @JsonProperty(value="duration")
    private String duration = null;

    private AutoPageCommand() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AutoPageCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "AutoPage";
        if (builder.delay != null) {
            this.delay = builder.delay;
        }
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.screenLock != null) {
            this.screenLock = builder.screenLock;
        }
        if (builder.sequencer != null) {
            this.sequencer = builder.sequencer;
        }
        if (builder.when != null) {
            this.when = builder.when;
        }
        if (builder.componentId != null) {
            this.componentId = builder.componentId;
        }
        if (builder.count != null) {
            this.count = builder.count;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
    }

    @JsonProperty(value="componentId")
    public String getComponentId() {
        return this.componentId;
    }

    @JsonProperty(value="count")
    public String getCount() {
        return this.count;
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoPageCommand interfacesAlexaPresentationAplAutoPageCommand = (AutoPageCommand)o;
        return Objects.equals(this.componentId, interfacesAlexaPresentationAplAutoPageCommand.componentId) && Objects.equals(this.count, interfacesAlexaPresentationAplAutoPageCommand.count) && Objects.equals(this.duration, interfacesAlexaPresentationAplAutoPageCommand.duration) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.componentId, this.count, this.duration, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoPageCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    componentId: ").append(this.toIndentedString(this.componentId)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String delay;
        private String description;
        private Boolean screenLock;
        private String sequencer;
        private Boolean when;
        private String componentId;
        private String count;
        private String duration;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = String.valueOf(delay);
            return this;
        }

        @JsonProperty(value="delay")
        public Builder withDelay(String delayExpression) {
            this.delay = delayExpression;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="screenLock")
        public Builder withScreenLock(Boolean screenLock) {
            this.screenLock = screenLock;
            return this;
        }

        @JsonProperty(value="sequencer")
        public Builder withSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="componentId")
        public Builder withComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        @JsonProperty(value="count")
        public Builder withCount(Integer count) {
            this.count = String.valueOf(count);
            return this;
        }

        @JsonProperty(value="count")
        public Builder withCount(String countExpression) {
            this.count = countExpression;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(Integer duration) {
            this.duration = String.valueOf(duration);
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(String durationExpression) {
            this.duration = durationExpression;
            return this;
        }

        public AutoPageCommand build() {
            return new AutoPageCommand(this);
        }
    }
}

