/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.MediaCommandType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ControlMediaCommand
extends Command {
    @JsonProperty(value="command")
    private MediaCommandType command = null;
    @JsonProperty(value="componentId")
    private String componentId = null;
    @JsonProperty(value="value")
    private String value = null;

    private ControlMediaCommand() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ControlMediaCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "ControlMedia";
        if (builder.delay != null) {
            this.delay = builder.delay;
        }
        if (builder.description != null) {
            this.description = builder.description;
        }
        if (builder.screenLock != null) {
            this.screenLock = builder.screenLock;
        }
        if (builder.sequencer != null) {
            this.sequencer = builder.sequencer;
        }
        if (builder.when != null) {
            this.when = builder.when;
        }
        if (builder.command != null) {
            this.command = builder.command;
        }
        if (builder.componentId != null) {
            this.componentId = builder.componentId;
        }
        if (builder.value != null) {
            this.value = builder.value;
        }
    }

    @JsonProperty(value="command")
    public MediaCommandType getCommand() {
        return this.command;
    }

    @JsonProperty(value="componentId")
    public String getComponentId() {
        return this.componentId;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlMediaCommand interfacesAlexaPresentationAplControlMediaCommand = (ControlMediaCommand)o;
        return Objects.equals((Object)this.command, (Object)interfacesAlexaPresentationAplControlMediaCommand.command) && Objects.equals(this.componentId, interfacesAlexaPresentationAplControlMediaCommand.componentId) && Objects.equals(this.value, interfacesAlexaPresentationAplControlMediaCommand.value) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.command, this.componentId, this.value, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ControlMediaCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    command: ").append(this.toIndentedString((Object)this.command)).append("\n");
        sb.append("    componentId: ").append(this.toIndentedString(this.componentId)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String delay;
        private String description;
        private Boolean screenLock;
        private String sequencer;
        private Boolean when;
        private MediaCommandType command;
        private String componentId;
        private String value;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = String.valueOf(delay);
            return this;
        }

        @JsonProperty(value="delay")
        public Builder withDelay(String delayExpression) {
            this.delay = delayExpression;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="screenLock")
        public Builder withScreenLock(Boolean screenLock) {
            this.screenLock = screenLock;
            return this;
        }

        @JsonProperty(value="sequencer")
        public Builder withSequencer(String sequencer) {
            this.sequencer = sequencer;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="command")
        public Builder withCommand(MediaCommandType command) {
            this.command = command;
            return this;
        }

        @JsonProperty(value="componentId")
        public Builder withComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        @JsonProperty(value="value")
        public Builder withValue(Integer value) {
            this.value = String.valueOf(value);
            return this;
        }

        @JsonProperty(value="value")
        public Builder withValue(String valueExpression) {
            this.value = valueExpression;
            return this;
        }

        public ControlMediaCommand build() {
            return new ControlMediaCommand(this);
        }
    }
}

