/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.html;

import com.amazon.ask.model.interfaces.alexa.presentation.html.StartRequestMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class StartRequest {
    @JsonProperty(value="method")
    private String method = null;
    @JsonProperty(value="uri")
    private String uri = null;
    @JsonProperty(value="headers")
    private Object headers = null;

    private StartRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private StartRequest(Builder builder) {
        if (builder.method != null) {
            this.method = builder.method;
        }
        if (builder.uri != null) {
            this.uri = builder.uri;
        }
        if (builder.headers != null) {
            this.headers = builder.headers;
        }
    }

    public StartRequestMethod getMethod() {
        return StartRequestMethod.fromValue(this.method);
    }

    @JsonProperty(value="method")
    public String getMethodAsString() {
        return this.method;
    }

    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="headers")
    public Object getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartRequest interfacesAlexaPresentationHtmlStartRequest = (StartRequest)o;
        return Objects.equals(this.method, interfacesAlexaPresentationHtmlStartRequest.method) && Objects.equals(this.uri, interfacesAlexaPresentationHtmlStartRequest.uri) && Objects.equals(this.headers, interfacesAlexaPresentationHtmlStartRequest.headers);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.uri, this.headers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StartRequest {\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String method;
        private String uri;
        private Object headers;

        private Builder() {
        }

        @JsonProperty(value="method")
        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withMethod(StartRequestMethod method) {
            this.method = method != null ? method.toString() : null;
            return this;
        }

        @JsonProperty(value="uri")
        public Builder withUri(String uri) {
            this.uri = uri;
            return this;
        }

        @JsonProperty(value="headers")
        public Builder withHeaders(Object headers) {
            this.headers = headers;
            return this;
        }

        public StartRequest build() {
            return new StartRequest(this);
        }
    }
}

