/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.amazonpay.model.v1;

import com.amazon.ask.model.interfaces.amazonpay.model.v1.State;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AuthorizationStatus {
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="reasonCode")
    private String reasonCode = null;
    @JsonProperty(value="reasonDescription")
    private String reasonDescription = null;
    @JsonProperty(value="lastUpdateTimestamp")
    private OffsetDateTime lastUpdateTimestamp = null;

    private AuthorizationStatus() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AuthorizationStatus(Builder builder) {
        if (builder.state != null) {
            this.state = builder.state;
        }
        if (builder.reasonCode != null) {
            this.reasonCode = builder.reasonCode;
        }
        if (builder.reasonDescription != null) {
            this.reasonDescription = builder.reasonDescription;
        }
        if (builder.lastUpdateTimestamp != null) {
            this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        }
    }

    public State getState() {
        return State.fromValue(this.state);
    }

    @JsonProperty(value="state")
    public String getStateAsString() {
        return this.state;
    }

    @JsonProperty(value="reasonCode")
    public String getReasonCode() {
        return this.reasonCode;
    }

    @JsonProperty(value="reasonDescription")
    public String getReasonDescription() {
        return this.reasonDescription;
    }

    @JsonProperty(value="lastUpdateTimestamp")
    public OffsetDateTime getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationStatus interfacesAmazonpayModelV1AuthorizationStatus = (AuthorizationStatus)o;
        return Objects.equals(this.state, interfacesAmazonpayModelV1AuthorizationStatus.state) && Objects.equals(this.reasonCode, interfacesAmazonpayModelV1AuthorizationStatus.reasonCode) && Objects.equals(this.reasonDescription, interfacesAmazonpayModelV1AuthorizationStatus.reasonDescription) && Objects.equals(this.lastUpdateTimestamp, interfacesAmazonpayModelV1AuthorizationStatus.lastUpdateTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.reasonCode, this.reasonDescription, this.lastUpdateTimestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationStatus {\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    reasonDescription: ").append(this.toIndentedString(this.reasonDescription)).append("\n");
        sb.append("    lastUpdateTimestamp: ").append(this.toIndentedString(this.lastUpdateTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String state;
        private String reasonCode;
        private String reasonDescription;
        private OffsetDateTime lastUpdateTimestamp;

        private Builder() {
        }

        @JsonProperty(value="state")
        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withState(State state) {
            this.state = state != null ? state.toString() : null;
            return this;
        }

        @JsonProperty(value="reasonCode")
        public Builder withReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @JsonProperty(value="reasonDescription")
        public Builder withReasonDescription(String reasonDescription) {
            this.reasonDescription = reasonDescription;
            return this;
        }

        @JsonProperty(value="lastUpdateTimestamp")
        public Builder withLastUpdateTimestamp(OffsetDateTime lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public AuthorizationStatus build() {
            return new AuthorizationStatus(this);
        }
    }
}

