/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.customInterfaceController;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.interfaces.customInterfaceController.Event;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class EventsReceivedRequest
extends Request {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="events")
    private List<Event> events = new ArrayList<Event>();

    private EventsReceivedRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private EventsReceivedRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "CustomInterfaceController.EventsReceived";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.events != null) {
            this.events = builder.events;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="events")
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsReceivedRequest interfacesCustomInterfaceControllerEventsReceivedRequest = (EventsReceivedRequest)o;
        return Objects.equals(this.token, interfacesCustomInterfaceControllerEventsReceivedRequest.token) && Objects.equals(this.events, interfacesCustomInterfaceControllerEventsReceivedRequest.events) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.token, this.events, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsReceivedRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String token;
        private List<Event> events;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="events")
        public Builder withEvents(List<Event> events) {
            this.events = events;
            return this;
        }

        public Builder addEventsItem(Event eventsItem) {
            if (this.events == null) {
                this.events = new ArrayList<Event>();
            }
            this.events.add(eventsItem);
            return this;
        }

        public EventsReceivedRequest build() {
            return new EventsReceivedRequest(this);
        }
    }
}

