/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.geolocation;

import com.amazon.ask.model.interfaces.geolocation.Altitude;
import com.amazon.ask.model.interfaces.geolocation.Coordinate;
import com.amazon.ask.model.interfaces.geolocation.Heading;
import com.amazon.ask.model.interfaces.geolocation.Speed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class GeolocationCommonState {
    @JsonProperty(value="timestamp")
    private String timestamp = null;
    @JsonProperty(value="coordinate")
    private Coordinate coordinate = null;
    @JsonProperty(value="altitude")
    private Altitude altitude = null;
    @JsonProperty(value="heading")
    private Heading heading = null;
    @JsonProperty(value="speed")
    private Speed speed = null;

    private GeolocationCommonState() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private GeolocationCommonState(Builder builder) {
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.coordinate != null) {
            this.coordinate = builder.coordinate;
        }
        if (builder.altitude != null) {
            this.altitude = builder.altitude;
        }
        if (builder.heading != null) {
            this.heading = builder.heading;
        }
        if (builder.speed != null) {
            this.speed = builder.speed;
        }
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="coordinate")
    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    @JsonProperty(value="altitude")
    public Altitude getAltitude() {
        return this.altitude;
    }

    @JsonProperty(value="heading")
    public Heading getHeading() {
        return this.heading;
    }

    @JsonProperty(value="speed")
    public Speed getSpeed() {
        return this.speed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeolocationCommonState interfacesGeolocationGeolocationCommonState = (GeolocationCommonState)o;
        return Objects.equals(this.timestamp, interfacesGeolocationGeolocationCommonState.timestamp) && Objects.equals(this.coordinate, interfacesGeolocationGeolocationCommonState.coordinate) && Objects.equals(this.altitude, interfacesGeolocationGeolocationCommonState.altitude) && Objects.equals(this.heading, interfacesGeolocationGeolocationCommonState.heading) && Objects.equals(this.speed, interfacesGeolocationGeolocationCommonState.speed);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.coordinate, this.altitude, this.heading, this.speed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeolocationCommonState {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    coordinate: ").append(this.toIndentedString(this.coordinate)).append("\n");
        sb.append("    altitude: ").append(this.toIndentedString(this.altitude)).append("\n");
        sb.append("    heading: ").append(this.toIndentedString(this.heading)).append("\n");
        sb.append("    speed: ").append(this.toIndentedString(this.speed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String timestamp;
        private Coordinate coordinate;
        private Altitude altitude;
        private Heading heading;
        private Speed speed;

        private Builder() {
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="coordinate")
        public Builder withCoordinate(Coordinate coordinate) {
            this.coordinate = coordinate;
            return this;
        }

        @JsonProperty(value="altitude")
        public Builder withAltitude(Altitude altitude) {
            this.altitude = altitude;
            return this;
        }

        @JsonProperty(value="heading")
        public Builder withHeading(Heading heading) {
            this.heading = heading;
            return this;
        }

        @JsonProperty(value="speed")
        public Builder withSpeed(Speed speed) {
            this.speed = speed;
            return this;
        }

        public GeolocationCommonState build() {
            return new GeolocationCommonState(this);
        }
    }
}

