/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.viewport.apl;

import com.amazon.ask.model.interfaces.viewport.Dialog;
import com.amazon.ask.model.interfaces.viewport.Mode;
import com.amazon.ask.model.interfaces.viewport.ViewportVideo;
import com.amazon.ask.model.interfaces.viewport.size.ViewportSize;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CurrentConfiguration {
    @JsonProperty(value="mode")
    private String mode = null;
    @JsonProperty(value="video")
    private ViewportVideo video = null;
    @JsonProperty(value="size")
    private ViewportSize size = null;
    @JsonProperty(value="dialog")
    private String dialog = null;

    private CurrentConfiguration() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CurrentConfiguration(Builder builder) {
        if (builder.mode != null) {
            this.mode = builder.mode;
        }
        if (builder.video != null) {
            this.video = builder.video;
        }
        if (builder.size != null) {
            this.size = builder.size;
        }
        if (builder.dialog != null) {
            this.dialog = builder.dialog;
        }
    }

    public Mode getMode() {
        return Mode.fromValue(this.mode);
    }

    @JsonProperty(value="mode")
    public String getModeAsString() {
        return this.mode;
    }

    @JsonProperty(value="video")
    public ViewportVideo getVideo() {
        return this.video;
    }

    @JsonProperty(value="size")
    public ViewportSize getSize() {
        return this.size;
    }

    public Dialog getDialog() {
        return Dialog.fromValue(this.dialog);
    }

    @JsonProperty(value="dialog")
    public String getDialogAsString() {
        return this.dialog;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentConfiguration interfacesViewportAplCurrentConfiguration = (CurrentConfiguration)o;
        return Objects.equals(this.mode, interfacesViewportAplCurrentConfiguration.mode) && Objects.equals(this.video, interfacesViewportAplCurrentConfiguration.video) && Objects.equals(this.size, interfacesViewportAplCurrentConfiguration.size) && Objects.equals(this.dialog, interfacesViewportAplCurrentConfiguration.dialog);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.video, this.size, this.dialog);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurrentConfiguration {\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    dialog: ").append(this.toIndentedString(this.dialog)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String mode;
        private ViewportVideo video;
        private ViewportSize size;
        private String dialog;

        private Builder() {
        }

        @JsonProperty(value="mode")
        public Builder withMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder withMode(Mode mode) {
            this.mode = mode != null ? mode.toString() : null;
            return this;
        }

        @JsonProperty(value="video")
        public Builder withVideo(ViewportVideo video) {
            this.video = video;
            return this;
        }

        @JsonProperty(value="size")
        public Builder withSize(ViewportSize size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="dialog")
        public Builder withDialog(String dialog) {
            this.dialog = dialog;
            return this;
        }

        public Builder withDialog(Dialog dialog) {
            this.dialog = dialog != null ? dialog.toString() : null;
            return this;
        }

        public CurrentConfiguration build() {
            return new CurrentConfiguration(this);
        }
    }
}

