/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gadgetController;

import com.amazon.ask.model.services.gadgetController.AnimationStep;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class LightAnimation {
    @JsonProperty(value="repeat")
    private Integer repeat = null;
    @JsonProperty(value="targetLights")
    private List<String> targetLights = new ArrayList<String>();
    @JsonProperty(value="sequence")
    private List<AnimationStep> sequence = new ArrayList<AnimationStep>();

    private LightAnimation() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LightAnimation(Builder builder) {
        if (builder.repeat != null) {
            this.repeat = builder.repeat;
        }
        if (builder.targetLights != null) {
            this.targetLights = builder.targetLights;
        }
        if (builder.sequence != null) {
            this.sequence = builder.sequence;
        }
    }

    @JsonProperty(value="repeat")
    public Integer getRepeat() {
        return this.repeat;
    }

    @JsonProperty(value="targetLights")
    public List<String> getTargetLights() {
        return this.targetLights;
    }

    @JsonProperty(value="sequence")
    public List<AnimationStep> getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightAnimation servicesGadgetControllerLightAnimation = (LightAnimation)o;
        return Objects.equals(this.repeat, servicesGadgetControllerLightAnimation.repeat) && Objects.equals(this.targetLights, servicesGadgetControllerLightAnimation.targetLights) && Objects.equals(this.sequence, servicesGadgetControllerLightAnimation.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.repeat, this.targetLights, this.sequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LightAnimation {\n");
        sb.append("    repeat: ").append(this.toIndentedString(this.repeat)).append("\n");
        sb.append("    targetLights: ").append(this.toIndentedString(this.targetLights)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer repeat;
        private List<String> targetLights;
        private List<AnimationStep> sequence;

        private Builder() {
        }

        @JsonProperty(value="repeat")
        public Builder withRepeat(Integer repeat) {
            this.repeat = repeat;
            return this;
        }

        @JsonProperty(value="targetLights")
        public Builder withTargetLights(List<String> targetLights) {
            this.targetLights = targetLights;
            return this;
        }

        public Builder addTargetLightsItem(String targetLightsItem) {
            if (this.targetLights == null) {
                this.targetLights = new ArrayList<String>();
            }
            this.targetLights.add(targetLightsItem);
            return this;
        }

        @JsonProperty(value="sequence")
        public Builder withSequence(List<AnimationStep> sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder addSequenceItem(AnimationStep sequenceItem) {
            if (this.sequence == null) {
                this.sequence = new ArrayList<AnimationStep>();
            }
            this.sequence.add(sequenceItem);
            return this;
        }

        public LightAnimation build() {
            return new LightAnimation(this);
        }
    }
}

