/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.AlertInfo;
import com.amazon.ask.model.services.reminderManagement.PushNotification;
import com.amazon.ask.model.services.reminderManagement.Status;
import com.amazon.ask.model.services.reminderManagement.Trigger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class GetReminderResponse {
    @JsonProperty(value="alertToken")
    private String alertToken = null;
    @JsonProperty(value="createdTime")
    private OffsetDateTime createdTime = null;
    @JsonProperty(value="updatedTime")
    private OffsetDateTime updatedTime = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="trigger")
    private Trigger trigger = null;
    @JsonProperty(value="alertInfo")
    private AlertInfo alertInfo = null;
    @JsonProperty(value="pushNotification")
    private PushNotification pushNotification = null;
    @JsonProperty(value="version")
    private String version = null;

    private GetReminderResponse() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private GetReminderResponse(Builder builder) {
        if (builder.alertToken != null) {
            this.alertToken = builder.alertToken;
        }
        if (builder.createdTime != null) {
            this.createdTime = builder.createdTime;
        }
        if (builder.updatedTime != null) {
            this.updatedTime = builder.updatedTime;
        }
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.trigger != null) {
            this.trigger = builder.trigger;
        }
        if (builder.alertInfo != null) {
            this.alertInfo = builder.alertInfo;
        }
        if (builder.pushNotification != null) {
            this.pushNotification = builder.pushNotification;
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
    }

    @JsonProperty(value="alertToken")
    public String getAlertToken() {
        return this.alertToken;
    }

    @JsonProperty(value="createdTime")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty(value="updatedTime")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    public Status getStatus() {
        return Status.fromValue(this.status);
    }

    @JsonProperty(value="status")
    public String getStatusAsString() {
        return this.status;
    }

    @JsonProperty(value="trigger")
    public Trigger getTrigger() {
        return this.trigger;
    }

    @JsonProperty(value="alertInfo")
    public AlertInfo getAlertInfo() {
        return this.alertInfo;
    }

    @JsonProperty(value="pushNotification")
    public PushNotification getPushNotification() {
        return this.pushNotification;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetReminderResponse servicesReminderManagementGetReminderResponse = (GetReminderResponse)o;
        return Objects.equals(this.alertToken, servicesReminderManagementGetReminderResponse.alertToken) && Objects.equals(this.createdTime, servicesReminderManagementGetReminderResponse.createdTime) && Objects.equals(this.updatedTime, servicesReminderManagementGetReminderResponse.updatedTime) && Objects.equals(this.status, servicesReminderManagementGetReminderResponse.status) && Objects.equals(this.trigger, servicesReminderManagementGetReminderResponse.trigger) && Objects.equals(this.alertInfo, servicesReminderManagementGetReminderResponse.alertInfo) && Objects.equals(this.pushNotification, servicesReminderManagementGetReminderResponse.pushNotification) && Objects.equals(this.version, servicesReminderManagementGetReminderResponse.version);
    }

    public int hashCode() {
        return Objects.hash(this.alertToken, this.createdTime, this.updatedTime, this.status, this.trigger, this.alertInfo, this.pushNotification, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetReminderResponse {\n");
        sb.append("    alertToken: ").append(this.toIndentedString(this.alertToken)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString(this.trigger)).append("\n");
        sb.append("    alertInfo: ").append(this.toIndentedString(this.alertInfo)).append("\n");
        sb.append("    pushNotification: ").append(this.toIndentedString(this.pushNotification)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String alertToken;
        private OffsetDateTime createdTime;
        private OffsetDateTime updatedTime;
        private String status;
        private Trigger trigger;
        private AlertInfo alertInfo;
        private PushNotification pushNotification;
        private String version;

        private Builder() {
        }

        @JsonProperty(value="alertToken")
        public Builder withAlertToken(String alertToken) {
            this.alertToken = alertToken;
            return this;
        }

        @JsonProperty(value="createdTime")
        public Builder withCreatedTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonProperty(value="updatedTime")
        public Builder withUpdatedTime(OffsetDateTime updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status != null ? status.toString() : null;
            return this;
        }

        @JsonProperty(value="trigger")
        public Builder withTrigger(Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        @JsonProperty(value="alertInfo")
        public Builder withAlertInfo(AlertInfo alertInfo) {
            this.alertInfo = alertInfo;
            return this;
        }

        @JsonProperty(value="pushNotification")
        public Builder withPushNotification(PushNotification pushNotification) {
            this.pushNotification = pushNotification;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public GetReminderResponse build() {
            return new GetReminderResponse(this);
        }
    }
}

