/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.ui;

import com.amazon.ask.model.ui.OutputSpeech;
import com.amazon.ask.model.ui.PlayBehavior;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PlainTextOutputSpeech
extends OutputSpeech {
    @JsonProperty(value="text")
    private String text = null;

    private PlainTextOutputSpeech() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PlainTextOutputSpeech(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "PlainText";
        if (builder.playBehavior != null) {
            this.playBehavior = builder.playBehavior;
        }
        if (builder.text != null) {
            this.text = builder.text;
        }
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlainTextOutputSpeech uiPlainTextOutputSpeech = (PlainTextOutputSpeech)o;
        return Objects.equals(this.text, uiPlainTextOutputSpeech.text) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.text, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlainTextOutputSpeech {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String playBehavior;
        private String text;

        private Builder() {
        }

        @JsonProperty(value="playBehavior")
        public Builder withPlayBehavior(String playBehavior) {
            this.playBehavior = playBehavior;
            return this;
        }

        public Builder withPlayBehavior(PlayBehavior playBehavior) {
            this.playBehavior = playBehavior != null ? playBehavior.toString() : null;
            return this;
        }

        @JsonProperty(value="text")
        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public PlainTextOutputSpeech build() {
            return new PlainTextOutputSpeech(this);
        }
    }
}

