/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util.impl;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.request.UnmarshalledRequest;
import com.amazon.ask.request.impl.BaseUnmarshalledRequest;
import com.amazon.ask.util.JsonUnmarshaller;
import com.amazon.ask.util.impl.ObjectMapperFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;

public class JacksonJsonUnmarshaller<Type>
implements JsonUnmarshaller<Type> {
    private static final ObjectMapper MAPPER = ObjectMapperFactory.getMapper();
    private final Class<Type> outputType;
    private final String requiredField;

    protected JacksonJsonUnmarshaller(Class<Type> outputType, String requiredField) {
        this.outputType = outputType;
        this.requiredField = requiredField;
    }

    public static <Output> JacksonJsonUnmarshaller<Output> withTypeBinding(Class<Output> outputType, String requiredField) {
        return new JacksonJsonUnmarshaller<Output>(outputType, requiredField);
    }

    public static <Output> JacksonJsonUnmarshaller<Output> withTypeBinding(Class<Output> outputType) {
        return new JacksonJsonUnmarshaller<Output>(outputType, null);
    }

    @Override
    public Optional<UnmarshalledRequest<Type>> unmarshall(byte[] in) {
        try {
            JsonNode json = MAPPER.readTree(in);
            if (this.requiredField != null && !json.has(this.requiredField)) {
                return Optional.empty();
            }
            BaseUnmarshalledRequest<Object> unmarshalledRequest = new BaseUnmarshalledRequest<Object>(MAPPER.treeToValue((TreeNode)json, this.outputType), json);
            return Optional.of(unmarshalledRequest);
        }
        catch (IOException e) {
            throw new AskSdkException("Deserialization error", e);
        }
    }
}

