/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.mapper.impl;

import com.amazon.ask.request.handler.chain.GenericRequestHandlerChain;
import com.amazon.ask.request.handler.chain.impl.BaseRequestHandlerChain;
import com.amazon.ask.request.mapper.GenericRequestMapper;
import com.amazon.ask.util.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BaseRequestMapper<Input, Output>
implements GenericRequestMapper<Input, Output> {
    protected final List<BaseRequestHandlerChain<Input, Output>> handlerChains;

    protected BaseRequestMapper(List<BaseRequestHandlerChain<Input, Output>> handlerChains) {
        this.handlerChains = ValidationUtils.assertNotEmpty(handlerChains, "handlerChains");
    }

    @Override
    public Optional<GenericRequestHandlerChain<Input, Output>> getRequestHandlerChain(Input input) {
        for (BaseRequestHandlerChain<Input, Output> handlerChain : this.handlerChains) {
            if (!handlerChain.getRequestHandler().canHandle(input)) continue;
            return Optional.of(handlerChain);
        }
        return Optional.empty();
    }

    public static <Input, Output, Self extends Builder<Input, Output, Self>> Builder<Input, Output, Self> forTypes(Class<Input> input, Class<Output> output) {
        return new Builder();
    }

    public static <Input, Output> Builder<Input, Output, ?> builder() {
        return new Builder();
    }

    public static class Builder<Input, Output, Self extends Builder<Input, Output, Self>> {
        protected List<BaseRequestHandlerChain<Input, Output>> handlerChains;

        protected Builder() {
        }

        public Self withRequestHandlerChains(List<BaseRequestHandlerChain<Input, Output>> handlerChains) {
            this.handlerChains = handlerChains;
            return (Self)this;
        }

        public Self addRequestHandlerChain(BaseRequestHandlerChain<Input, Output> handlerChain) {
            if (this.handlerChains == null) {
                this.handlerChains = new ArrayList<BaseRequestHandlerChain<Input, Output>>();
            }
            this.handlerChains.add(handlerChain);
            return (Self)this;
        }

        public GenericRequestMapper<Input, Output> build() {
            return new BaseRequestMapper<Input, Output>(this.handlerChains);
        }
    }
}

