/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazon.aps.ads.ApsAdUtils;
import com.amazon.aps.ads.ApsConstants;
import com.amazon.aps.ads.ApsMigrationUtil;
import com.amazon.aps.ads.listeners.ApsInitializationListener;
import com.amazon.aps.ads.model.ApsInitConfig;
import com.amazon.aps.ads.model.ApsInitializationStatus;
import com.amazon.aps.ads.model.ApsLogLevel;
import com.amazon.aps.ads.model.ApsMraidPolicy;
import com.amazon.aps.ads.model.ApsMraidVersion;
import com.amazon.aps.ads.model.ApsPrivacyType;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.util.ApsAsyncUtil;
import com.amazon.device.ads.AdRegistration;
import java.util.HashMap;
import org.json.JSONObject;

public class Aps
implements ApsConstants {
    private static ApsInitializationListener apsInitializationListener;
    private static String appKey;
    private static Context context;
    private static final HashMap<String, String> privacyHashmap;

    public static void initialize(@NonNull Context context, @NonNull String appKey, @Nullable ApsInitializationListener apsInitializationListener) {
        ApsAdUtils.checkNullAndLogInvalidArg(context, appKey);
        ApsMigrationUtil.setIsApsInitCalled(true);
        ApsMigrationUtil.setApsInitInProgress(true);
        try {
            Aps.context = context;
            Aps.appKey = appKey;
            Aps.apsInitializationListener = apsInitializationListener;
            ApsAsyncUtil.getInstance().runAsyncAndCallback(() -> {
                AdRegistration adRegistration = AdRegistration.getInstance(appKey, context);
                ApsMigrationUtil.setApsInitInProgress(false);
                return adRegistration;
            }, (apsResult, resultObj) -> {
                if (apsInitializationListener != null) {
                    apsInitializationListener.onInitializationCompleted(new ApsInitializationStatus(apsResult));
                }
            });
        }
        catch (RuntimeException e) {
            ApsMigrationUtil.setApsInitInProgress(false);
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:initialize", e);
        }
    }

    public static void initialize(@NonNull Context context, @NonNull String appKey, @NonNull ApsInitConfig apsInitConfig, @Nullable ApsInitializationListener apsInitializationListener) {
        ApsAdUtils.checkNullAndLogInvalidArg(apsInitConfig);
        ApsMigrationUtil.setIsApsInitCalled(true);
        try {
            Aps.enableLogging(apsInitConfig.apsLogLevel != null && apsInitConfig.apsLogLevel != ApsLogLevel.Off, apsInitConfig.apsLogLevel != null ? apsInitConfig.apsLogLevel : ApsLogLevel.Error);
            Aps.setLocationEnabled(apsInitConfig.isLocationEnabled);
            Aps.initialize(context, appKey, apsInitializationStatus -> {
                Aps.setTestingMode(apsInitConfig.isTestingMode);
                apsInitializationListener.onInitializationCompleted(apsInitializationStatus);
            });
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:initialize", e);
        }
    }

    public static boolean isInitialized() {
        return AdRegistration.isInitialized();
    }

    public static void setMraidSupportedVersions(ApsMraidVersion ... mraidSupportedVersions) {
        ApsAdUtils.checkNullAndLogInvalidArg((Object[])mraidSupportedVersions);
        try {
            String[] args = new String[mraidSupportedVersions.length];
            for (int i = 0; i < mraidSupportedVersions.length; ++i) {
                args[i] = mraidSupportedVersions[i].getString();
            }
            AdRegistration.setMRAIDSupportedVersions(args);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setMraidSupportedVersions", e);
        }
    }

    public static void setMraidPolicy(ApsMraidPolicy mraidPolicy) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{mraidPolicy});
        try {
            AdRegistration.setMRAIDPolicy(ApsMigrationUtil.getMRAIDPolicy(mraidPolicy));
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setMraidPolicy", e);
        }
    }

    public static ApsMraidPolicy getMraidPolicy() {
        try {
            return ApsMigrationUtil.getApsMraidPolicy(AdRegistration.getMRAIDPolicy());
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:getMraidPolicy", e);
            return ApsMraidPolicy.NONE;
        }
    }

    public static void setLocationEnabled(boolean isLocationEnabled) {
        AdRegistration.useGeoLocation(isLocationEnabled);
    }

    public static boolean isLocationEnabled() {
        return AdRegistration.isLocationEnabled();
    }

    public static String getSdkVersion() {
        return AdRegistration.getVersion();
    }

    public static void enableLogging(boolean enable) {
        AdRegistration.enableLogging(enable);
    }

    public static void enableLogging(boolean enable, ApsLogLevel logLevel) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{logLevel});
        try {
            AdRegistration.enableLogging(enable, ApsMigrationUtil.getDTBLogLevel(logLevel));
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:enableLogging", e);
        }
    }

    public static void setTestingMode(boolean isTesting) {
        AdRegistration.enableTesting(isTesting);
    }

    public static boolean isTestingMode() {
        return AdRegistration.isTestMode();
    }

    public static void setCustomAttribute(String key, String value) {
        ApsAdUtils.checkNullAndLogInvalidArg(key, value);
        try {
            AdRegistration.addCustomAttribute(key, value);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setCustomAttribute", e);
        }
    }

    public static void removeCustomAttribute(String key) {
        ApsAdUtils.checkNullAndLogInvalidArg(key);
        try {
            AdRegistration.removeCustomAttribute(key);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:removeCustomAttribute", e);
        }
    }

    public static void setOmIdPartnerName(String partnerName) {
        ApsAdUtils.checkNullAndLogInvalidArg(partnerName);
        try {
            AdRegistration.addCustomAttribute("omidPartnerName", partnerName);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setOmIdPartnerName", e);
        }
    }

    public static void setOmIdPartnerVersion(String partnerVersion) {
        ApsAdUtils.checkNullAndLogInvalidArg(partnerVersion);
        try {
            AdRegistration.addCustomAttribute("omidPartnerVersion", partnerVersion);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setOmIdPartnerVersion", e);
        }
    }

    public static void setPrivacyString(ApsPrivacyType apsPrivacyType, String value) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsPrivacyType, value});
        try {
            privacyHashmap.put(apsPrivacyType.toString(), value);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setPrivacyString", e);
        }
    }

    public static void setPrivacyValue(ApsPrivacyType apsPrivacyType, Object dsaTransparencyParams) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsPrivacyType, dsaTransparencyParams});
        if (apsPrivacyType == ApsPrivacyType.DSA_PRIVACY && dsaTransparencyParams instanceof JSONObject) {
            AdRegistration.setDsaTransparency((JSONObject)dsaTransparencyParams);
        } else {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Unsupported value type for " + apsPrivacyType.toString());
        }
    }

    public static void removePrivacyString(ApsPrivacyType apsPrivacyType) {
        ApsAdUtils.checkNullAndLogInvalidArg(new Object[]{apsPrivacyType});
        try {
            privacyHashmap.remove(apsPrivacyType.toString());
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:setPrivacyString", e);
        }
    }

    static HashMap<String, String> getPrivacyHashmap() {
        return privacyHashmap;
    }

    static {
        privacyHashmap = new HashMap();
    }
}

