/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import android.os.Bundle;
import com.amazon.aps.ads.ApsAdFormatUtils;
import com.amazon.aps.ads.ApsAdRequest;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.ads.util.adview.ApsAdViewImpl;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.SDKUtilities;
import java.lang.ref.WeakReference;

public class ApsAd
extends DTBAdResponse {
    private static final String REWARDED_INVENTORY_TYPE = "MOBILE_APP_REWARDED";
    private static final String INTERSTITIAL_VIDEO_INVENTORY_TYPE = "MOBILE_INTERSTITIAL";
    private static final String INSTREAM_VIDEO_INVENTORY_TYPE = "MOBILE_VIDEO";
    private ApsAdRequest apsAdRequest;
    private WeakReference<ApsAdViewImpl> adViewWeakReference;
    private ApsAdFormat apsAdFormatFromRequest;
    private String slotUuid;
    int height = -1;
    int width = -1;

    public ApsAd(DTBAdResponse dtbAdResponse) {
        super(dtbAdResponse);
        this.setApsAdFormatAndSlotUuid(dtbAdResponse);
        this.setSlotUuid(dtbAdResponse);
    }

    public ApsAd(DTBAdResponse dtbAdResponse, ApsAdFormat apsAdFormat) {
        super(dtbAdResponse);
        this.setApsAdFormat(apsAdFormat);
        this.setSlotUuid(dtbAdResponse);
    }

    public ApsAd(Bundle extras, ApsAdFormat apsAdFormat) {
        super(extras);
        this.setApsAdFormat(apsAdFormat);
    }

    public ApsAd(String extrasAsString, ApsAdFormat apsAdFormat) {
        super(extrasAsString);
        this.setApsAdFormat(apsAdFormat);
    }

    private void setApsAdFormat(ApsAdFormat apsAdFormat) {
        if (apsAdFormat != null) {
            this.apsAdFormatFromRequest = apsAdFormat;
            this.height = ApsAdFormatUtils.getHeight(apsAdFormat);
            this.width = ApsAdFormatUtils.getWidth(apsAdFormat);
        }
    }

    public ApsAdRequest getApsAdRequest() {
        if (this.apsAdRequest == null) {
            if (this.refreshLoader instanceof ApsAdRequest) {
                this.apsAdRequest = (ApsAdRequest)this.refreshLoader;
            } else if (this.refreshLoader != null) {
                this.setApsAdRequest(new ApsAdRequest(this.refreshLoader));
            }
        }
        return this.apsAdRequest;
    }

    public String getBidInfo() {
        return SDKUtilities.getBidInfo(this);
    }

    public String getPricePoint() {
        String pricePoint = null;
        try {
            pricePoint = SDKUtilities.getPricePoint(this);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error getting the price point from ApsAd", e);
        }
        return pricePoint;
    }

    public String getSlotUuid() {
        return this.slotUuid;
    }

    public ApsAdFormat getApsAdFormat() {
        if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("ad_format_from_bid_response")) {
            try {
                if (this.isVideo()) {
                    if (REWARDED_INVENTORY_TYPE.equalsIgnoreCase(this.videoInventoryType)) {
                        return ApsAdFormat.REWARDED_VIDEO;
                    }
                    if (INSTREAM_VIDEO_INVENTORY_TYPE.equalsIgnoreCase(this.videoInventoryType)) {
                        return ApsAdFormat.INSTREAM_VIDEO;
                    }
                    return ApsAdFormat.INTERSTITIAL;
                }
                this.width = this.width != -1 ? this.width : this.getWidthFromAax();
                int n = this.height = this.height != -1 ? this.height : this.getHeightFromAax();
                if (this.height == 50 && this.width == 320) {
                    return ApsAdFormat.BANNER;
                }
                if (this.height == 250 && this.width == 300) {
                    return ApsAdFormat.MREC;
                }
                if (this.height == 90 && this.width == 728) {
                    return ApsAdFormat.LEADERBOARD;
                }
                if (this.height == 9999 && this.width == 9999) {
                    return ApsAdFormat.INTERSTITIAL;
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in parsing the ad format in ApsAd - getApsAdFormat", e);
            }
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "Invalid ad format received from the AAX in ApsAd - getApsAdFormat:" + this.width + ":" + this.height);
        }
        return this.apsAdFormatFromRequest;
    }

    void setSlotUuid(DTBAdResponse adResponse) {
        try {
            DTBAdSize dtbAdSize = adResponse.getDTBAds().get(0);
            this.slotUuid = dtbAdSize.getSlotUUID();
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in setting up slot id in ApsAd", e);
        }
    }

    void setApsAdFormatAndSlotUuid(DTBAdResponse adResponse) {
        DTBAdSize dtbAdSize;
        if (adResponse != null && adResponse.getDTBAds() != null && adResponse.getDTBAds().size() > 0 && (dtbAdSize = adResponse.getDTBAds().get(0)) != null) {
            String slotUuid = dtbAdSize.getSlotUUID();
            ApsAdFormat apsAdFormat = ApsAdFormatUtils.getAdFormat(dtbAdSize.getDTBAdType(), dtbAdSize.getHeight(), dtbAdSize.getWidth());
            this.slotUuid = slotUuid;
            this.setApsAdFormat(apsAdFormat);
        }
    }

    int getHeightFromAax() {
        try {
            return this.getDTBAds().get(0).getHeight();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error getting the height from ApsAd", e);
            return -1;
        }
    }

    int getWidthFromAax() {
        int width;
        try {
            width = this.getDTBAds().get(0).getWidth();
        }
        catch (RuntimeException e) {
            width = -1;
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error getting the width from ApsAd", e);
        }
        return width;
    }

    void setApsAdRequest(ApsAdRequest apsAdRequest) {
        this.apsAdRequest = apsAdRequest;
    }

    @Override
    public ApsAdRequest getAdLoader() {
        return this.getApsAdRequest();
    }

    void setAdView(ApsAdViewImpl apsAdView) {
        this.adViewWeakReference = new WeakReference<ApsAdViewImpl>(apsAdView);
    }

    public void setSlotUuid(String slotUuid) {
        this.slotUuid = slotUuid;
    }

    public ApsAdViewImpl getAdView() {
        if (this.adViewWeakReference == null) {
            return null;
        }
        return (ApsAdViewImpl)this.adViewWeakReference.get();
    }
}

