/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.amazon.aps.ads.ApsAd;
import com.amazon.aps.ads.ApsAdController;
import com.amazon.aps.ads.ApsAdFormatUtils;
import com.amazon.aps.ads.ApsAdUtils;
import com.amazon.aps.ads.ApsAdView;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.ads.activity.ApsInterstitialActivity;
import com.amazon.aps.ads.listeners.ApsAdListener;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0010\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\bJ\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\bJ\u0014\u0010(\u001a\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*J\u0006\u0010+\u001a\u00020\u001bJ\b\u0010,\u001a\u00020\u001bH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/amazon/aps/ads/ApsAdController;", "", "context", "Landroid/content/Context;", "listener", "Lcom/amazon/aps/ads/listeners/ApsAdListener;", "(Landroid/content/Context;Lcom/amazon/aps/ads/listeners/ApsAdListener;)V", "HTTPS_WEB_URL", "", "getHTTPS_WEB_URL", "()Ljava/lang/String;", "TAG", "apsAd", "Lcom/amazon/aps/ads/ApsAd;", "apsAdListener", "apsAdListenerInternal", "com/amazon/aps/ads/ApsAdController$apsAdListenerInternal$1", "Lcom/amazon/aps/ads/ApsAdController$apsAdListenerInternal$1;", "<set-?>", "Lcom/amazon/aps/ads/ApsAdView;", "apsAdView", "getApsAdView", "()Lcom/amazon/aps/ads/ApsAdView;", "", "isAdAvailable", "()Z", "addInViewGroup", "", "parent", "Landroid/view/ViewGroup;", "fetchAd", "fetchBannerAd", "extraInfo", "Landroid/os/Bundle;", "width", "", "height", "extraInfoAsString", "fetchInterstitialAd", "fetchRewardedAd", "safeCall", "action", "Lkotlin/Function0;", "show", "startOMSDKSession", "DTBAndroidSDK_release"})
public class ApsAdController {
    @NotNull
    private final Context context;
    @NotNull
    private final String HTTPS_WEB_URL;
    @Nullable
    private final String TAG;
    @NotNull
    private final ApsAdListener apsAdListener;
    private ApsAdView apsAdView;
    private boolean isAdAvailable;
    private ApsAd apsAd;
    @NotNull
    private final apsAdListenerInternal.1 apsAdListenerInternal;

    public ApsAdController(@NotNull Context context, @NotNull ApsAdListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.context = context;
        this.HTTPS_WEB_URL = "https://c.amazon-adsystem.com/";
        this.TAG = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        this.apsAdListener = listener;
        Object[] objectArray = new Object[]{this.context, listener};
        ApsAdUtils.checkNullAndLogInvalidArg(objectArray);
        this.apsAdListenerInternal = new ApsAdListener(this){
            final /* synthetic */ ApsAdController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAdLoaded(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onAdLoaded called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onAdLoaded(this.$apsAd);
                    }
                }));
            }

            public void onAdFailedToLoad(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onAdFailedToLoad called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onAdFailedToLoad(this.$apsAd);
                    }
                }));
            }

            public void onAdClicked(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onAdClicked called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onAdClicked(this.$apsAd);
                    }
                }));
            }

            public void onImpressionFired(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onImpressionFired called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onImpressionFired(this.$apsAd);
                    }
                }));
            }

            public void onAdError(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onAdError called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onAdError(this.$apsAd);
                    }
                }));
            }

            public void onAdOpen(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onAdOpen called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onAdOpen(this.$apsAd);
                    }
                }));
            }

            public void onAdClosed(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onAdClosed called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onAdClosed(this.$apsAd);
                    }
                }));
            }

            public void onVideoCompleted(@Nullable ApsAd apsAd) {
                this.this$0.safeCall((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, apsAd){
                    final /* synthetic */ ApsAdController this$0;
                    final /* synthetic */ ApsAd $apsAd;
                    {
                        this.this$0 = $receiver;
                        this.$apsAd = $apsAd;
                        super(0);
                    }

                    public final void invoke() {
                        ApsLog.d(ApsAdController.access$getTAG$p(this.this$0), "onVideoCompleted called");
                        ApsAdController.access$getApsAdListener$p(this.this$0).onVideoCompleted(this.$apsAd);
                    }
                }));
            }
        };
    }

    @NotNull
    public final String getHTTPS_WEB_URL() {
        return this.HTTPS_WEB_URL;
    }

    @NotNull
    public final ApsAdView getApsAdView() {
        ApsAdView apsAdView = this.apsAdView;
        if (apsAdView != null) {
            return apsAdView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"apsAdView");
        return null;
    }

    public final boolean isAdAvailable() {
        return this.isAdAvailable;
    }

    public final void fetchAd(@NotNull ApsAd apsAd) {
        Intrinsics.checkNotNullParameter((Object)apsAd, (String)"apsAd");
        Object[] objectArray = new Object[]{apsAd};
        ApsAdUtils.checkNullAndLogInvalidArg(objectArray);
        try {
            this.apsAd = apsAd;
            ApsAdFormat apsAdFormat = apsAd.getApsAdFormat();
            switch (apsAdFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[apsAdFormat.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.fetchBannerAd(apsAd);
                    break;
                }
                case 5: 
                case 6: {
                    this.fetchInterstitialAd(apsAd);
                    break;
                }
                case 7: {
                    ApsAdUtils.throwExceptionOrRemoteLog("InStream video adFormat not supported");
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdController - fetchAd", e);
        }
    }

    public final void show() {
        try {
            if (this.getApsAdView().getMraidHandler() == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "There is no controller before showing the interstitial ad");
                return;
            }
            DTBAdMRAIDController dTBAdMRAIDController = this.getApsAdView().getMraidHandler();
            if (dTBAdMRAIDController != null) {
                dTBAdMRAIDController.startOMSDKSession();
            }
            ApsLog.d(this.TAG, "Starting the Aps interstitial activity");
            ApsInterstitialActivity.Companion.setAdViewRefPassed(new WeakReference<ApsAdView>(this.getApsAdView()));
            this.context.startActivity(new Intent(this.context, ApsInterstitialActivity.class));
            ApsLog.d(this.TAG, "Sending the ApsAdView in live data");
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdController - show", e);
        }
    }

    private final void startOMSDKSession() {
        try {
            DtbOmSdkSessionManager dtbOmSdkSessionManager = this.getApsAdView().getOmSdkManager();
            if (dtbOmSdkSessionManager != null) {
                DtbOmSdkSessionManager it = dtbOmSdkSessionManager;
                boolean bl = false;
                if (!this.getApsAdView().isVideo()) {
                    it.initHtmlDisplayOmAdSession(this.getApsAdView(), this.getHTTPS_WEB_URL());
                } else {
                    it.initJavaScriptOmAdSession(this.getApsAdView(), this.getHTTPS_WEB_URL());
                }
                it.registerAdView(this.getApsAdView());
                it.startAdSession();
                it.displayAdEventLoaded();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Unable to start OM SDK session for Interstitial ad", e);
        }
    }

    public final void addInViewGroup(@NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        try {
            if (this.apsAd != null) {
                ApsAd apsAd;
                ApsAd apsAd2 = this.apsAd;
                if (apsAd2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
                    apsAd2 = null;
                }
                if ((apsAd = this.apsAd) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
                    apsAd = null;
                }
                if (apsAd.getAdView() != null) {
                    ApsAd apsAd3 = this.apsAd;
                    if (apsAd3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
                        apsAd3 = null;
                    }
                    parent.addView((View)apsAd3.getAdView());
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "API failure:ApsAdController - addInViewGroup", e);
        }
    }

    private final void fetchInterstitialAd(ApsAd apsAd) {
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.INTERSTITIAL, this.apsAdListenerInternal);
        this.getApsAdView().setApsAd(apsAd);
        this.getApsAdView().fetchAd(apsAd.getBidInfo(), apsAd.getRenderingBundle());
        apsAd.setAdView(this.getApsAdView());
    }

    private final void fetchBannerAd(ApsAd apsAd) {
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.BANNER, this.apsAdListenerInternal);
        this.getApsAdView().fetchAd(apsAd);
    }

    public final void fetchBannerAd(@NotNull Bundle extraInfo, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)extraInfo, (String)"extraInfo");
        this.apsAd = new ApsAd(extraInfo, ApsAdFormatUtils.getAdFormat(AdType.DISPLAY, height, width));
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.BANNER, this.apsAdListenerInternal);
        ApsAd apsAd = this.apsAd;
        if (apsAd == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd = null;
        }
        apsAd.setAdView(this.getApsAdView());
        ApsAdView apsAdView = this.getApsAdView();
        ApsAd apsAd2 = this.apsAd;
        if (apsAd2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd2 = null;
        }
        apsAdView.setApsAd(apsAd2);
        this.getApsAdView().fetchAd(extraInfo);
    }

    public final void fetchBannerAd(@NotNull String extraInfoAsString, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)extraInfoAsString, (String)"extraInfoAsString");
        this.apsAd = new ApsAd(extraInfoAsString, ApsAdFormatUtils.getAdFormat(AdType.DISPLAY, height, width));
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.BANNER, this.apsAdListenerInternal);
        ApsAd apsAd = this.apsAd;
        if (apsAd == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd = null;
        }
        apsAd.setAdView(this.getApsAdView());
        ApsAdView apsAdView = this.getApsAdView();
        ApsAd apsAd2 = this.apsAd;
        if (apsAd2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd2 = null;
        }
        apsAdView.setApsAd(apsAd2);
        this.getApsAdView().fetchAd(extraInfoAsString);
    }

    public final void fetchInterstitialAd(@NotNull Bundle extraInfo) {
        Intrinsics.checkNotNullParameter((Object)extraInfo, (String)"extraInfo");
        this.apsAd = new ApsAd(extraInfo, ApsAdFormatUtils.getAdFormat(AdType.INTERSTITIAL, 9999, 9999));
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.INTERSTITIAL, this.apsAdListenerInternal);
        ApsAd apsAd = this.apsAd;
        if (apsAd == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd = null;
        }
        apsAd.setAdView(this.getApsAdView());
        ApsAdView apsAdView = this.getApsAdView();
        ApsAd apsAd2 = this.apsAd;
        if (apsAd2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd2 = null;
        }
        apsAdView.setApsAd(apsAd2);
        this.getApsAdView().fetchAd(extraInfo);
    }

    public final void fetchInterstitialAd(@NotNull String extraInfoAsString) {
        Intrinsics.checkNotNullParameter((Object)extraInfoAsString, (String)"extraInfoAsString");
        this.apsAd = new ApsAd(extraInfoAsString, ApsAdFormatUtils.getAdFormat(AdType.INTERSTITIAL, 9999, 9999));
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.INTERSTITIAL, this.apsAdListenerInternal);
        ApsAd apsAd = this.apsAd;
        if (apsAd == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd = null;
        }
        apsAd.setAdView(this.getApsAdView());
        ApsAdView apsAdView = this.getApsAdView();
        ApsAd apsAd2 = this.apsAd;
        if (apsAd2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd2 = null;
        }
        apsAdView.setApsAd(apsAd2);
        this.getApsAdView().fetchAd(extraInfoAsString);
    }

    public final void fetchRewardedAd(@NotNull String extraInfoAsString) {
        Intrinsics.checkNotNullParameter((Object)extraInfoAsString, (String)"extraInfoAsString");
        this.apsAd = new ApsAd(extraInfoAsString, ApsAdFormatUtils.getAdFormat(AdType.VIDEO, 9999, 9999));
        this.apsAdView = new ApsAdView(this.context, ApsAdFormat.REWARDED_VIDEO, this.apsAdListenerInternal);
        ApsAd apsAd = this.apsAd;
        if (apsAd == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd = null;
        }
        apsAd.setAdView(this.getApsAdView());
        ApsAdView apsAdView = this.getApsAdView();
        ApsAd apsAd2 = this.apsAd;
        if (apsAd2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apsAd");
            apsAd2 = null;
        }
        apsAdView.setApsAd(apsAd2);
        this.getApsAdView().fetchAd(extraInfoAsString);
    }

    public final void safeCall(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            action.invoke();
        }
        catch (AbstractMethodError e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "AbstractMethodError listener method not implemented:ApsAdController - safeCall");
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Unexpected exception:ApsAdController - safeCall", e);
        }
    }

    public static final /* synthetic */ String access$getTAG$p(ApsAdController $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ ApsAdListener access$getApsAdListener$p(ApsAdController $this) {
        return $this.apsAdListener;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ApsAdFormat.values().length];
            nArray[ApsAdFormat.LEADERBOARD.ordinal()] = 1;
            nArray[ApsAdFormat.MREC.ordinal()] = 2;
            nArray[ApsAdFormat.BANNER_SMART.ordinal()] = 3;
            nArray[ApsAdFormat.BANNER.ordinal()] = 4;
            nArray[ApsAdFormat.REWARDED_VIDEO.ordinal()] = 5;
            nArray[ApsAdFormat.INTERSTITIAL.ordinal()] = 6;
            nArray[ApsAdFormat.INSTREAM_VIDEO.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

