/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import androidx.annotation.NonNull;
import com.amazon.aps.ads.ApsAdRequest;
import com.amazon.aps.ads.ApsMigrationUtil;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.ads.model.ApsAdRequestErrorCode;
import com.amazon.device.ads.AdError;

public class ApsAdError
extends AdError {
    private ApsAdRequest apsAdRequest;
    private String slotUuid;
    private ApsAdFormat apsAdFormatFromRequest;

    public ApsAdError(@NonNull AdError adError, @NonNull String slotUuid, @NonNull ApsAdFormat apsAdFormat) {
        super(adError.getCode(), adError.getMessage(), adError.getAdLoader());
        this.slotUuid = slotUuid;
        this.apsAdFormatFromRequest = apsAdFormat;
    }

    public String getSlotUuid() {
        return this.slotUuid;
    }

    public ApsAdRequestErrorCode getErrorCode() {
        return ApsMigrationUtil.getApsAdRequestErrorCode(super.getCode());
    }

    public ApsAdRequest getAdRequest() {
        if (this.apsAdRequest == null && this.refreshLoader != null) {
            this.setApsAdRequest(new ApsAdRequest(this.refreshLoader, this.slotUuid, this.apsAdFormatFromRequest));
        }
        return this.apsAdRequest;
    }

    void setApsAdRequest(@NonNull ApsAdRequest apsAdRequest) {
        this.apsAdRequest = apsAdRequest;
        this.slotUuid = apsAdRequest.getSlotUuid();
    }
}

