/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import androidx.annotation.NonNull;
import com.amazon.aps.ads.model.ApsAdNetwork;
import com.amazon.aps.ads.model.ApsAdRequestErrorCode;
import com.amazon.aps.ads.model.ApsAdType;
import com.amazon.aps.ads.model.ApsLogLevel;
import com.amazon.aps.ads.model.ApsMraidPolicy;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DTBAdNetwork;
import com.amazon.device.ads.DTBLogLevel;
import com.amazon.device.ads.MRAIDPolicy;

public class ApsMigrationUtil {
    private static boolean isApsInitCalled = false;
    private static boolean isApsRemoteConfigInProgress = false;
    private static boolean isApsInitInProgress = false;

    static synchronized void setApsInitInProgress(boolean isApsInitInProgress) {
        ApsMigrationUtil.isApsInitInProgress = isApsInitInProgress;
    }

    public static synchronized boolean isApsInitInProgress() {
        return isApsInitInProgress;
    }

    static synchronized void setIsApsInitCalled(boolean isApsInitCalled) {
        ApsMigrationUtil.isApsInitCalled = isApsInitCalled;
    }

    public static synchronized boolean getIsApsInitCalled() {
        return isApsInitCalled;
    }

    public static synchronized void setApsRemoteConfigInProgress(boolean isInProgress) {
        isApsRemoteConfigInProgress = isInProgress;
    }

    public static synchronized boolean isApsRemoteConfigInProgress() {
        return isApsRemoteConfigInProgress;
    }

    static AdError.ErrorCode getErrorCode(ApsAdRequestErrorCode errorCode) {
        switch (errorCode) {
            case NO_ERROR: {
                return AdError.ErrorCode.NO_ERROR;
            }
            case NETWORK_ERROR: {
                return AdError.ErrorCode.NETWORK_ERROR;
            }
            case NETWORK_TIMEOUT: {
                return AdError.ErrorCode.NETWORK_TIMEOUT;
            }
            case NO_FILL: {
                return AdError.ErrorCode.NO_FILL;
            }
            case REQUEST_ERROR: {
                return AdError.ErrorCode.REQUEST_ERROR;
            }
        }
        return AdError.ErrorCode.INTERNAL_ERROR;
    }

    static ApsAdRequestErrorCode getApsAdRequestErrorCode(AdError.ErrorCode errorCode) {
        switch (errorCode) {
            case NO_ERROR: {
                return ApsAdRequestErrorCode.NO_ERROR;
            }
            case NETWORK_ERROR: {
                return ApsAdRequestErrorCode.NETWORK_ERROR;
            }
            case NETWORK_TIMEOUT: {
                return ApsAdRequestErrorCode.NETWORK_TIMEOUT;
            }
            case NO_FILL: {
                return ApsAdRequestErrorCode.NO_FILL;
            }
            case REQUEST_ERROR: {
                return ApsAdRequestErrorCode.REQUEST_ERROR;
            }
        }
        return ApsAdRequestErrorCode.INTERNAL_ERROR;
    }

    public static AdType getAdType(ApsAdType apsAdType) {
        switch (apsAdType) {
            case VIDEO: {
                return AdType.VIDEO;
            }
            case INTERSTITIAL: {
                return AdType.INTERSTITIAL;
            }
        }
        return AdType.DISPLAY;
    }

    static DTBLogLevel getDTBLogLevel(@NonNull ApsLogLevel apsLogLevel) {
        switch (apsLogLevel) {
            case All: {
                return DTBLogLevel.All;
            }
            case Off: {
                return DTBLogLevel.Off;
            }
            case Info: {
                return DTBLogLevel.Info;
            }
            case Warn: {
                return DTBLogLevel.Warn;
            }
            case Debug: {
                return DTBLogLevel.Debug;
            }
            case Trace: {
                return DTBLogLevel.Trace;
            }
            case Fatal: {
                return DTBLogLevel.Fatal;
            }
        }
        return DTBLogLevel.Error;
    }

    static MRAIDPolicy getMRAIDPolicy(@NonNull ApsMraidPolicy apsMraidPolicy) {
        switch (apsMraidPolicy) {
            case DFP: {
                return MRAIDPolicy.DFP;
            }
            case CUSTOM: {
                return MRAIDPolicy.CUSTOM;
            }
            case NONE: {
                return MRAIDPolicy.NONE;
            }
        }
        return MRAIDPolicy.AUTO_DETECT;
    }

    static ApsMraidPolicy getApsMraidPolicy(@NonNull MRAIDPolicy mraidPolicy) {
        switch (mraidPolicy) {
            case DFP: {
                return ApsMraidPolicy.DFP;
            }
            case CUSTOM: {
                return ApsMraidPolicy.CUSTOM;
            }
            case NONE: {
                return ApsMraidPolicy.NONE;
            }
        }
        return ApsMraidPolicy.AUTO_DETECT;
    }

    static DTBAdNetwork getDTBAdNetworkInfo(ApsAdNetwork apsAdNetwork) {
        switch (apsAdNetwork) {
            case AD_GENERATION: {
                return DTBAdNetwork.AD_GENERATION;
            }
            case ADMOB: {
                return DTBAdNetwork.ADMOB;
            }
            case UNITY_LEVELPLAY: {
                return DTBAdNetwork.UNITY_LEVELPLAY;
            }
            case MAX: {
                return DTBAdNetwork.MAX;
            }
            case NIMBUS: {
                return DTBAdNetwork.NIMBUS;
            }
            case OTHER: {
                return DTBAdNetwork.OTHER;
            }
            case CUSTOM_MEDIATION: {
                return DTBAdNetwork.CUSTOM_MEDIATION;
            }
        }
        return DTBAdNetwork.UNKNOWN;
    }
}

