/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.privacy;

import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DtbSharedPreferences;
import com.iabtcf.decoder.DecoderOption;
import com.iabtcf.decoder.TCString;
import com.iabtcf.v2.PublisherRestriction;
import com.iabtcf.v2.RestrictionType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0004J\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u0004J\u0015\u0010\u001f\u001a\u00020\u00172\b\u0010 \u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010!J\u0015\u0010\u001f\u001a\u00020\u00172\b\u0010 \u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R$\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006'"}, d2={"Lcom/amazon/aps/ads/privacy/ApsGdprHandler;", "", "()V", "isApsVendorConsented", "", "Ljava/lang/Boolean;", "<set-?>", "isGdprApplies", "()Ljava/lang/Boolean;", "isPurpose1Consented", "()Z", "isTcfStringFound", "publisherRestrictions", "", "Lcom/iabtcf/v2/PublisherRestriction;", "purpose1ConsentFlag", "tcString", "Lcom/iabtcf/decoder/TCString;", "tcfVersion", "", "Ljava/lang/Integer;", "vendorListVersion", "calculatePurpose1Consent", "", "isGdprAppliesFalse", "isGdprAppliesTrue", "isPurpose1ConsentFlagOn", "isRestrictedVendorListNotHavingAps", "isValidTcfV2String", "isValidVendorVersion", "isVendorConsentOnForAps", "setGdprApplies", "isApplies", "(Ljava/lang/Boolean;)V", "(Ljava/lang/Integer;)V", "setGdprConsent", "consentString", "", "Companion", "DTBAndroidSDK_release"})
public final class ApsGdprHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TCString tcString;
    @Nullable
    private Boolean isGdprApplies;
    private boolean isPurpose1Consented;
    @Nullable
    private Integer tcfVersion;
    @Nullable
    private Boolean purpose1ConsentFlag;
    @Nullable
    private Integer vendorListVersion;
    @Nullable
    private Boolean isApsVendorConsented;
    @Nullable
    private List<? extends PublisherRestriction> publisherRestrictions;
    private boolean isTcfStringFound;
    private static final int APS_IAB_VENDOR_CONST = 793;
    private static final int APS_SUPPORTED_GVL_VERSION = 25;
    private static int p1CalcCount;

    @Nullable
    public final Boolean isGdprApplies() {
        return this.isGdprApplies;
    }

    public final boolean isPurpose1Consented() {
        return this.isPurpose1Consented;
    }

    public final boolean isTcfStringFound() {
        return this.isTcfStringFound;
    }

    public final void setGdprApplies(@Nullable Boolean isApplies) {
        this.isGdprApplies = isApplies;
    }

    public final void setGdprApplies(@Nullable Integer isApplies) {
        Boolean bl;
        if (isApplies != null) {
            int n = 1;
            bl = isApplies == n;
        } else {
            bl = null;
        }
        this.isGdprApplies = bl;
    }

    public final void setGdprConsent(@Nullable String consentString) {
        this.tcString = null;
        this.purpose1ConsentFlag = null;
        this.vendorListVersion = null;
        this.isApsVendorConsented = null;
        this.publisherRestrictions = null;
        this.isTcfStringFound = consentString != null && ((CharSequence)consentString).length() > 0;
        boolean parseError = false;
        String string = consentString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            try {
                Unit unit;
                TCString tCString = this.tcString = TCString.decode((String)consentString, (DecoderOption[])new DecoderOption[0]);
                if (tCString == null) {
                    unit = null;
                } else {
                    TCString it2 = tCString;
                    boolean bl2 = false;
                    this.tcfVersion = it2.getVersion();
                    this.purpose1ConsentFlag = it2.getPurposesConsent() == null ? (Boolean)null : Boolean.valueOf(it2.getPurposesConsent().contains(1));
                    this.vendorListVersion = it2.getVendorListVersion();
                    this.isApsVendorConsented = it2.getVendorConsent() == null ? (Boolean)null : Boolean.valueOf(it2.getVendorConsent().contains(APS_IAB_VENDOR_CONST));
                    this.publisherRestrictions = it2.getPublisherRestrictions();
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
            catch (Exception e) {
                ApsAdExtensionsKt.remoteLog(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error parsing the GDPR String", e);
                parseError = true;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable t) {
                ApsAdExtensionsKt.remoteLog(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error parsing the GDPR String", null);
                parseError = true;
                Unit unit = Unit.INSTANCE;
            }
        }
        this.calculatePurpose1Consent();
        try {
            JSONObject jSONObject;
            JSONObject $this$setGdprConsent_u24lambda_u2d2 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$setGdprConsent_u24lambda_u2d2.put("tcfParseError", parseError);
            $this$setGdprConsent_u24lambda_u2d2.put("nullTcf", consentString == null);
            $this$setGdprConsent_u24lambda_u2d2.put("isEmptyTcf", consentString != null && Intrinsics.areEqual((Object)consentString, (Object)""));
            $this$setGdprConsent_u24lambda_u2d2.put("isValidTcf", this.isValidTcfV2String());
            $this$setGdprConsent_u24lambda_u2d2.put("p1ConsentFlag", (Object)this.purpose1ConsentFlag);
            $this$setGdprConsent_u24lambda_u2d2.put("p1Consent", this.isPurpose1Consented());
            $this$setGdprConsent_u24lambda_u2d2.put("isEmptyGdprApplies", this.isGdprApplies() == null);
            $this$setGdprConsent_u24lambda_u2d2.put("gdprApplies", this.isGdprAppliesTrue());
            $this$setGdprConsent_u24lambda_u2d2.put("seqCount", ++p1CalcCount);
            $this$setGdprConsent_u24lambda_u2d2.put("gvlVersion", (Object)this.vendorListVersion);
            $this$setGdprConsent_u24lambda_u2d2.put("isApsVendorConsented", (Object)this.isApsVendorConsented);
            $this$setGdprConsent_u24lambda_u2d2.put("tcfVersion", (Object)this.tcfVersion);
            JSONObject params = jSONObject;
            boolean isIdfaSent = DtbSharedPreferences.getInstance().isValidIdfaAvailable();
            ApsMetrics.Companion.customEvent("gdprParsing", String.valueOf(isIdfaSent), params);
        }
        catch (Exception e) {
            ApsLog.e("Error sending the gdpr metrics");
        }
    }

    public final boolean isGdprAppliesTrue() {
        return this.isGdprApplies != null && Intrinsics.areEqual((Object)this.isGdprApplies, (Object)true);
    }

    public final boolean isGdprAppliesFalse() {
        return this.isGdprApplies != null && Intrinsics.areEqual((Object)this.isGdprApplies, (Object)false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidTcfV2String() {
        if (this.tcString == null) return false;
        if (this.tcfVersion == null) return false;
        Integer n = this.tcfVersion;
        int n2 = 2;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    public final boolean isPurpose1ConsentFlagOn() {
        return this.purpose1ConsentFlag != null && Intrinsics.areEqual((Object)this.purpose1ConsentFlag, (Object)true);
    }

    public final boolean isValidVendorVersion() {
        Integer n = this.vendorListVersion;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= APS_SUPPORTED_GVL_VERSION;
        }
        return this.vendorListVersion == null;
    }

    public final boolean isVendorConsentOnForAps() {
        return this.isApsVendorConsented != null && Intrinsics.areEqual((Object)this.isApsVendorConsented, (Object)true);
    }

    public final boolean isRestrictedVendorListNotHavingAps() {
        List<? extends PublisherRestriction> list = this.publisherRestrictions;
        if (list != null) {
            List<? extends PublisherRestriction> it = list;
            boolean bl = false;
            if (it.isEmpty()) {
                return this.isVendorConsentOnForAps();
            }
            for (PublisherRestriction publisherRestriction : it) {
                if (publisherRestriction.getPurposeId() != 1 || publisherRestriction.getVendorIds() == null || !publisherRestriction.getVendorIds().contains(APS_IAB_VENDOR_CONST) || publisherRestriction.getRestrictionType() == RestrictionType.NOT_ALLOWED || publisherRestriction.getRestrictionType() == RestrictionType.REQUIRE_LEGITIMATE_INTEREST) continue;
                return true;
            }
        }
        return this.isVendorConsentOnForAps();
    }

    public final void calculatePurpose1Consent() {
        boolean isTcfStringConsidered = this.isGdprAppliesTrue() || this.isGdprAppliesFalse() && this.isTcfStringFound || this.isGdprApplies == null && this.isTcfStringFound;
        this.isPurpose1Consented = isTcfStringConsidered && this.isValidTcfV2String() && this.isPurpose1ConsentFlagOn() && this.isValidVendorVersion() && this.isRestrictedVendorListNotHavingAps();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/amazon/aps/ads/privacy/ApsGdprHandler$Companion;", "", "()V", "APS_IAB_VENDOR_CONST", "", "getAPS_IAB_VENDOR_CONST", "()I", "APS_SUPPORTED_GVL_VERSION", "getAPS_SUPPORTED_GVL_VERSION", "p1CalcCount", "getP1CalcCount", "setP1CalcCount", "(I)V", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getAPS_IAB_VENDOR_CONST() {
            return APS_IAB_VENDOR_CONST;
        }

        public final int getAPS_SUPPORTED_GVL_VERSION() {
            return APS_SUPPORTED_GVL_VERSION;
        }

        public final int getP1CalcCount() {
            return p1CalcCount;
        }

        public final void setP1CalcCount(int n) {
            p1CalcCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

