/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.privacy;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.amazon.aps.ads.privacy.ApsGdprHandler;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbSharedPreferences;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020\u001aJ\u0010\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/amazon/aps/ads/privacy/ApsPrivacyManager;", "", "()V", "gdprHandler", "Lcom/amazon/aps/ads/privacy/ApsGdprHandler;", "isGdprToBeAppliedFromConfig", "", "Ljava/lang/Boolean;", "<set-?>", "isInitialized", "()Z", "keysInterested", "", "", "prefChangeListener", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "getBooleanValue", "prefs", "Landroid/content/SharedPreferences;", "key", "(Landroid/content/SharedPreferences;Ljava/lang/String;)Ljava/lang/Boolean;", "getIntValue", "", "(Landroid/content/SharedPreferences;Ljava/lang/String;)Ljava/lang/Integer;", "getStringValue", "init", "", "context", "Landroid/content/Context;", "isGdprConsentRequired", "isSystemResourceAccessAllowed", "removeConfigFileIfExists", "removeStoragesByApsIfNoConsent", "setGdprConfiguration", "jsonArray", "Lorg/json/JSONArray;", "setGdprConsent", "Companion", "DTBAndroidSDK_release"})
public class ApsPrivacyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> keysInterested;
    private boolean isInitialized;
    @NotNull
    private final ApsGdprHandler gdprHandler;
    @Nullable
    private Boolean isGdprToBeAppliedFromConfig;
    @NotNull
    private final SharedPreferences.OnSharedPreferenceChangeListener prefChangeListener;
    @JvmField
    @NotNull
    public static final ApsPrivacyManager INSTANCE = new ApsPrivacyManager();

    private ApsPrivacyManager() {
        Object[] objectArray = new String[]{"IABTCF_TCString", "IABTCF_gdprApplies"};
        this.keysInterested = SetsKt.setOf((Object[])objectArray);
        this.gdprHandler = new ApsGdprHandler();
        this.prefChangeListener = (arg_0, arg_1) -> ApsPrivacyManager.prefChangeListener$lambda-0(this, arg_0, arg_1);
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final void init(@Nullable Context context) {
        if (this.isInitialized) {
            return;
        }
        Context context2 = context;
        if (context2 != null) {
            Context nonNullContext = context2;
            boolean bl = false;
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)nonNullContext);
            if (sharedPreferences != null) {
                SharedPreferences it = sharedPreferences;
                boolean bl2 = false;
                this.setGdprConsent(it);
                it.registerOnSharedPreferenceChangeListener(this.prefChangeListener);
            }
            this.isInitialized = true;
        }
    }

    public final boolean isGdprConsentRequired() {
        Boolean bl = this.isGdprToBeAppliedFromConfig;
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            if (it) {
                return true;
            }
        }
        return this.gdprHandler.isGdprApplies() != null && Intrinsics.areEqual((Object)this.gdprHandler.isGdprApplies(), (Object)true) || this.gdprHandler.isTcfStringFound();
    }

    @Nullable
    public final Boolean getBooleanValue(@NotNull SharedPreferences prefs, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (prefs.contains(key)) {
            Boolean bl;
            Object value = prefs.getAll().get(key);
            if (value instanceof Boolean) {
                bl = Intrinsics.areEqual((Object)true, value);
            } else {
                if (value instanceof Integer) {
                    Object v = value;
                    return v instanceof Integer && 1 == ((Number)v).intValue();
                }
                if (value instanceof String) {
                    String string = ((String)value).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    bl = string.equals(true);
                } else {
                    bl = null;
                }
            }
            return bl;
        }
        return null;
    }

    @Nullable
    public final Integer getIntValue(@NotNull SharedPreferences prefs, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            if (prefs.contains(key)) {
                return prefs.getInt(key, 0);
            }
        }
        catch (Exception e) {
            ApsAdExtensionsKt.remoteLog(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error reading the shared pref value", e);
        }
        return null;
    }

    @Nullable
    public final String getStringValue(@NotNull SharedPreferences prefs, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            string = prefs.getString(key, null);
        }
        catch (Exception e) {
            ApsAdExtensionsKt.remoteLog(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error reading the shared pref value", e);
            string = null;
        }
        return string;
    }

    public final void setGdprConsent(@NotNull SharedPreferences prefs) {
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        this.gdprHandler.setGdprConsent(this.getStringValue(prefs, "IABTCF_TCString"));
        this.gdprHandler.setGdprApplies(this.getIntValue(prefs, "IABTCF_gdprApplies"));
        this.removeStoragesByApsIfNoConsent();
    }

    public final void removeStoragesByApsIfNoConsent() {
        if (!this.isSystemResourceAccessAllowed()) {
            DtbSharedPreferences.clearStorage();
            this.removeConfigFileIfExists();
        }
    }

    public final void removeConfigFileIfExists() {
        Context context = AdRegistration.getContext();
        if (context != null) {
            File file = context.getFilesDir();
            if (file != null) {
                File it = file;
                boolean bl = false;
                File f = new File(Intrinsics.stringPlus((String)it.getAbsolutePath(), (Object)"/config/aps_mobile_client_config.json"));
                if (f.exists()) {
                    f.delete();
                }
            }
        }
    }

    public final void setGdprConfiguration(@Nullable JSONArray jsonArray) {
        if (jsonArray != null) {
            int n = 0;
            int n2 = jsonArray.length();
            while (n < n2) {
                int index;
                if (!Intrinsics.areEqual((Object)"gdprtcfv2", (Object)jsonArray.get(index = n++))) continue;
                this.isGdprToBeAppliedFromConfig = true;
                return;
            }
        } else {
            this.isGdprToBeAppliedFromConfig = false;
        }
    }

    public final boolean isSystemResourceAccessAllowed() {
        return this.isGdprConsentRequired() ? this.gdprHandler != null && this.gdprHandler.isPurpose1Consented() : true;
    }

    private static final void prefChangeListener$lambda-0(ApsPrivacyManager this$0, SharedPreferences prefs, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ApsAdExtensionsKt.d(this$0, "Received the shared preference changed event");
        String string = key;
        if (Intrinsics.areEqual((Object)string, (Object)"IABTCF_TCString")) {
            ApsGdprHandler apsGdprHandler = this$0.gdprHandler;
            Intrinsics.checkNotNullExpressionValue((Object)prefs, (String)"prefs");
            apsGdprHandler.setGdprConsent(this$0.getStringValue(prefs, "IABTCF_TCString"));
        } else if (Intrinsics.areEqual((Object)string, (Object)"IABTCF_gdprApplies")) {
            ApsGdprHandler apsGdprHandler = this$0.gdprHandler;
            Intrinsics.checkNotNullExpressionValue((Object)prefs, (String)"prefs");
            apsGdprHandler.setGdprApplies(this$0.getBooleanValue(prefs, "IABTCF_gdprApplies"));
        }
        if (this$0.keysInterested.contains(key)) {
            this$0.removeStoragesByApsIfNoConsent();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/amazon/aps/ads/privacy/ApsPrivacyManager$Companion;", "", "()V", "INSTANCE", "Lcom/amazon/aps/ads/privacy/ApsPrivacyManager;", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

