/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.CookieManager;
import android.webkit.WebView;
import android.widget.ScrollView;
import com.amazon.aps.ads.metrics.ApsMetricsAdListenerAdapterBase;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.adview.ApsAdViewConstants;
import com.amazon.aps.ads.util.adview.ApsAdViewUtils;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdMRAIDBannerController;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdViewDisplayListener;
import com.amazon.device.ads.DTBTimeTrace;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010?\u001a\u00020@H\u0016J\u0014\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0010\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020\u0007H\u0016J\u0010\u0010G\u001a\u00020@2\u0006\u0010F\u001a\u00020\u0007H\u0016J\u0010\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u00020BH\u0016J\u001a\u0010H\u001a\u00020@2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010F\u001a\u00020\u0007H\u0014J\n\u0010J\u001a\u0004\u0018\u00010BH\u0016J\b\u0010K\u001a\u00020@H\u0016J\b\u0010L\u001a\u0004\u0018\u00010DJ\b\u0010M\u001a\u00020@H\u0004J\b\u0010N\u001a\u00020@H\u0014J\b\u0010O\u001a\u00020\u0007H\u0014J\u001a\u0010P\u001a\u00020@2\u0006\u0010Q\u001a\u00020\u00072\b\b\u0002\u0010R\u001a\u00020\u0007H\u0014J\b\u0010S\u001a\u00020@H$J\b\u0010T\u001a\u00020@H\u0016J\b\u0010U\u001a\u00020@H\u0016J\u0012\u0010V\u001a\u00020@2\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\u0018\u0010Y\u001a\u00020@2\u0006\u0010Z\u001a\u00020\u00162\u0006\u0010I\u001a\u00020BH$J\u0010\u0010[\u001a\u00020@2\u0006\u0010I\u001a\u00020BH$J(\u0010\\\u001a\u00020@2\u0006\u0010]\u001a\u00020\u00162\u0006\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020\u00162\u0006\u0010`\u001a\u00020\u0016H\u0016J\u0010\u0010a\u001a\u00020@2\u0006\u0010b\u001a\u00020\u0007H$J\b\u0010c\u001a\u00020@H$J\u0010\u0010d\u001a\u00020@2\u0006\u0010e\u001a\u00020\u0007H\u0016J\b\u0010f\u001a\u00020@H\u0014R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u00168\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R\u0012\u0010\u001f\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\fR\u0012\u0010\"\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\fR(\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u001b\u001a\u0004\u0018\u00010%@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R(\u0010,\u001a\u0004\u0018\u00010+2\b\u0010\u001b\u001a\u0004\u0018\u00010+@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u00102\u001a\u0004\u0018\u0001012\b\u0010\u001b\u001a\u0004\u0018\u000101@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0004\u0018\u0001068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R$\u00108\u001a\u0002072\u0006\u0010\u001b\u001a\u000207@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0012\u0010=\u001a\u0002078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010>\u001a\u0002078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewBase;", "Landroid/webkit/WebView;", "Lcom/amazon/aps/ads/util/adview/ApsAdViewConstants;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "value", "", "adViewScrollEnabled", "getAdViewScrollEnabled", "()Z", "setAdViewScrollEnabled", "(Z)V", "apsAdFormat", "Lcom/amazon/aps/ads/model/ApsAdFormat;", "", "bidId", "getBidId", "()Ljava/lang/String;", "setBidId", "(Ljava/lang/String;)V", "exposurePercent", "", "focusChangeListener", "Landroid/view/ViewTreeObserver$OnGlobalFocusChangeListener;", "globalLayoutListener", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "<set-?>", "hostname", "getHostname", "setHostname", "ignoreDetachment", "isAdViewVisible", "setAdViewVisible", "isFirstDisplay", "isVideo", "setVideo", "Lcom/amazon/device/ads/DTBAdMRAIDController;", "mraidHandler", "getMraidHandler", "()Lcom/amazon/device/ads/DTBAdMRAIDController;", "setMraidHandler", "(Lcom/amazon/device/ads/DTBAdMRAIDController;)V", "Lcom/amazon/aps/ads/metrics/ApsMetricsAdListenerAdapterBase;", "mraidListenerAdapter", "getMraidListenerAdapter", "()Lcom/amazon/aps/ads/metrics/ApsMetricsAdListenerAdapterBase;", "setMraidListenerAdapter", "(Lcom/amazon/aps/ads/metrics/ApsMetricsAdListenerAdapterBase;)V", "Lcom/amazon/device/ads/DtbOmSdkSessionManager;", "omSdkManager", "getOmSdkManager", "()Lcom/amazon/device/ads/DtbOmSdkSessionManager;", "scrollChangeListener", "Landroid/view/ViewTreeObserver$OnScrollChangedListener;", "", "startTime", "getStartTime", "()J", "setStartTime", "(J)V", "timeClicked", "timePressed", "cleanup", "", "computeAdViewRect", "Landroid/graphics/Rect;", "scrollView", "Landroid/widget/ScrollView;", "computeExposure", "enforced", "computeExposureInRootView", "computeExposureInScrollView", "adViewRect", "computeRootContainerRectInRootView", "finalize", "getScrollViewParent", "initLayoutListeners", "initWebView", "isMraidHandlerInitialized", "notifyViewabilityAndSetIsVisible", "flag", "overrideValidation", "onAdOpened", "onAttachedToWindow", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onExposureChange", "exposurePercentage", "onPositionChanged", "onScrollChanged", "l", "t", "oldl", "oldt", "onViewabilityChanged", "isChanged", "setCurrentPositionProperty", "setScrollEnabled", "enabled", "verifyIsVisible", "DTBAndroidSDK_release"})
public abstract class ApsAdViewBase
extends WebView
implements ApsAdViewConstants {
    @JvmField
    protected boolean ignoreDetachment;
    @JvmField
    protected boolean isFirstDisplay;
    @JvmField
    protected int exposurePercent;
    @JvmField
    protected long timePressed;
    @JvmField
    protected long timeClicked;
    @JvmField
    @Nullable
    protected ApsAdFormat apsAdFormat;
    @Nullable
    private DTBAdMRAIDController mraidHandler;
    @Nullable
    private ApsMetricsAdListenerAdapterBase mraidListenerAdapter;
    @JvmField
    @Nullable
    protected ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener;
    @JvmField
    @Nullable
    protected ViewTreeObserver.OnGlobalFocusChangeListener focusChangeListener;
    @JvmField
    @Nullable
    protected ViewTreeObserver.OnScrollChangedListener scrollChangeListener;
    @Nullable
    private DtbOmSdkSessionManager omSdkManager;
    private long startTime;
    private boolean isVideo;
    @Nullable
    private String hostname;
    @Nullable
    private String bidId;
    private boolean adViewScrollEnabled;
    private boolean isAdViewVisible;

    public ApsAdViewBase(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.isFirstDisplay = true;
        this.exposurePercent = -1;
        this.adViewScrollEnabled = true;
        CookieManager.getInstance().setAcceptCookie(true);
        this.omSdkManager = DtbOmSdkSessionManager.getNewInstance();
    }

    @Nullable
    public final DTBAdMRAIDController getMraidHandler() {
        return this.mraidHandler;
    }

    protected final void setMraidHandler(@Nullable DTBAdMRAIDController dTBAdMRAIDController) {
        this.mraidHandler = dTBAdMRAIDController;
    }

    @Nullable
    public final ApsMetricsAdListenerAdapterBase getMraidListenerAdapter() {
        return this.mraidListenerAdapter;
    }

    protected final void setMraidListenerAdapter(@Nullable ApsMetricsAdListenerAdapterBase apsMetricsAdListenerAdapterBase) {
        this.mraidListenerAdapter = apsMetricsAdListenerAdapterBase;
    }

    @Nullable
    public final DtbOmSdkSessionManager getOmSdkManager() {
        return this.omSdkManager;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(long l) {
        this.startTime = l;
    }

    public final boolean isVideo() {
        return this.isVideo;
    }

    protected final void setVideo(boolean bl) {
        this.isVideo = bl;
    }

    @Nullable
    public final String getHostname() {
        return this.hostname;
    }

    protected final void setHostname(@Nullable String string) {
        this.hostname = string;
    }

    @Nullable
    public final String getBidId() {
        return this.bidId;
    }

    protected final void setBidId(@Nullable String value) {
        this.bidId = value;
        ApsMetricsAdListenerAdapterBase apsMetricsAdListenerAdapterBase = this.mraidListenerAdapter;
        if (apsMetricsAdListenerAdapterBase != null) {
            apsMetricsAdListenerAdapterBase.setBidId(value);
        }
    }

    protected final boolean getAdViewScrollEnabled() {
        return this.adViewScrollEnabled;
    }

    protected final void setAdViewScrollEnabled(boolean value) {
        this.adViewScrollEnabled = value;
        this.setVerticalScrollBarEnabled(value);
        this.setHorizontalScrollBarEnabled(value);
    }

    public final boolean isAdViewVisible() {
        return this.isAdViewVisible;
    }

    protected final void setAdViewVisible(boolean value) {
        this.isAdViewVisible = value;
        if (!this.isAdViewVisible) {
            this.exposurePercent = -1;
            if (this.isMraidHandlerInitialized()) {
                this.onExposureChange(0, new Rect(0, 0, 0, 0));
            }
        }
    }

    protected abstract void onExposureChange(int var1, @NotNull Rect var2);

    protected abstract void onPositionChanged(@NotNull Rect var1);

    protected abstract void onAdOpened();

    protected abstract void setCurrentPositionProperty();

    protected abstract void onViewabilityChanged(boolean var1);

    protected boolean isMraidHandlerInitialized() {
        return this.mraidHandler != null;
    }

    protected final void initLayoutListeners() {
        this.globalLayoutListener = () -> ApsAdViewBase.initLayoutListeners$lambda-0(this);
        this.focusChangeListener = (arg_0, arg_1) -> ApsAdViewBase.initLayoutListeners$lambda-1(this, arg_0, arg_1);
        this.scrollChangeListener = () -> ApsAdViewBase.initLayoutListeners$lambda-2(this);
    }

    public void cleanup() {
    }

    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (this.adViewScrollEnabled) {
            super.onScrollChanged(l, t, oldt, oldl);
        } else {
            this.scrollTo(0, 0);
        }
    }

    @Nullable
    public final ScrollView getScrollViewParent() {
        return ApsAdViewUtils.Companion.getScrollViewParent(this);
    }

    protected void initWebView() {
        ApsAdViewUtils.Companion.initWebView(this);
    }

    @Nullable
    public Rect computeAdViewRect(@Nullable ScrollView scrollView) {
        return ApsAdViewUtils.Companion.computeAdViewRect(this, scrollView);
    }

    public int computeExposureInScrollView(@NotNull Rect adViewRect) {
        Intrinsics.checkNotNullParameter((Object)adViewRect, (String)"adViewRect");
        return ApsAdViewUtils.Companion.computeExposureInScrollView(this, adViewRect);
    }

    public void setScrollEnabled(boolean enabled) {
        this.setAdViewScrollEnabled(enabled);
        this.setVerticalScrollBarEnabled(enabled);
        this.setHorizontalScrollBarEnabled(enabled);
    }

    @Nullable
    public Rect computeRootContainerRectInRootView() {
        return ApsAdViewUtils.Companion.computeRootContainerRectInRootView(this);
    }

    protected void notifyViewabilityAndSetIsVisible(boolean flag, boolean overrideValidation) {
        if (this.isAdViewVisible || overrideValidation) {
            if (this.isMraidHandlerInitialized()) {
                this.onViewabilityChanged(flag);
            }
            this.setAdViewVisible(flag);
        }
    }

    public static /* synthetic */ void notifyViewabilityAndSetIsVisible$default(ApsAdViewBase apsAdViewBase, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyViewabilityAndSetIsVisible");
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        apsAdViewBase.notifyViewabilityAndSetIsVisible(bl, bl2);
    }

    public void finalize() {
        try {
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            if (viewTreeObserver != null) {
                ViewTreeObserver it = viewTreeObserver;
                boolean bl = false;
                it.removeOnGlobalLayoutListener(this.globalLayoutListener);
                it.removeOnScrollChangedListener(this.scrollChangeListener);
                it.removeOnGlobalFocusChangeListener(this.focusChangeListener);
            }
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute finalize method", e);
        }
    }

    protected void verifyIsVisible() {
        ApsAdExtensionsKt.d(this, Intrinsics.stringPlus((String)"method verifyIsVisible called: ", (Object)this.isAdViewVisible));
        ApsAdViewUtils.Companion.verifyIsVisible(this, this.isAdViewVisible, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>((Object)this){

            public final void invoke(boolean p0, boolean p1) {
                ((ApsAdViewBase)this.receiver).notifyViewabilityAndSetIsVisible(p0, p1);
            }
        }));
        if (this.isAdViewVisible) {
            this.computeExposure(false);
        }
    }

    public void computeExposureInRootView(boolean enforced) {
        Rect rect = this.computeRootContainerRectInRootView();
        if (rect != null) {
            Rect it = rect;
            boolean bl = false;
            int[] pos = new int[2];
            this.getLocationOnScreen(pos);
            Rect adViewRect = new Rect(pos[0], pos[1], pos[0] + this.getWidth(), pos[1] + this.getHeight());
            float area = this.getWidth() * this.getHeight();
            if (adViewRect.intersect(it)) {
                float newArea = (adViewRect.right - adViewRect.left) * (adViewRect.bottom - adViewRect.top);
                int percentage = (int)(100.0 * (double)newArea / (double)area + 0.5);
                if (percentage != this.exposurePercent || enforced) {
                    this.exposurePercent = percentage;
                    this.onExposureChange(this.exposurePercent, adViewRect);
                }
            } else if (this.exposurePercent != 0 || enforced) {
                this.exposurePercent = 0;
                adViewRect.top = adViewRect.bottom;
                this.onExposureChange(this.exposurePercent, adViewRect);
            }
        }
    }

    public void onDetachedFromWindow() {
        try {
            super.onDetachedFromWindow();
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            if (viewTreeObserver != null) {
                ViewTreeObserver viewTreeObserver2;
                ViewTreeObserver $this$onDetachedFromWindow_u24lambda_u2d5 = viewTreeObserver2 = viewTreeObserver;
                boolean bl = false;
                $this$onDetachedFromWindow_u24lambda_u2d5.removeOnGlobalLayoutListener(this.globalLayoutListener);
                $this$onDetachedFromWindow_u24lambda_u2d5.removeOnScrollChangedListener(this.scrollChangeListener);
                $this$onDetachedFromWindow_u24lambda_u2d5.removeOnGlobalFocusChangeListener(this.focusChangeListener);
            }
            DTBAdMRAIDController dTBAdMRAIDController = this.mraidHandler;
            if (dTBAdMRAIDController != null) {
                DTBAdMRAIDController it = dTBAdMRAIDController;
                boolean bl = false;
                if (it instanceof DTBAdMRAIDBannerController && this.getOmSdkManager() != null) {
                    DtbOmSdkSessionManager dtbOmSdkSessionManager = this.getOmSdkManager();
                    if (dtbOmSdkSessionManager != null) {
                        dtbOmSdkSessionManager.stopOmAdSession();
                    }
                }
            }
            this.mraidListenerAdapter = null;
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute onDetachedFromWindow method in ApsAdView class", e);
        }
    }

    public void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        if (this.isFirstDisplay) {
            DTBTimeTrace dTBTimeTrace = DTBTimeTrace.getInstance();
            if (dTBTimeTrace != null) {
                DTBTimeTrace it = dTBTimeTrace;
                boolean bl = false;
                if (AdRegistration.isTestMode()) {
                    it.addPhase("AD displayed");
                    it.logTrace();
                }
            }
            if (this.mraidHandler instanceof DTBAdViewDisplayListener) {
                DTBAdMRAIDController dTBAdMRAIDController = this.mraidHandler;
                if (dTBAdMRAIDController == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.device.ads.DTBAdViewDisplayListener");
                }
                ((DTBAdViewDisplayListener)((Object)dTBAdMRAIDController)).onInitialDisplay();
            }
            this.isFirstDisplay = false;
        }
    }

    public void onAttachedToWindow() {
        try {
            super.onAttachedToWindow();
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            if (viewTreeObserver != null) {
                ViewTreeObserver viewTreeObserver2;
                ViewTreeObserver $this$onAttachedToWindow_u24lambda_u2d8 = viewTreeObserver2 = viewTreeObserver;
                boolean bl = false;
                $this$onAttachedToWindow_u24lambda_u2d8.addOnGlobalLayoutListener(this.globalLayoutListener);
                $this$onAttachedToWindow_u24lambda_u2d8.addOnGlobalFocusChangeListener(this.focusChangeListener);
                $this$onAttachedToWindow_u24lambda_u2d8.addOnScrollChangedListener(this.scrollChangeListener);
            }
            if (this.isMraidHandlerInitialized()) {
                this.onAdOpened();
            }
        }
        catch (RuntimeException e) {
            ApsAdExtensionsKt.logEvent(this, APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute onAttachedToWindow method", e);
        }
    }

    protected void computeExposureInScrollView(@Nullable ScrollView scrollView, boolean enforced) {
        Rect rect = this.computeAdViewRect(scrollView);
        if (rect != null) {
            Rect it = rect;
            boolean bl = false;
            int percentage = this.computeExposureInScrollView(it);
            if (percentage != this.exposurePercent || enforced) {
                this.exposurePercent = percentage;
                this.onExposureChange(this.exposurePercent, it);
                this.setCurrentPositionProperty();
            }
        }
    }

    public void computeExposure(boolean enforced) {
        ScrollView scrollView = this.getScrollViewParent();
        if (scrollView != null) {
            this.computeExposureInScrollView(scrollView, enforced);
        } else {
            int[] pos = new int[2];
            this.getLocationInWindow(pos);
            Rect adViewRect = new Rect(pos[0], pos[1], pos[0] + this.getWidth(), pos[1] + this.getHeight());
            if (this.isMraidHandlerInitialized()) {
                this.computeExposureInRootView(enforced);
                this.onPositionChanged(adViewRect);
            }
        }
    }

    private static final void initLayoutListeners$lambda-0(ApsAdViewBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.verifyIsVisible();
    }

    private static final void initLayoutListeners$lambda-1(ApsAdViewBase this$0, View $noName_0, View $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.verifyIsVisible();
    }

    private static final void initLayoutListeners$lambda-2(ApsAdViewBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.verifyIsVisible();
    }
}

