/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.webkit.WebView;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.adview.ApsAdViewImpl;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdMRAIDBannerController;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBExpectedSizeProvider;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDeviceData;
import com.amazon.device.ads.DtbOmSdkSessionManager;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.WebResourceService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewFetchUtils;", "", "()V", "Companion", "DTBAndroidSDK_release"})
public final class ApsAdViewFetchUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ApsAdViewFetchUtils() {
    }

    @JvmStatic
    public static final void getAdInfo(@Nullable String adhtml, @NotNull Bundle adInfoBundle) {
        Companion.getAdInfo(adhtml, adInfoBundle);
    }

    @JvmStatic
    public static final void fetchAdWithLocation(@NotNull Context context, @NotNull WebView webView, boolean localOnly, @Nullable String url) {
        Companion.fetchAdWithLocation(context, webView, localOnly, url);
    }

    @JvmStatic
    @NotNull
    public static final String getMobileDeviceInfo() {
        return Companion.getMobileDeviceInfo();
    }

    @JvmStatic
    @Nullable
    public static final String getEnvironment(@NotNull Context context, @Nullable Bundle extras) {
        return Companion.getEnvironment(context, extras);
    }

    @JvmStatic
    public static final void loadLocalFile(@NotNull Context context, boolean localOnly, @NotNull String name, @NotNull StringBuilder sb) {
        Companion.loadLocalFile(context, localOnly, name, sb);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000eJ*\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\fH\u0007J$\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001c\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010\u001d\u001a\u00020\nH\u0007J,\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\n2\n\u0010 \u001a\u00060!j\u0002`\"H\u0007\u00a8\u0006#"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewFetchUtils$Companion;", "", "()V", "fetchAd", "", "webView", "Lcom/amazon/aps/ads/util/adview/ApsAdViewImpl;", "mraidListener", "Lcom/amazon/device/ads/DTBAdMRAIDController;", "adHtml", "", "extraData", "Landroid/os/Bundle;", "extra", "", "fetchAdWithLocation", "context", "Landroid/content/Context;", "Landroid/webkit/WebView;", "localOnly", "", "url", "getAdInfo", "adhtml", "adInfoBundle", "getBundleForFetchAd", "mraidHandler", "getEnvironment", "extras", "getMobileDeviceInfo", "loadLocalFile", "name", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void getAdInfo(@Nullable String adhtml, @NotNull Bundle adInfoBundle) {
            Pattern pattern;
            Matcher matcher;
            Intrinsics.checkNotNullParameter((Object)adInfoBundle, (String)"adInfoBundle");
            if (adhtml != null && StringsKt.contains$default((CharSequence)adhtml, (CharSequence)"amzn.dtb.loadAd", (boolean)false, (int)2, null) && (matcher = (pattern = Pattern.compile("amzn.dtb.loadAd\\(\\\"(.*)\\\", \\\"(.*)\\\", \\\"(.*)\\\".*isv: (\\w+)")).matcher(adhtml)).find() && matcher.groupCount() == 4) {
                adInfoBundle.putString("event_server_parameter", matcher.group(1));
                adInfoBundle.putString("bid_identifier", matcher.group(2));
                adInfoBundle.putString("hostname_identifier", matcher.group(3));
                adInfoBundle.putBoolean("video_flag", Boolean.parseBoolean(matcher.group(4)));
            }
        }

        @Nullable
        public final Bundle getBundleForFetchAd(@NotNull DTBAdMRAIDController mraidHandler, @Nullable String adHtml, @Nullable Bundle extraData) {
            Intrinsics.checkNotNullParameter((Object)mraidHandler, (String)"mraidHandler");
            String adHtml2 = null;
            adHtml2 = adHtml;
            Bundle bundleData = extraData;
            if (adHtml2 == null) {
                Bundle bundle = bundleData;
                if (bundle != null) {
                    Bundle it = bundle;
                    boolean bl = false;
                    adHtml2 = it.getString("bid_html_template", null);
                }
            }
            if (bundleData != null && mraidHandler instanceof DTBAdMRAIDBannerController) {
                DTBAdBannerListener listener = ((DTBAdMRAIDBannerController)mraidHandler).bannerListener;
                int expectedWidth = bundleData.getInt("expected_width", 0);
                int expectedHeight = bundleData.getInt("expected_height", 0);
                if (expectedHeight > 0 && expectedWidth > 0 && listener instanceof DTBExpectedSizeProvider) {
                    DTBExpectedSizeProvider provider = (DTBExpectedSizeProvider)((Object)listener);
                    provider.setExpectedWidth(expectedWidth);
                    provider.setExpectedHeight(expectedHeight);
                }
            }
            if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("webviewAdInfo_feature") && bundleData == null) {
                Bundle localExtraData = new Bundle();
                this.getAdInfo(adHtml2, localExtraData);
                String string = "{bidID:'%s',aaxHost:'%s',pricePoint:'%s'}";
                Object[] objectArray = new Object[]{localExtraData.getString("bid_identifier"), localExtraData.getString("hostname_identifier"), localExtraData.getString("event_server_parameter")};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                localExtraData.putString("amazon_ad_info", string2);
                bundleData = localExtraData;
            }
            return bundleData;
        }

        public final void fetchAd(@NotNull ApsAdViewImpl webView, @Nullable String adHtml, @Nullable Map<String, ? extends Object> extra) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            try {
                Bundle bundle = DtbCommonUtils.initializeEmptyBundle();
                Map<String, ? extends Object> map = extra;
                if (map != null) {
                    Map<String, ? extends Object> map2;
                    Map<String, ? extends Object> $this$fetchAd_u24lambda_u2d1 = map2 = map;
                    boolean bl = false;
                    for (Map.Entry<String, ? extends Object> entry : extra.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof String) {
                            bundle.putString(key, (String)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            bundle.putBoolean(key, ((Boolean)value).booleanValue());
                            continue;
                        }
                        if (value instanceof Integer) {
                            bundle.putInt(key, ((Number)value).intValue());
                            continue;
                        }
                        if (!(value instanceof Long)) continue;
                        bundle.putLong(key, ((Number)value).longValue());
                    }
                }
                webView.fetchAd(adHtml, bundle);
            }
            catch (RuntimeException e) {
                ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute fetchAd method with map bundle", e);
            }
        }

        public final void fetchAd(@NotNull ApsAdViewImpl webView, @NotNull DTBAdMRAIDController mraidListener, @Nullable String adHtml, @Nullable Bundle extraData) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)mraidListener, (String)"mraidListener");
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("<!DOCTYPE html><html><head>");
                sb.append("<script>");
                String environment = this.getEnvironment(webView.getAdViewContext(), extraData);
                sb.append(environment);
                sb.append("</script>");
                Context context = webView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"webView.context");
                this.loadLocalFile(context, webView.getLocalOnly(), "aps-mraid", sb);
                context = webView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"webView.context");
                this.loadLocalFile(context, webView.getLocalOnly(), "dtb-m", sb);
                if (DtbOmSdkSessionManager.getFeatureEnableFlag()) {
                    context = webView.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"webView.context");
                    this.loadLocalFile(context, webView.getLocalOnly(), "omsdk-v1", sb);
                }
                sb.append("</head>");
                sb.append("<body style='margin:0;padding:0;'>");
                sb.append(adHtml);
                sb.append("</body></html>");
                if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("additional_webview_metric", false)) {
                    if (mraidListener instanceof DTBAdMRAIDBannerController) {
                        ApsMetrics.Companion.customEvent("bannerCreativeRenderingStart", webView.getBidId(), null);
                    } else {
                        ApsMetrics.Companion.customEvent("interstitialCreativeRenderingStart", webView.getBidId(), null);
                    }
                }
                webView.loadDataWithBaseURL("https://c.amazon-adsystem.com/", sb.toString(), "text/html", "UTF-8", null);
            }
            catch (RuntimeException e) {
                ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute fetchAd method with bundle", e);
            }
        }

        @JvmStatic
        public final void fetchAdWithLocation(@NotNull Context context, @NotNull WebView webView, boolean localOnly, @Nullable String url) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("<script>");
                String environment = this.getEnvironment(context, null);
                sb.append(environment);
                sb.append("</script>");
                this.loadLocalFile(context, localOnly, "aps-mraid", sb);
                sb.append("<script>");
                sb.append("window.location=\"").append(url).append("\";");
                sb.append("</script>");
                webView.loadDataWithBaseURL("https://c.amazon-adsystem.com/", sb.toString(), "text/html", "UTF-8", null);
            }
            catch (RuntimeException e) {
                ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute fetchAdWithLocation method", e);
            }
        }

        @JvmStatic
        @NotNull
        public final String getMobileDeviceInfo() {
            String model = null;
            model = "";
            String screenSize = null;
            screenSize = "";
            String orientation = null;
            orientation = "";
            String osVersion = null;
            osVersion = "";
            try {
                JSONObject jSONObject = DtbDeviceData.getDeviceDataInstance().getParamsJson();
                if (jSONObject != null) {
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    JSONObject it = jSONObject;
                    boolean bl = false;
                    if (it.has("osVersion")) {
                        string5 = it.getString("osVersion");
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.getString(\n          \u2026                        )");
                        string4 = string5;
                    } else {
                        string4 = osVersion;
                    }
                    osVersion = string4;
                    if (it.has("model")) {
                        string5 = it.getString("model");
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.getString(\n          \u2026                        )");
                        string3 = string5;
                    } else {
                        string3 = model;
                    }
                    model = string3;
                    if (it.has("screenSize")) {
                        string5 = it.getString("screenSize");
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.getString(\n          \u2026                        )");
                        string2 = string5;
                    } else {
                        string2 = screenSize;
                    }
                    screenSize = string2;
                    if (it.has("orientation")) {
                        string5 = it.getString("orientation");
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.getString(\n          \u2026                        )");
                        string = string5;
                    } else {
                        string = orientation;
                    }
                    orientation = string;
                }
            }
            catch (RuntimeException e) {
                ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to parse deviceData in getMobileDeviceInfo method", e);
            }
            String string = "{os:'%s',fwk:'%s',osVersion:'%s',model:'%s',screenSize:'%s',orientation:'%s'}";
            Object[] objectArray = new Object[]{"android", DtbCommonUtils.getSDKFramework(), osVersion, model, screenSize, orientation};
            String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
            return string6;
        }

        @JvmStatic
        @Nullable
        public final String getEnvironment(@NotNull Context context, @Nullable Bundle extras) {
            String string;
            Boolean optOut;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String amazonInfo = null;
            if (extras != null) {
                amazonInfo = extras.getString("amazon_ad_info");
            }
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            String applicationLabel = null;
            applicationLabel = "";
            PackageManager packageManager2 = packageManager;
            if (packageManager2 != null) {
                CharSequence charSequence = packageManager2.getApplicationLabel(applicationInfo);
                if (charSequence != null) {
                    CharSequence it = charSequence;
                    boolean bl = false;
                    applicationLabel = (String)it;
                }
            }
            String idfa = DtbSharedPreferences.getInstance().getIdfa();
            if (DtbCommonUtils.isNullOrEmpty(idfa)) {
                idfa = "unknown";
            }
            if ((optOut = DtbSharedPreferences.getInstance().getOptOut()) == null) {
                optOut = false;
            }
            boolean coppa = false;
            String mobileDeviceInfo = this.getMobileDeviceInfo();
            if (amazonInfo == null) {
                String string2 = "window.MRAID_ENV={version:'%s',sdk:'%s',sdkVersion:'%s',appId:'%s',ifa:'%s',limitAdTracking:%b,coppa:%b,impFired:true,mobileDeviceInfo:%s};";
                Object[] objectArray = new Object[]{"3.0", DtbCommonUtils.getSDKMRAIDVersion(), "10.1.1", StringsKt.replace$default((String)applicationLabel, (String)"'", (String)"\\'", (boolean)false, (int)4, null), idfa, optOut, coppa, mobileDeviceInfo};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                string = string3;
            } else {
                String string4 = "window.MRAID_ENV={version:'%s',sdk:'%s',sdkVersion:'%s',appId:'%s',ifa:'%s',limitAdTracking:%b,coppa:%b,amznAdInfo:%s,impFired:true,mobileDeviceInfo:%s};";
                Object[] objectArray = new Object[]{"3.0", DtbCommonUtils.getSDKMRAIDVersion(), "10.1.1", StringsKt.replace$default((String)applicationLabel, (String)"'", (String)"\\'", (boolean)false, (int)4, null), idfa, optOut, coppa, amazonInfo, mobileDeviceInfo};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                string = string5;
            }
            return string;
        }

        @JvmStatic
        public final void loadLocalFile(@NotNull Context context, boolean localOnly, @NotNull String name, @NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            if (!localOnly) {
                try {
                    String content = WebResourceService.getInstance().loadFile(name);
                    if (content != null) {
                        sb.append("<script>").append(content).append("</script>");
                        return;
                    }
                }
                catch (Exception e) {
                    ApsAdExtensionsKt.e(this, "Failed to read local file");
                }
            }
            sb.append("<script>");
            try {
                InputStream inputStream = context.getAssets().open(Intrinsics.stringPlus((String)name, (Object)".js"));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(\"$name.js\")");
                InputStream inputStream2 = inputStream;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));
                while (true) {
                    String string = reader.readLine();
                    if (string == null) break;
                    String str = string;
                    str = ((Object)StringsKt.trim((CharSequence)str)).toString();
                    sb.append(str).append("\n");
                }
                reader.close();
                inputStream2.close();
            }
            catch (Exception e) {
                ApsAdExtensionsKt.e(this, Intrinsics.stringPlus((String)"Error reading file:", (Object)name));
            }
            sb.append("</script>");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

