/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ScrollView;
import com.amazon.aps.ads.Aps;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.adview.ApsAdViewBase;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewUtils;", "", "()V", "Companion", "DTBAndroidSDK_release"})
public final class ApsAdViewUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ApsAdViewUtils() {
    }

    @JvmStatic
    public static final void verifyIsVisible(@NotNull ApsAdViewBase webView, boolean isAdViewVisible, @NotNull Function2<? super Boolean, ? super Boolean, Unit> notifyViewabilityAndSetIsVisible) {
        Companion.verifyIsVisible(webView, isAdViewVisible, notifyViewabilityAndSetIsVisible);
    }

    @JvmStatic
    @Nullable
    public static final ScrollView getScrollViewParent(@NotNull WebView webView) {
        return Companion.getScrollViewParent(webView);
    }

    @JvmStatic
    @Nullable
    public static final Rect computeAdViewRect(@NotNull WebView webView, @Nullable ScrollView scrollView) {
        return Companion.computeAdViewRect(webView, scrollView);
    }

    @JvmStatic
    public static final int computeExposureInScrollView(@NotNull WebView webView, @NotNull Rect adViewRect) {
        return Companion.computeExposureInScrollView(webView, adViewRect);
    }

    @JvmStatic
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static final void initWebView(@NotNull WebView webView) {
        Companion.initWebView(webView);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J2\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000f0\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewUtils$Companion;", "", "()V", "computeAdViewRect", "Landroid/graphics/Rect;", "webView", "Landroid/webkit/WebView;", "scrollView", "Landroid/widget/ScrollView;", "computeExposureInScrollView", "", "adViewRect", "computeRootContainerRectInRootView", "getScrollViewParent", "initWebView", "", "verifyIsVisible", "Lcom/amazon/aps/ads/util/adview/ApsAdViewBase;", "isAdViewVisible", "", "notifyViewabilityAndSetIsVisible", "Lkotlin/Function2;", "DTBAndroidSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void verifyIsVisible(@NotNull ApsAdViewBase webView, boolean isAdViewVisible, @NotNull Function2<? super Boolean, ? super Boolean, Unit> notifyViewabilityAndSetIsVisible) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter(notifyViewabilityAndSetIsVisible, (String)"notifyViewabilityAndSetIsVisible");
            if (webView.getParent() == null || webView.getVisibility() != 0) {
                notifyViewabilityAndSetIsVisible.invoke((Object)false, (Object)false);
                return;
            }
            Activity activity = AdRegistration.getCurrentActivity();
            if (activity == null) {
                notifyViewabilityAndSetIsVisible.invoke((Object)false, (Object)false);
                return;
            }
            ViewGroup activityContentView = null;
            try {
                activityContentView = (ViewGroup)activity.findViewById(0x1020002);
            }
            catch (RuntimeException e) {
                ApsAdExtensionsKt.logEvent(this, APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to get content view", e);
            }
            if (activityContentView == null) {
                notifyViewabilityAndSetIsVisible.invoke((Object)false, (Object)false);
                return;
            }
            int[] rootPos = new int[2];
            activityContentView.getLocationInWindow(rootPos);
            Rect rootContainer = new Rect(rootPos[0], rootPos[1], rootPos[0] + activityContentView.getWidth(), rootPos[1] + activityContentView.getHeight());
            int[] pos = new int[2];
            webView.getLocationInWindow(pos);
            Rect adViewRect = new Rect(pos[0], pos[1], pos[0] + webView.getWidth(), pos[1] + webView.getHeight());
            if (!rootContainer.contains(adViewRect) && !Rect.intersects((Rect)rootContainer, (Rect)adViewRect)) {
                notifyViewabilityAndSetIsVisible.invoke((Object)false, (Object)false);
            } else {
                ScrollView scrollView = webView.getScrollViewParent();
                if (scrollView != null) {
                    int[] scrollPos = new int[2];
                    scrollView.getLocationInWindow(scrollPos);
                    Rect scrollRect = new Rect(scrollPos[0], scrollPos[1], scrollPos[0] + scrollView.getWidth(), scrollPos[1] + scrollView.getHeight());
                    if (!Rect.intersects((Rect)adViewRect, (Rect)scrollRect)) {
                        notifyViewabilityAndSetIsVisible.invoke((Object)false, (Object)true);
                        ApsAdExtensionsKt.d(this, "SET MRAID Visible false because of scroll ");
                    } else if (Rect.intersects((Rect)adViewRect, (Rect)scrollRect) && !isAdViewVisible) {
                        notifyViewabilityAndSetIsVisible.invoke((Object)true, (Object)(!isAdViewVisible ? 1 : 0));
                        ApsAdExtensionsKt.d(this, "SET MRAID Visible true because of scroll ");
                    }
                } else {
                    notifyViewabilityAndSetIsVisible.invoke((Object)true, (Object)(!isAdViewVisible ? 1 : 0));
                }
            }
        }

        @JvmStatic
        @Nullable
        public final ScrollView getScrollViewParent(@NotNull WebView webView) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            View view = (View)webView;
            while (true) {
                ViewParent viewParent;
                ViewGroup viewGroup = (viewParent = view.getParent()) instanceof ViewGroup ? (ViewGroup)viewParent : null;
                if (viewGroup == null) break;
                ViewParent parent = (ViewParent)viewGroup;
                if (parent instanceof ScrollView) {
                    return (ScrollView)parent;
                }
                view = (View)parent;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Rect computeAdViewRect(@NotNull WebView webView, @Nullable ScrollView scrollView) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Activity activity = DTBAdUtil.getActivity((View)webView);
            if (activity == null) {
                return null;
            }
            Activity activity2 = activity;
            View view = activity2.findViewById(0x1020002);
            ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
            if (viewGroup == null) {
                return null;
            }
            ViewGroup activityContentView = viewGroup;
            int[] rootPos = new int[2];
            activityContentView.getLocationInWindow(rootPos);
            Rect rootContainer = new Rect(rootPos[0], rootPos[1], rootPos[0] + activityContentView.getWidth(), rootPos[1] + activityContentView.getHeight());
            int[] pos = new int[2];
            webView.getLocationInWindow(pos);
            Rect adViewRect = new Rect(pos[0], pos[1], pos[0] + webView.getWidth(), pos[1] + webView.getHeight());
            if (scrollView == null) {
                adViewRect.intersect(rootContainer);
            } else {
                int[] scrollPos = new int[2];
                scrollView.getLocationInWindow(scrollPos);
                Rect scrollRect = new Rect(scrollPos[0], scrollPos[1], scrollPos[0] + scrollView.getWidth(), scrollPos[1] + scrollView.getHeight());
                scrollRect.intersect(rootContainer);
                adViewRect.intersect(scrollRect);
            }
            return adViewRect;
        }

        @JvmStatic
        public final int computeExposureInScrollView(@NotNull WebView webView, @NotNull Rect adViewRect) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)adViewRect, (String)"adViewRect");
            float area = webView.getWidth() * webView.getHeight();
            float newArea = (adViewRect.right - adViewRect.left) * (adViewRect.bottom - adViewRect.top);
            int percentage = 0;
            if (!(area == 0.0f)) {
                percentage = (int)((float)100 * newArea / area);
            }
            return percentage;
        }

        @Nullable
        public final Rect computeRootContainerRectInRootView(@NotNull WebView webView) {
            ViewGroup viewGroup;
            Activity activity;
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            ViewParent viewParent = webView.getParent();
            View parent = viewParent instanceof View ? (View)viewParent : null;
            Activity activity2 = activity = parent != null ? DTBAdUtil.getActivity(parent) : DTBAdUtil.getActivity((View)webView);
            if (activity == null) {
                return null;
            }
            Activity activity3 = activity;
            View view = activity3.findViewById(0x1020002);
            ViewGroup viewGroup2 = viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
            if (viewGroup == null) {
                return null;
            }
            ViewGroup activityContentView = viewGroup;
            int[] rootPos = new int[2];
            activityContentView.getLocationInWindow(rootPos);
            return new Rect(rootPos[0], rootPos[1], rootPos[0] + activityContentView.getWidth(), rootPos[1] + activityContentView.getHeight());
        }

        @JvmStatic
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public final void initWebView(@NotNull WebView webView) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            WebSettings webSettings = webView.getSettings();
            if (webSettings != null) {
                WebSettings webSettings2;
                WebSettings $this$initWebView_u24lambda_u2d0 = webSettings2 = webSettings;
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 19) {
                    WebView.setWebContentsDebuggingEnabled((boolean)Aps.isTestingMode());
                }
                $this$initWebView_u24lambda_u2d0.setJavaScriptEnabled(true);
                $this$initWebView_u24lambda_u2d0.setAllowContentAccess(true);
                $this$initWebView_u24lambda_u2d0.setDomStorageEnabled(true);
                $this$initWebView_u24lambda_u2d0.setAppCacheEnabled(true);
                $this$initWebView_u24lambda_u2d0.setAllowFileAccess(false);
                $this$initWebView_u24lambda_u2d0.setLoadsImagesAutomatically(true);
                $this$initWebView_u24lambda_u2d0.setMediaPlaybackRequiresUserGesture(false);
                $this$initWebView_u24lambda_u2d0.setBlockNetworkImage(false);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

