/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads.util.adview;

import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import com.amazon.aps.ads.util.ApsAdExtensionsKt;
import com.amazon.aps.ads.util.adview.ApsWebBridgeListener;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.MraidCommand;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0007R\"\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/amazon/aps/ads/util/adview/ApsAdViewWebBridge;", "", "listener", "Lcom/amazon/aps/ads/util/adview/ApsWebBridgeListener;", "(Lcom/amazon/aps/ads/util/adview/ApsWebBridgeListener;)V", "executionException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getExecutionException", "()Ljava/lang/Exception;", "setExecutionException", "(Ljava/lang/Exception;)V", "getListener", "()Lcom/amazon/aps/ads/util/adview/ApsWebBridgeListener;", "echo", "", "json", "Lorg/json/JSONObject;", "handleApsCommand", "apsEvent", "handleMraidCommand", "request", "handleServiceCall", "handleVideoEvent", "videoEvent", "logFromJavasScript", "message", "", "postMessage", "args", "DTBAndroidSDK_release"})
public class ApsAdViewWebBridge {
    @NotNull
    private final ApsWebBridgeListener listener;
    @Nullable
    private Exception executionException;

    public ApsAdViewWebBridge(@NotNull ApsWebBridgeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @NotNull
    public final ApsWebBridgeListener getListener() {
        return this.listener;
    }

    @Nullable
    public final Exception getExecutionException() {
        return this.executionException;
    }

    public final void setExecutionException(@Nullable Exception exception) {
        this.executionException = exception;
    }

    @JavascriptInterface
    public final void postMessage(@Nullable String args) {
        try {
            JSONObject json = new JSONObject(args);
            if (json.has("type")) {
                String type = json.getString("type");
                if (Intrinsics.areEqual((Object)"service", (Object)type)) {
                    this.handleServiceCall(json);
                } else if (Intrinsics.areEqual((Object)"mraid", (Object)type)) {
                    this.handleMraidCommand(json);
                } else if (Intrinsics.areEqual((Object)"aps", (Object)type)) {
                    this.handleApsCommand(json);
                } else if (Intrinsics.areEqual((Object)"apsvid", (Object)type)) {
                    this.handleVideoEvent(json);
                }
                return;
            }
            ApsAdExtensionsKt.e(this, "Unrecognized bridge call");
        }
        catch (JSONException e) {
            ApsAdExtensionsKt.d(this, Intrinsics.stringPlus((String)"JSON conversion failed:", (Object)((Object)e)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void handleVideoEvent(@NotNull JSONObject videoEvent) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)videoEvent, (String)"videoEvent");
        String subtype = videoEvent.getString("subtype");
        if (DtbCommonUtils.isNullOrWhiteSpace(subtype)) return;
        if (this.listener.getApsMraidHandler() == null) return;
        String string = subtype;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1135343643: {
                    if (!string.equals("END_CARD_VIDEO_CLOSED")) break;
                    n = 1;
                    break;
                }
                case 604315076: {
                    if (!string.equals("AD_FAILED_TO_LOAD")) break;
                    n = 2;
                    break;
                }
                case -100915287: {
                    if (!string.equals("AD_VIDEO_PLAYER_CLICKED")) break;
                    n = 3;
                    break;
                }
                case -1928679091: {
                    if (!string.equals("AD_VIDEO_PLAYER_COMPLETED")) break;
                    n = 4;
                    break;
                }
                case 1690844065: {
                    if (!string.equals("AD_LOADED")) break;
                    n = 5;
                    break;
                }
                case 252691236: {
                    if (!string.equals("END_CARD_COMPANION_AD_START")) break;
                    n = 6;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                    if (dTBAdMRAIDController == null) {
                        return;
                    }
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.onVideoCompleted();
                    return;
                }
                case 3: {
                    DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                    if (dTBAdMRAIDController == null) {
                        return;
                    }
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.onAdClicked();
                    return;
                }
                case 5: {
                    DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                    if (dTBAdMRAIDController == null) {
                        return;
                    }
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.onAdLoaded();
                    return;
                }
                case 2: {
                    DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                    if (dTBAdMRAIDController == null) {
                        return;
                    }
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.onAdFailedToLoad();
                    return;
                }
                case 1: {
                    DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                    if (dTBAdMRAIDController == null) {
                        return;
                    }
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.stopOMSDKSession();
                    return;
                }
                case 6: {
                    DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                    if (dTBAdMRAIDController == null) {
                        return;
                    }
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.startEndCardDisplayOMSDKSession();
                    return;
                }
            }
        }
        ApsAdExtensionsKt.i(this, Intrinsics.stringPlus((String)subtype, (Object)" video event not supported"));
    }

    public final void handleServiceCall(@NotNull JSONObject request) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String subtype = request.getString("subtype");
        if (Intrinsics.areEqual((Object)"log", (Object)subtype)) {
            JSONObject arguments = request.getJSONObject("arguments");
            String string = arguments.getString("message");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arguments.getString(\"message\")");
            this.logFromJavasScript(string);
        }
    }

    public final void handleApsCommand(@NotNull JSONObject apsEvent) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)apsEvent, (String)"apsEvent");
        String subtype = apsEvent.getString("subtype");
        if (!DtbCommonUtils.isNullOrWhiteSpace(subtype) && this.listener.getApsMraidHandler() != null) {
            String string = subtype;
            if (Intrinsics.areEqual((Object)string, (Object)"onAdLoaded")) {
                DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                if (dTBAdMRAIDController != null) {
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.onAdLoaded();
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)"onAdFailedToLoad")) {
                DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
                if (dTBAdMRAIDController != null) {
                    DTBAdMRAIDController it = dTBAdMRAIDController;
                    boolean bl = false;
                    it.onAdFailedToLoad();
                }
            } else {
                ApsAdExtensionsKt.i(this, Intrinsics.stringPlus((String)subtype, (Object)" aps event not supported"));
            }
        }
    }

    public final void handleMraidCommand(@NotNull JSONObject request) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.executionException = null;
        String command = request.getString("subtype");
        Class<MraidCommand> clazz = MraidCommand.findMraidCommandByName(command);
        if (clazz == null) {
            ApsAdExtensionsKt.e(this, "MRAID Command:" + command + " is not found");
            DTBAdMRAIDController dTBAdMRAIDController = this.listener.getApsMraidHandler();
            Intrinsics.checkNotNull((Object)dTBAdMRAIDController);
            dTBAdMRAIDController.fireErrorEvent(command, Intrinsics.stringPlus((String)command, (Object)" is not supported"));
            DTBAdMRAIDController dTBAdMRAIDController2 = this.listener.getApsMraidHandler();
            Intrinsics.checkNotNull((Object)dTBAdMRAIDController2);
            dTBAdMRAIDController2.commandCompleted(command);
            return;
        }
        try {
            MraidCommand mraidCommand = clazz.newInstance();
            if (mraidCommand == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.amazon.device.ads.MraidCommand");
            }
            MraidCommand cmd = mraidCommand;
            ApsAdExtensionsKt.d(this, Intrinsics.stringPlus((String)"execute command ", (Object)cmd.getName()));
            JSONObject arguments = request.getJSONObject("arguments");
            cmd.execute(arguments, this.listener.getApsMraidHandler());
        }
        catch (JSONException jsx) {
            throw jsx;
        }
        catch (Exception e) {
            this.executionException = e;
            ApsAdExtensionsKt.e(this, "Error execution command " + command + ' ' + e.getLocalizedMessage());
        }
    }

    private final void logFromJavasScript(String message) {
        ApsAdExtensionsKt.d(this, Intrinsics.stringPlus((String)"mraid:JSNative: ", (Object)message));
    }

    public final void echo(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            int promiseId = json.getInt("promiseId");
            String message = Intrinsics.stringPlus((String)json.getJSONObject("arguments").getString("greeting"), (Object)" Returned");
            String string = "window.promiseResolve(%d, '%s');";
            Object[] objectArray = new Object[]{promiseId, message};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String scriplet = string2;
            new Handler(Looper.getMainLooper()).post(() -> ApsAdViewWebBridge.echo$lambda-8(this, scriplet));
        }
        catch (JSONException e) {
            ApsAdExtensionsKt.d(this, Intrinsics.stringPlus((String)"JSON conversion failed:", (Object)((Object)e)));
        }
    }

    private static final void echo$lambda-8(ApsAdViewWebBridge this$0, String $scriplet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$scriplet, (String)"$scriplet");
        this$0.listener.evaluateApsJavascript($scriplet, null);
    }
}

