/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.amazon.device.ads.AdRegistration;
import java.util.HashSet;

class AdUtils {
    public static final String REQUIRED_ACTIVITY = "com.amazon.device.ads.AdActivity";
    private static AdUtilsExecutor executor = new AdUtilsExecutor();

    private AdUtils() {
    }

    public static double calculateScalingMultiplier(int absoluteAdWidth, int absoluteAdHeight, int absoluteWindowWidth, int absoluteWindowHeight) {
        return executor.calculateScalingMultiplier(absoluteAdWidth, absoluteAdHeight, absoluteWindowWidth, absoluteWindowHeight);
    }

    public static int pixelToDeviceIndependentPixel(int px) {
        return executor.pixelToDeviceIndependentPixel(px);
    }

    public static int deviceIndependentPixelToPixel(int dp) {
        return executor.deviceIndependentPixelToPixel(dp);
    }

    public static float getScalingFactorAsFloat() {
        return executor.getScalingFactorAsFloat();
    }

    static class AdUtilsExecutor {
        private final HashSet<String> requiredActivities = new HashSet();
        private boolean hasRequiredActivities = false;

        AdUtilsExecutor() {
            this.requiredActivities.add(AdUtils.REQUIRED_ACTIVITY);
        }

        double calculateScalingMultiplier(int absoluteAdWidth, int absoluteAdHeight, int absoluteWindowWidth, int absoluteWindowHeight) {
            double heightRatio = (double)absoluteWindowHeight / (double)absoluteAdHeight;
            double widthRatio = (double)absoluteWindowWidth / (double)absoluteAdWidth;
            double multiplier = (heightRatio < widthRatio || widthRatio == 0.0) && heightRatio != 0.0 ? heightRatio : widthRatio;
            return multiplier == 0.0 ? 1.0 : multiplier;
        }

        int pixelToDeviceIndependentPixel(int px) {
            return (int)((float)px / this.getScalingFactorAsFloat());
        }

        int deviceIndependentPixelToPixel(int dp) {
            return (int)(dp == -1 ? (float)dp : (float)dp * this.getScalingFactorAsFloat());
        }

        float getScalingFactorAsFloat() {
            WindowManager windowManager = (WindowManager)AdRegistration.getContext().getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            return metrics.scaledDensity;
        }
    }
}

