/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.LinearLayout;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.ActivityMonitor;
import com.amazon.device.ads.DTBAdActivity;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdExpandedListener;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdMRAIDExpandedController;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBMRAIDCloseButtonListener;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbThreadService;
import com.amazon.device.ads.MraidStateType;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DTBAdMRAIDBannerController
extends DTBAdMRAIDController
implements DTBMRAIDCloseButtonListener {
    private static final int ANIMATION_DURATION = 500;
    private static AtomicInteger indexDispencer;
    private static List<WeakReference<DTBAdMRAIDBannerController>> bannerControllers;
    public DTBAdBannerListener bannerListener;
    private ViewGroup defaultParent;
    private ViewGroup expandedBackground;
    private ObjectAnimator animater;
    private float originalX;
    private float originalY;
    private int originalXPos;
    private int originalYPos;
    private int originalWidth;
    private int originalHeight;
    private ViewGroup.LayoutParams originalParams;
    private int index = indexDispencer.incrementAndGet();
    private float animationProgress;
    private AnimationPoint startAnimation;
    private AnimationPoint endAnimation;

    public void setAnimationProgress(float animationProgress) {
        this.animationProgress = animationProgress;
    }

    public DTBAdMRAIDBannerController(DTBAdView adView, DTBAdBannerListener bannerListener) {
        super(adView);
        this.bannerListener = bannerListener;
        this.customButtonListener = this;
    }

    @Override
    public void onPageLoad() {
        try {
            if (!this.pageLoaded) {
                this.prepareMraid();
                if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("additional_webview_metric", false)) {
                    ApsMetrics.customEvent("bannerCreativeFinished", this.getAdView().getBidId(), null);
                }
            }
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute onPageLoad for Banner", e);
        }
        this.originalParams = this.getAdView().getLayoutParams();
    }

    @Override
    protected String getPlacementType() {
        return "inline";
    }

    @Override
    protected void onMRAIDClose() {
        if (this.state == MraidStateType.RESIZED) {
            this.moveResizedToDefault();
        } else if (this.state == MraidStateType.EXPANDED) {
            this.moveExpandedToDefault();
        } else if (this.state == MraidStateType.DEFAULT) {
            this.setState(MraidStateType.HIDDEN);
            this.commandCompleted("close");
        } else {
            this.fireErrorEvent("close", "Command is not allowed in a given ad state:" + this.state.toString());
            this.commandCompleted("close");
        }
    }

    private void moveResizedToDefault() {
        this.moveResizedToDefault(500, false);
    }

    private void moveResizedToDefault(int animationDuration, boolean isUnloadRequired) {
        new Handler(Looper.getMainLooper()).post(() -> this.moveResizedToDefaultImpl(animationDuration, isUnloadRequired));
    }

    private void moveResizedToDefaultImpl(int animationDuration, boolean isUnloadRequired) {
        AnimationPoint p = this.startAnimation;
        this.startAnimation = this.endAnimation;
        this.endAnimation = p;
        this.endAnimation.height = this.originalHeight;
        this.endAnimation.width = this.originalWidth;
        this.endAnimation.xPos = this.originalXPos;
        this.endAnimation.yPos = this.originalYPos;
        ViewGroup vg = (ViewGroup)this.getAdView().getParent();
        if (this.closeIndicatorRegion != null) {
            vg.removeView((View)this.closeIndicatorRegion);
            this.closeIndicatorRegion = null;
        }
        this.animater = ObjectAnimator.ofFloat((Object)this, (String)"animationProgress", (float[])new float[]{0.0f, 1.0f});
        this.animater.addUpdateListener(a -> {
            Float value = this.updateAdViewLayout(a);
            if (value.floatValue() == 1.0f) {
                this.updateResizedToDefaultListener(vg, isUnloadRequired);
            }
        });
        this.animater.setDuration((long)animationDuration);
        this.animater.start();
    }

    private void moveExpandedToDefault() {
        this.moveExpandedToDefault(500, false);
    }

    private void moveExpandedToDefault(int animationDuration, boolean isUnloadRequired) {
        new Handler(Looper.getMainLooper()).post(() -> this.moveExpandedToDefaultImpl(animationDuration, isUnloadRequired));
    }

    private void moveExpandedToDefaultImpl(int animationDuration, boolean isUnloadRequired) {
        ViewGroup parent;
        AnimationPoint p = this.startAnimation;
        this.startAnimation = this.endAnimation;
        this.endAnimation = p;
        ViewGroup vg = (ViewGroup)this.getAdView().getParent();
        if (this.closeIndicatorRegion != null && (parent = (ViewGroup)this.closeIndicatorRegion.getParent()) != null) {
            parent.removeView((View)this.closeIndicatorRegion);
            this.closeIndicatorRegion = null;
        }
        this.animater = ObjectAnimator.ofFloat((Object)this, (String)"animationProgress", (float[])new float[]{0.0f, 1.0f});
        this.animater.addUpdateListener(a -> {
            Float value = this.updateAdViewLayout(a);
            if (value.floatValue() == 1.0f) {
                this.updateExpandedToDefaultListener(vg, isUnloadRequired);
            }
        });
        this.animater.setDuration((long)animationDuration);
        this.animater.start();
    }

    @Override
    protected void onMRAIDUnload() {
        if (this.state == MraidStateType.RESIZED) {
            this.moveResizedToDefault(10, true);
        } else if (this.state == MraidStateType.EXPANDED) {
            this.moveExpandedToDefault(10, true);
        } else {
            new Handler(Looper.getMainLooper()).post(() -> {
                this.getAdView().loadUrl("about:blank");
                this.commandCompleted("unload");
            });
        }
    }

    @Override
    protected void onResize(Map<String, Object> parameters) {
        if (this.state != MraidStateType.DEFAULT && this.state != MraidStateType.RESIZED) {
            this.fireErrorEvent("resize", "invalid current state");
            this.commandCompleted("resize");
            return;
        }
        try {
            int tmp = 0;
            if (parameters.containsKey("offsetX")) {
                tmp = (Integer)parameters.get("offsetX");
            }
            int offsetX = tmp;
            tmp = 0;
            if (parameters.containsKey("offsetY")) {
                tmp = (Integer)parameters.get("offsetY");
            }
            int offsetY = tmp;
            int width = (Integer)parameters.get("width");
            int height = (Integer)parameters.get("height");
            boolean allowOffscreen = (Boolean)parameters.get("allowOffscreen");
            new Handler(Looper.getMainLooper()).post(() -> this.onResizeImpl(offsetX, offsetY, width, height, allowOffscreen));
        }
        catch (Exception e) {
            this.fireErrorEvent("resize", "invalid input parameters");
            this.commandCompleted("resize");
        }
    }

    private void onResizeImpl(int offsetX, int offsetY, int width, int height, boolean allowOffscreen) {
        ViewGroup rootView = DTBAdUtil.getRootView((View)this.getAdView());
        if (rootView == null) {
            this.fireErrorEvent("resize", "rootview doesn't exist");
            this.commandCompleted("resize");
            return;
        }
        this.removeCloseIndicator();
        int[] pos = new int[2];
        this.getAdView().getLocationInWindow(pos);
        int[] rootPos = new int[2];
        rootView.getLocationInWindow(rootPos);
        if (this.defaultParent == null) {
            this.originalX = this.getAdView().getX();
            this.originalY = this.getAdView().getY();
            this.originalWidth = this.getAdView().getWidth();
            this.originalHeight = this.getAdView().getHeight();
            this.originalXPos = pos[0] - rootPos[0];
            this.originalYPos = pos[1] - rootPos[1];
            this.defaultParent = (ViewGroup)this.getAdView().getParent();
            this.originalParams = this.getAdView().getLayoutParams();
            this.getAdView().setIgnoreDetachment();
            this.defaultParent.removeView((View)this.getAdView());
        }
        int rootViewHeight = rootView.getHeight();
        int rootViewWidth = rootView.getWidth();
        int resizedPosX = this.originalXPos + DTBAdUtil.sizeToDevicePixels(offsetX);
        int resizedPosY = this.originalYPos + DTBAdUtil.sizeToDevicePixels(offsetY);
        if (!allowOffscreen) {
            if (resizedPosX > rootViewWidth - 20) {
                resizedPosX = rootViewWidth - 20;
            }
            if (resizedPosX < 0) {
                resizedPosX = 0;
            }
            if (resizedPosY > rootViewHeight - 20) {
                resizedPosY = rootViewHeight - 20;
            }
            if (resizedPosY < 0) {
                resizedPosY = 0;
            }
        }
        int finalResizedPosY = resizedPosY;
        this.startAnimation = new AnimationPoint(pos[0] - rootPos[0], pos[1] - rootPos[1], this.getAdView().getWidth(), this.getAdView().getHeight());
        int widthPx = DTBAdUtil.sizeToDevicePixels(width);
        int heightPx = DTBAdUtil.sizeToDevicePixels(height);
        int correctedWidth = widthPx;
        int correctedHeight = heightPx;
        if (!allowOffscreen) {
            int temp;
            int n = temp = resizedPosX + widthPx < rootViewWidth ? widthPx : rootViewWidth - resizedPosX;
            if (temp < 0) {
                temp = 0;
            }
            correctedWidth = temp;
            int n2 = correctedHeight = resizedPosY + heightPx < rootViewHeight ? heightPx : rootViewHeight - resizedPosY;
            if (correctedHeight < 0) {
                correctedHeight = 0;
            }
        }
        int finalWidth = correctedWidth;
        int finalHeight = correctedHeight;
        int finalPosX = resizedPosX;
        if (this.getAdView().getParent() != rootView) {
            ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(this.getAdView().getWidth(), this.getAdView().getHeight());
            params.leftMargin = this.startAnimation.xPos;
            params.topMargin = this.startAnimation.yPos;
            rootView.addView((View)this.getAdView(), (ViewGroup.LayoutParams)params);
        }
        this.endAnimation = new AnimationPoint(resizedPosX, resizedPosY, correctedWidth, correctedHeight);
        this.setCurrentPositionProperty(DTBAdUtil.pixelsToDeviceIndependenPixels(correctedWidth), DTBAdUtil.pixelsToDeviceIndependenPixels(correctedHeight));
        this.animater = ObjectAnimator.ofFloat((Object)this, (String)"animationProgress", (float[])new float[]{0.0f, 1.0f});
        this.animater.addUpdateListener(a -> {
            Float value = this.updateAdViewLayout(a);
            if (value.floatValue() == 1.0f) {
                this.fireSizeChange(DTBAdUtil.pixelsToDeviceIndependenPixels(finalWidth), DTBAdUtil.pixelsToDeviceIndependenPixels(finalHeight));
                this.addCloseIndicator(finalPosX + finalWidth, finalResizedPosY);
                this.commandCompleted("resize");
                this.setState(MraidStateType.RESIZED);
                this.animater = null;
                this.getAdView().computeExposure(true);
            }
        });
        this.animater.setDuration(500L);
        this.animater.start();
    }

    @Override
    protected void expand(Map<String, Object> args) {
        if (!this.state.equals((Object)MraidStateType.DEFAULT)) {
            this.fireErrorEvent("expand", "current state does not allow transition to expand");
            this.commandCompleted("expand");
            return;
        }
        new Handler(Looper.getMainLooper()).post(() -> {
            String url = (String)args.get("url");
            if (url != null) {
                this.executeTwoPartsExpand(args);
            } else {
                this.executeOnePartExpand(args);
            }
        });
    }

    private void executeTwoPartsExpand(Map<String, Object> args) {
        String url = (String)args.get("url");
        Activity activity = DTBAdUtil.getActivity((View)this.getAdView());
        Intent intent = new Intent((Context)activity, DTBAdActivity.class);
        if (url != null) {
            intent.putExtra("url", url);
        }
        intent.putExtra("ad_state", "expanded");
        intent.putExtra("cntrl_index", this.index);
        intent.putExtra("two_part_expand", true);
        if (args.get("orientation") != null) {
            intent.putExtra("orientation", (Serializable)args.get("orientation"));
        }
        activity.startActivity(intent);
        this.commandCompleted("expand");
        this.setState(MraidStateType.EXPANDED);
        bannerControllers.add(new WeakReference<DTBAdMRAIDBannerController>(this));
    }

    private void executeOnePartExpand(Map<String, Object> args) {
        boolean useCustomClose = false;
        this.originalX = this.getAdView().getX();
        this.originalY = this.getAdView().getY();
        ViewGroup rootView = DTBAdUtil.getRootView((View)this.getAdView());
        if (rootView == null) {
            this.fireErrorEvent("expand", "rootview doesn't exist in one part expand");
            this.commandCompleted("expand");
            return;
        }
        int[] pos = new int[2];
        this.getAdView().getLocationInWindow(pos);
        this.defaultParent = (ViewGroup)this.getAdView().getParent();
        this.originalParams = this.getAdView().getLayoutParams();
        this.getAdView().setIgnoreDetachment();
        this.defaultParent.removeView((View)this.getAdView());
        int[] rootPos = new int[2];
        rootView.getLocationInWindow(rootPos);
        int rootViewHeight = rootView.getHeight();
        int rootViewWidth = rootView.getWidth();
        boolean finalResizedPosY = false;
        this.startAnimation = new AnimationPoint(pos[0] - rootPos[0], pos[1] - rootPos[1], this.getAdView().getWidth(), this.getAdView().getHeight());
        int widthPx = rootViewWidth;
        int heightPx = rootViewHeight;
        int correctedWidth = widthPx;
        int correctedHeight = heightPx;
        if (args.containsKey("position") && args.get("position") instanceof Map) {
            int temp;
            Map posArgs = (Map)args.get("position");
            if (posArgs.containsKey("width") && (temp = ((Integer)posArgs.get("width")).intValue()) > 0) {
                correctedWidth = DTBAdUtil.sizeToDevicePixels(temp);
            }
            if (posArgs.containsKey("height") && (temp = ((Integer)posArgs.get("height")).intValue()) > 0) {
                correctedHeight = DTBAdUtil.sizeToDevicePixels(temp);
            }
            if (posArgs.containsKey("useCustomClose")) {
                useCustomClose = (Boolean)posArgs.get("useCustomClose");
            }
        }
        int finalWidth = correctedWidth;
        boolean fUseCustomClose = useCustomClose;
        boolean finalPosX = false;
        BackgroundView backgroundView = new BackgroundView(this.getAdView().getContext());
        this.expandedBackground = backgroundView;
        backgroundView.setBackgroundColor(0);
        rootView.addView((View)backgroundView, -1, -1);
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(this.getAdView().getWidth(), this.getAdView().getHeight());
        params.leftMargin = this.startAnimation.xPos;
        params.topMargin = this.startAnimation.yPos;
        rootView.bringChildToFront((View)backgroundView);
        backgroundView.addView((View)this.getAdView(), (ViewGroup.LayoutParams)params);
        this.getAdView().setX(this.startAnimation.xPos);
        this.getAdView().setY(this.startAnimation.yPos);
        this.endAnimation = new AnimationPoint(0, 0, correctedWidth, correctedHeight);
        this.setCurrentPositionProperty(DTBAdUtil.pixelsToDeviceIndependenPixels(correctedWidth), DTBAdUtil.pixelsToDeviceIndependenPixels(correctedHeight));
        this.animater = ObjectAnimator.ofFloat((Object)this, (String)"animationProgress", (float[])new float[]{0.0f, 1.0f});
        this.animater.addUpdateListener(a -> {
            Float value = this.updateAdViewLayout(a);
            if (value.floatValue() == 1.0f) {
                this.addCloseIndicator(rootViewWidth, 0, fUseCustomClose);
                this.fireSizeChange(DTBAdUtil.pixelsToDeviceIndependenPixels(this.endAnimation.width), DTBAdUtil.pixelsToDeviceIndependenPixels(this.endAnimation.height));
                this.setState(MraidStateType.EXPANDED);
                this.commandCompleted("expand");
                this.animater = null;
                this.getAdView().computeExposure(true);
                this.getAdView().setScrollEnabled(true);
            }
        });
        this.animater.setDuration(500L);
        this.animater.start();
    }

    private Float updateAdViewLayout(ValueAnimator a) {
        Float value = (Float)a.getAnimatedValue();
        ViewGroup.LayoutParams layoutParams = this.getAdView().getLayoutParams();
        this.getAdView().setX((float)this.startAnimation.xPos + (float)(this.endAnimation.xPos - this.startAnimation.xPos) * value.floatValue());
        this.getAdView().setY((float)this.startAnimation.yPos + (float)(this.endAnimation.yPos - this.startAnimation.yPos) * value.floatValue());
        layoutParams.width = (int)((float)this.startAnimation.width + (float)(this.endAnimation.width - this.startAnimation.width) * value.floatValue());
        layoutParams.height = (int)((float)this.startAnimation.height + (float)(this.endAnimation.height - this.startAnimation.height) * value.floatValue());
        this.getAdView().setLayoutParams(layoutParams);
        this.getAdView().invalidate();
        return value;
    }

    private void updateResizedToDefaultListener(ViewGroup vg, boolean isUnloadRequired) {
        this.getAdView().setIgnoreDetachment();
        vg.removeView((View)this.getAdView());
        this.startAnimation = this.endAnimation;
        if (this.originalParams != null) {
            this.defaultParent.addView((View)this.getAdView(), this.originalParams);
            this.defaultParent.requestLayout();
        }
        this.getAdView().invalidate();
        this.setCurrentPositionProperty();
        this.defaultParent = null;
        this.fireSizeChange(DTBAdUtil.pixelsToDeviceIndependenPixels(this.endAnimation.width), DTBAdUtil.pixelsToDeviceIndependenPixels(this.endAnimation.height));
        this.setState(MraidStateType.DEFAULT);
        this.animater = null;
        this.commandCompleted("close");
        if (isUnloadRequired) {
            new Handler().postDelayed(() -> {
                this.getAdView().loadUrl("about:blank");
                this.commandCompleted("unload");
            }, 500L);
        }
        new Handler().postDelayed(() -> this.getAdView().computeExposure(true), 100L);
    }

    private void updateExpandedToDefaultListener(ViewGroup vg, boolean isUnloadRequired) {
        this.getAdView().setIgnoreDetachment();
        vg.removeView((View)this.getAdView());
        this.startAnimation = this.endAnimation;
        if (this.expandedBackground != null) {
            ViewGroup parent = (ViewGroup)this.expandedBackground.getParent();
            parent.removeView((View)this.expandedBackground);
            this.expandedBackground = null;
            this.fireSizeChange(DTBAdUtil.pixelsToDeviceIndependenPixels(this.startAnimation.width), DTBAdUtil.pixelsToDeviceIndependenPixels(this.startAnimation.height));
        }
        if (this.originalParams != null) {
            this.defaultParent.addView((View)this.getAdView(), this.originalParams);
            this.defaultParent.requestLayout();
        }
        this.setCurrentPositionProperty();
        this.setState(MraidStateType.DEFAULT);
        this.getAdView().setScrollEnabled(false);
        this.commandCompleted("close");
        this.defaultParent = null;
        this.animater = null;
        if (isUnloadRequired) {
            new Handler().postDelayed(() -> {
                this.getAdView().loadUrl("about:blank");
                this.commandCompleted("unload");
            }, 500L);
        }
        new Handler().postDelayed(() -> this.getAdView().computeExposure(true), 100L);
    }

    protected boolean onBackPressed() {
        return false;
    }

    void openExpanded() {
        this.setState(MraidStateType.EXPANDED);
    }

    static DTBAdMRAIDBannerController findControllerByIndex(int index) {
        for (WeakReference<DTBAdMRAIDBannerController> ref : bannerControllers) {
            DTBAdMRAIDBannerController cntrl = (DTBAdMRAIDBannerController)ref.get();
            if (cntrl == null || cntrl.index != index) continue;
            return cntrl;
        }
        return null;
    }

    @Override
    protected void closeExpandedPartTwo() {
        this.setState(MraidStateType.DEFAULT);
    }

    @Override
    public void useCustomButtonUpdated() {
        if (this.state == MraidStateType.EXPANDED && this.closeIndicatorRegion != null) {
            new Handler(Looper.getMainLooper()).post(() -> this.closeIndicatorRegion.setVisibility(this.useCustomClose ? 4 : 0));
        }
    }

    @Override
    public void onAdClicked() {
        DTBAdView view = this.adView;
        if (this.bannerListener != null) {
            new Handler(Looper.getMainLooper()).post(() -> this.lambda$onAdClicked$14((View)view));
        }
    }

    @Override
    public void onAdLeftApplication() {
        new Handler(Looper.getMainLooper()).post(() -> {
            this.bannerListener.onAdOpen((View)this.adView);
            this.bannerListener.onAdLeftApplication((View)this.adView);
        });
        ActivityMonitor.getInstance().setActivityListener(this);
    }

    @Override
    public void onAdLoaded() {
        if (this.bannerListener == null) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to get bannerListener on OnAdLoaded");
            return;
        }
        DtbThreadService.executeOnMainThread(() -> this.bannerListener.onAdLoaded((View)this.adView));
    }

    @Override
    public void onAdFailedToLoad() {
        if (this.bannerListener == null) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to get bannerListener on onAdFailedToLoad");
            return;
        }
        if (this.getDtbOmSdkSessionManager() != null) {
            this.getDtbOmSdkSessionManager().stopOmAdSession();
        }
        DtbThreadService.executeOnMainThread(() -> this.bannerListener.onAdFailed((View)this.adView));
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.bannerListener.onAdClosed((View)this.adView);
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        if (this.getDtbOmSdkSessionManager() != null) {
            this.getDtbOmSdkSessionManager().stopOmAdSession();
        }
        ActivityMonitor.getInstance().setActivityListener(null);
    }

    @Override
    public void onAdRemoved() {
        if (this.adView == null) {
            return;
        }
        super.onAdRemoved();
        this.removeCloseIndicator();
        if (this.animater != null) {
            this.animater.end();
        }
        if (!this.isVisibleRecyclerOrListView(this.adView.getParent())) {
            this.adView.setVisibility(8);
        }
        if (this.state == MraidStateType.RESIZED) {
            ViewParent parent = this.adView.getParent();
            if (parent instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)parent;
                vg.removeView((View)this.adView);
            }
        } else if (this.state == MraidStateType.EXPANDED && this.expandedBackground != null && this.expandedBackground.getParent() instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)this.expandedBackground.getParent();
            vg.removeView((View)this.expandedBackground);
        }
    }

    @Override
    void passLoadError() {
        DtbThreadService.executeOnMainThread(() -> this.bannerListener.onAdError((View)this.adView));
    }

    @Override
    public void impressionFired() {
        DtbThreadService.executeOnMainThread(() -> this.bannerListener.onImpressionFired((View)this.adView));
        super.impressionFired();
    }

    private boolean isVisibleRecyclerOrListView(ViewParent viewParent) {
        if (viewParent == null) {
            return false;
        }
        if (viewParent.toString().toLowerCase().contains("recyclerview") || viewParent.toString().toLowerCase().contains("listview")) {
            return true;
        }
        return this.isVisibleRecyclerOrListView(viewParent.getParent());
    }

    private /* synthetic */ void lambda$onAdClicked$14(View view) {
        this.bannerListener.onAdClicked(view);
    }

    static {
        bannerControllers = new ArrayList<WeakReference<DTBAdMRAIDBannerController>>();
        indexDispencer = new AtomicInteger(100);
    }

    class BackgroundView
    extends LinearLayout {
        BackgroundView(Context context) {
            super(context);
            this.setOrientation(1);
        }
    }

    class ExpandedBannerListener
    implements DTBAdExpandedListener {
        ExpandedBannerListener() {
        }

        @Override
        public void onAdLoaded(DTBAdView view) {
        }

        @Override
        public void onCreateExpandedController(DTBAdMRAIDExpandedController expandedController) {
            expandedController.setMasterController(DTBAdMRAIDBannerController.this);
        }
    }

    class AnimationPoint {
        int xPos;
        int yPos;
        int height;
        int width;

        AnimationPoint(int x, int y, int w, int h) {
            this.xPos = x;
            this.yPos = y;
            this.width = w;
            this.height = h;
        }
    }
}

