/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.amazon.device.ads.DTBAdActivity;
import com.amazon.device.ads.DTBAdMRAIDBannerController;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.MraidStateType;
import java.util.Map;
import org.json.JSONException;

public class DTBAdMRAIDExpandedController
extends DTBAdMRAIDController {
    static final String LOG_TAG = DTBAdMRAIDExpandedController.class.getSimpleName();
    private DTBAdMRAIDBannerController masterController;

    void setMasterController(DTBAdMRAIDBannerController masterController) {
        this.masterController = masterController;
    }

    DTBAdMRAIDExpandedController(DTBAdView adView) {
        super(adView);
    }

    @Override
    protected void onResize(Map<String, Object> args) {
        this.fireErrorEvent("resize", "Expanded View does not allow resize");
        this.commandCompleted("resize");
    }

    @Override
    protected void expand(Map<String, Object> args) {
        this.fireErrorEvent("expand", "Expanded View does not allow expand");
        this.commandCompleted("expand");
    }

    @Override
    protected MraidStateType getInitialStateType() {
        return MraidStateType.EXPANDED;
    }

    @Override
    public void onPageLoad() {
        try {
            this.prepareMraid();
            if (this.getDtbOmSdkSessionManager() != null) {
                this.getDtbOmSdkSessionManager().registerAdView(this.getAdView());
            }
        }
        catch (JSONException ex) {
            DtbLog.error("Error:" + ex.getMessage());
        }
    }

    void addCloseIndicator() {
        this.addCloseIndicator((v, event) -> {
            if (event.getAction() == 0) {
                this.closeExpandedPartTwo();
                return true;
            }
            return false;
        });
    }

    protected void layoutCloseIndicator() {
        ViewGroup rootView = DTBAdUtil.getRootView((View)this.getAdView());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(DTBAdUtil.sizeToDevicePixels(50), DTBAdUtil.sizeToDevicePixels(50));
        params.gravity = 8388661;
        params.topMargin = 0;
        params.rightMargin = 0;
        rootView.addView((View)this.closeIndicatorRegion, (ViewGroup.LayoutParams)params);
    }

    @SuppressLint(value={"ResourceType"})
    void addCloseIndicator(View.OnTouchListener onTouchListener) {
        this.createContentIndicator();
        this.layoutCloseIndicator();
        this.setCloseIndicatorContent(onTouchListener);
    }

    @Override
    protected void onMRAIDClose() {
        this.closeExpandedPartTwo();
    }

    @Override
    protected void closeExpandedPartTwo() {
        int index;
        DTBAdMRAIDBannerController bannerController;
        DTBAdActivity activity = (DTBAdActivity)DTBAdUtil.getActivity((View)this.getAdView());
        Intent intent = activity.getIntent();
        if (intent != null && (bannerController = DTBAdMRAIDBannerController.findControllerByIndex(index = intent.getIntExtra("cntrl_index", -1))) != null) {
            bannerController.closeExpandedPartTwo();
        }
        activity.straightFinish();
    }

    @Override
    public void onAdLeftApplication() {
    }

    @Override
    void passLoadError() {
        if (this.masterController != null) {
            this.masterController.passLoadError();
        }
    }
}

