/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.VisibleForTesting;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbPricePoint;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.SDKUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DTBAdResponse {
    private static final String LOG_TAG = DTBAdResponse.class.getSimpleName();
    private static final String AMAZON_AD_INFO = "{bidID:'%s',aaxHost:'%s',type:'%s',width:%d,height:%d,pricePoint:'%s'}";
    private String bidId;
    private boolean isVideo;
    private String hostName;
    private Map<String, List<String>> kvpDictionary = new HashMap<String, List<String>>();
    private Map<DTBAdSize, List<DtbPricePoint>> pricepoints = new HashMap<DTBAdSize, List<DtbPricePoint>>();
    private String impressionUrl;
    private String crid;
    protected Bundle renderingBundle;
    protected String extrasAsString;
    protected DTBAdRequest refreshLoader;
    private int videoSkipAfterDurationInSeconds;
    protected String videoInventoryType;

    public DTBAdResponse() {
    }

    public DTBAdResponse(DTBAdResponse dtbAdResponse) {
        this.bidId = dtbAdResponse.bidId;
        this.isVideo = dtbAdResponse.isVideo;
        this.hostName = dtbAdResponse.hostName;
        this.kvpDictionary = dtbAdResponse.kvpDictionary;
        this.pricepoints = dtbAdResponse.pricepoints;
        this.impressionUrl = dtbAdResponse.impressionUrl;
        this.crid = dtbAdResponse.crid;
        this.refreshLoader = dtbAdResponse.refreshLoader;
        this.videoSkipAfterDurationInSeconds = dtbAdResponse.videoSkipAfterDurationInSeconds;
        this.videoInventoryType = dtbAdResponse.videoInventoryType;
        this.renderingBundle = dtbAdResponse.renderingBundle;
        this.extrasAsString = dtbAdResponse.extrasAsString;
    }

    public DTBAdResponse(Bundle extraData) {
        this.renderingBundle = extraData;
    }

    public DTBAdResponse(String extrasAsString) {
        this.extrasAsString = extrasAsString;
    }

    public String getImpressionUrl() {
        return this.impressionUrl;
    }

    void setImpressionUrl(String url) {
        this.impressionUrl = url;
    }

    public String getCrid() {
        return this.crid;
    }

    void setCrid(String crid) {
        this.crid = crid;
    }

    void setBidId(String bidId) {
        this.bidId = bidId;
    }

    void setKvpDictionary(JSONObject kvpDictJson) throws JSONException {
        Iterator keys = kvpDictJson.keys();
        while (keys.hasNext()) {
            String targetingKey = (String)keys.next();
            JSONArray targetingValues = kvpDictJson.getJSONArray(targetingKey);
            if (targetingValues == null) continue;
            for (int i = 0; i < targetingValues.length(); ++i) {
                if (this.kvpDictionary.get(targetingKey) == null) {
                    this.kvpDictionary.put(targetingKey, new ArrayList());
                }
                this.kvpDictionary.get(targetingKey).add(targetingValues.getString(i));
            }
        }
    }

    void putPricePoint(DtbPricePoint pricepoint) {
        if (this.pricepoints.get(pricepoint.getAdSize()) == null) {
            this.pricepoints.put(pricepoint.getAdSize(), new ArrayList());
        }
        this.pricepoints.get(pricepoint.getAdSize()).add(pricepoint);
    }

    void setVideoSkipAfterDurationInSeconds(int skipAfter) {
        this.videoSkipAfterDurationInSeconds = skipAfter;
    }

    public Integer getVideoSkipAfterDurationInSeconds() {
        return this.videoSkipAfterDurationInSeconds;
    }

    void setVideoInventoryType(String inventoryType) {
        this.videoInventoryType = inventoryType;
    }

    String getVideoInventoryType() {
        return this.videoInventoryType;
    }

    @VisibleForTesting
    public String getBidId() {
        return this.bidId;
    }

    private String getBidKey() {
        if (!this.isVideo) {
            return "amzn_b";
        }
        return "amzn_vid";
    }

    public Map<String, List<String>> getDefaultDisplayAdsRequestCustomParams() {
        HashMap<String, List<String>> custParams = new HashMap<String, List<String>>();
        try {
            if (!this.isVideo) {
                if (this.pricepoints.size() > 0) {
                    custParams.put("amzn_b", Collections.singletonList(this.bidId));
                    custParams.put(this.getBidKey(), Collections.singletonList(this.bidId));
                    custParams.put("amzn_h", Collections.singletonList(DtbSharedPreferences.getInstance().getAaxHostname()));
                    DTBAdSize dtbAdSize = this.getDTBAds().get(0);
                    for (DtbPricePoint p : this.pricepoints.get(dtbAdSize)) {
                        custParams.put("amznslots", Collections.singletonList(p.getPricePoint()));
                    }
                }
                custParams.put("isv", Collections.singletonList(String.valueOf(this.isVideo)));
                custParams.putAll(this.getKvpDictionary());
                if (!DtbCommonUtils.isNullOrEmpty(AdRegistration.getAppKey())) {
                    custParams.put("appkey", Collections.singletonList(AdRegistration.getAppKey()));
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getDefaultDisplayAdsRequestCustomParams method", e);
        }
        return custParams;
    }

    Map<String, List<String>> getKvpDictionary() {
        return this.kvpDictionary;
    }

    public Map<String, String> getDefaultVideoAdsRequestCustomParams() {
        HashMap<String, String> custParams = new HashMap<String, String>();
        try {
            if (this.isVideo) {
                custParams.put("amzn_vid", this.bidId);
                custParams.put("amzn_h", this.hostName);
                DTBAdSize dtbAdSize = this.getDTBAds().get(0);
                for (DtbPricePoint dtbPricePoint : this.pricepoints.get(dtbAdSize)) {
                    custParams.put("amznslots", dtbPricePoint.getPricePoint());
                }
                for (Map.Entry entry : this.kvpDictionary.entrySet()) {
                    String joined = TextUtils.join((CharSequence)", ", (Iterable)((Iterable)entry.getValue()));
                    custParams.put((String)entry.getKey(), joined);
                }
                custParams.put("isv", String.valueOf(this.isVideo));
                custParams.put("skipafter", String.valueOf(this.getVideoSkipAfterDurationInSeconds()));
                custParams.put("vtype", this.getVideoInventoryType());
                if (!DtbCommonUtils.isNullOrEmpty(AdRegistration.getAppKey())) {
                    custParams.put("appkey", AdRegistration.getAppKey());
                }
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getDefaultVideoAdsRequestCustomParams method", e);
        }
        return custParams;
    }

    Map<String, List<String>> getVideoAdsRequestCustomParamsAsList() {
        HashMap<String, List<String>> custParams = new HashMap<String, List<String>>();
        if (this.isVideo) {
            custParams.put("amzn_vid", Collections.singletonList(this.bidId));
            custParams.put("amzn_h", Collections.singletonList(this.hostName));
            DTBAdSize dtbAdSize = this.getDTBAds().get(0);
            for (DtbPricePoint p : this.pricepoints.get(dtbAdSize)) {
                custParams.put("amznslots", Collections.singletonList(p.getPricePoint()));
            }
            custParams.put("isv", Collections.singletonList(String.valueOf(this.isVideo)));
            custParams.put("skipafter", Collections.singletonList(String.valueOf(this.getVideoSkipAfterDurationInSeconds())));
            custParams.put("vtype", Collections.singletonList(this.getVideoInventoryType()));
            if (!DtbCommonUtils.isNullOrEmpty(AdRegistration.getAppKey())) {
                custParams.put("appkey", Collections.singletonList(AdRegistration.getAppKey()));
            }
            custParams.putAll(this.getKvpDictionary());
        }
        return custParams;
    }

    public int getAdCount() {
        return this.pricepoints.size();
    }

    public List<DTBAdSize> getDTBAds() {
        return new ArrayList<DTBAdSize>(this.pricepoints.keySet());
    }

    public String getPricePoints(DTBAdSize adSize) {
        try {
            List<DtbPricePoint> pp = this.pricepoints.get(adSize);
            if (pp != null && !pp.isEmpty()) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < pp.size(); ++i) {
                    str.append(pp.get(i).getPricePoint());
                    if (i == pp.size() - 1) continue;
                    str.append(",");
                }
                return str.toString();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getPricePoints method", e);
        }
        return null;
    }

    @Deprecated
    public String getHost() {
        try {
            DtbSharedPreferences sharedPreferences = DtbSharedPreferences.getInstance();
            return sharedPreferences.getAaxHostname();
        }
        catch (IllegalArgumentException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getPricePoints method", e);
            return null;
        }
    }

    @VisibleForTesting
    public String getDefaultPricePoints() {
        try {
            if (this.getAdCount() == 0) {
                return null;
            }
            DTBAdSize dtbAdSize = this.getDTBAds().get(0);
            return this.getPricePoints(dtbAdSize);
        }
        catch (IllegalArgumentException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute getDefaultPricePoints method", e);
            return null;
        }
    }

    protected boolean isVideo() {
        return this.isVideo;
    }

    protected void setVideo(boolean video) {
        this.isVideo = video;
    }

    @Deprecated
    public String getMoPubKeywords() {
        try {
            DtbLog.debug(LOG_TAG, "API 'getMoPubKeywords' supports banner & video Ads.");
            StringBuilder builder = new StringBuilder();
            Map<String, List<String>> kvpDict = null;
            kvpDict = !this.isVideo ? this.getDefaultDisplayAdsRequestCustomParams() : this.getVideoAdsRequestCustomParamsAsList();
            if (this.pricepoints.size() > 0) {
                boolean isFirst = true;
                for (Map.Entry<String, List<String>> entry : kvpDict.entrySet()) {
                    for (String value : entry.getValue()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            builder.append(",");
                        }
                        builder.append(entry.getKey()).append(":").append(value);
                    }
                }
            }
            return builder.toString();
        }
        catch (IllegalArgumentException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getMoPubKeywords method", e);
            return "";
        }
    }

    @Deprecated
    public String getMoPubServerlessKeywords() {
        try {
            List<String> values;
            String KEY = "amznslots";
            StringBuilder builder = new StringBuilder();
            Map<String, List<String>> kvpDict = this.getDefaultDisplayAdsRequestCustomParams();
            if (this.pricepoints.size() > 0 && kvpDict.containsKey("amznslots") && (values = kvpDict.get("amznslots")).size() > 0) {
                builder.append("amznslots").append(":").append(values.get(0));
            }
            return builder.toString();
        }
        catch (IllegalArgumentException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getMoPubServerlessKeywords method", e);
            return "";
        }
    }

    private String getAmazonInfo() {
        if (this.getDTBAds().size() == 0) {
            return "";
        }
        DTBAdSize dtbAdSize = this.getDTBAds().get(0);
        String type = "";
        int width = dtbAdSize.getWidth();
        int height = dtbAdSize.getHeight();
        switch (dtbAdSize.getDTBAdType()) {
            case VIDEO: {
                type = "video";
                break;
            }
            case DISPLAY: {
                type = "banner";
                break;
            }
            case INTERSTITIAL: {
                type = "interstitial";
                Activity activity = AdRegistration.getCurrentActivity();
                if (activity == null) break;
                WindowManager wm = (WindowManager)activity.getSystemService("window");
                Display display = wm.getDefaultDisplay();
                DisplayMetrics metrics = new DisplayMetrics();
                display.getMetrics(metrics);
                width = DTBAdUtil.pixelsToDeviceIndependenPixels(metrics.widthPixels);
                height = DTBAdUtil.pixelsToDeviceIndependenPixels(metrics.heightPixels);
            }
        }
        String host = this.hostName != null ? this.hostName : DtbDebugProperties.getAaxHostName(DtbSharedPreferences.getInstance().getAaxHostname());
        String pricePoint = SDKUtilities.getPricePoint(this);
        return String.format(AMAZON_AD_INFO, this.bidId, host, type, width, height, pricePoint);
    }

    void setHostName(String host) {
        this.hostName = host;
    }

    public HashMap<String, Object> getRenderingMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String bidHtml = SDKUtilities.getBidInfo(this);
            map.put("bid_html_template", bidHtml);
            map.put("event_server_parameter", SDKUtilities.getPricePoint(this));
            map.put("amazon_ad_info", this.getAmazonInfo());
            map.put("bid_identifier", this.bidId);
            map.put("hostname_identifier", this.hostName);
            map.put("start_load_time", new Date().getTime());
        }
        catch (IllegalArgumentException e) {
            DtbLog.debug(LOG_TAG, "Fail to execute getRenderingMap method");
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getRenderingMap method", e);
        }
        return map;
    }

    public Bundle getRenderingBundle() {
        return this.renderingBundle != null ? this.renderingBundle : this.getRenderingBundle(false);
    }

    public Bundle getRenderingBundle(String fetchManagerLabel) {
        return this.getRenderingBundle(false, fetchManagerLabel);
    }

    public Bundle getRenderingBundle(boolean isSmartBanner) {
        return this.getRenderingBundle(isSmartBanner, null);
    }

    public Bundle getRenderingBundle(boolean isSmartBanner, String fetchManagerLabel) {
        Bundle bundle = DtbCommonUtils.initializeEmptyBundle();
        try {
            String bidHtml = SDKUtilities.getBidInfo(this);
            bundle.putString("bid_html_template", bidHtml);
            bundle.putString("bid_identifier", this.bidId);
            bundle.putString("hostname_identifier", this.hostName);
            bundle.putBoolean("video_flag", this.isVideo);
            bundle.putString("event_server_parameter", SDKUtilities.getPricePoint(this));
            bundle.putString("amazon_ad_info", this.getAmazonInfo());
            bundle.putLong("start_load_time", new Date().getTime());
            if (isSmartBanner) {
                bundle.putInt("expected_width", SDKUtilities.getWidth(this));
                bundle.putInt("expected_height", SDKUtilities.getHeight(this));
            }
            if (!DtbCommonUtils.isNullOrEmpty(fetchManagerLabel)) {
                bundle.putString("amazon_request_queue", fetchManagerLabel);
            }
        }
        catch (IllegalArgumentException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute getRenderingBundle method", e);
        }
        return bundle;
    }

    public DTBAdRequest getAdLoader() {
        return this.refreshLoader;
    }

    void setAdLoader(DTBAdRequest adLoader) {
        this.refreshLoader = adLoader;
    }
}

