/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.ads.model.ApsSlotInfoExtra;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DtbCommonUtils;
import org.json.JSONObject;

public class DTBAdSize {
    public static final String AAX_INTERSTITIAL_AD_SIZE = "interstitial";
    private final int width;
    private final int height;
    private final AdType adType;
    private final String slotUUID;
    private JSONObject pubSettings;
    private ApsSlotInfoExtra slotInfoExtra;

    public DTBAdSize(int width, int height, String slotUUID) {
        this(width, height, AdType.DISPLAY, slotUUID, null);
        if (width == 9999 || height == 9999) {
            throw new IllegalArgumentException("Invalid size passed, Please use DTBInterstitialAdSize for interstitial ads.");
        }
    }

    protected DTBAdSize(int width, int height, AdType adType, String slotUUID, JSONObject pubSettings) {
        if (width < 0 || height < 0 || DtbCommonUtils.isNullOrEmpty(slotUUID)) {
            throw new IllegalArgumentException("Invalid parameter(s) passed to DTBAdSize constructor.");
        }
        this.width = width;
        this.height = height;
        this.adType = adType;
        this.slotUUID = slotUUID;
        this.pubSettings = pubSettings;
    }

    protected DTBAdSize(int width, int height, AdType adType, String slotUUID) {
        this(width, height, adType, slotUUID, null);
        if (width < 0 || height < 0 || DtbCommonUtils.isNullOrEmpty(slotUUID)) {
            throw new IllegalArgumentException("Invalid parameter(s) passed to DTBAdSize constructor.");
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isInterstitialAd() {
        return this.adType.equals((Object)AdType.INTERSTITIAL);
    }

    public AdType getDTBAdType() {
        return this.adType;
    }

    public String getSlotUUID() {
        return this.slotUUID;
    }

    public JSONObject getPubSettings() {
        return this.pubSettings;
    }

    public void setPubSettings(JSONObject pubSettings) {
        this.pubSettings = pubSettings;
    }

    public ApsSlotInfoExtra getSlotInfoExtra() {
        return this.slotInfoExtra;
    }

    public void setSlotInfoExtra(ApsSlotInfoExtra slotInfoExtra) {
        this.slotInfoExtra = slotInfoExtra;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DTBAdSize other = (DTBAdSize)obj;
        if (this.height != other.height) {
            return false;
        }
        return this.width == other.width;
    }

    public String toString() {
        return "DTBAdSize [" + this.width + "x" + this.height + ", adType=" + (Object)((Object)this.adType) + ", slotUUID=" + this.slotUUID + "]";
    }

    public static final class DTBVideo
    extends DTBAdSize {
        public DTBVideo(int playerWidth, int playerHeight, String slotUUID) {
            super(playerWidth, playerHeight, AdType.VIDEO, slotUUID, null);
        }

        public DTBVideo(int playerWidth, int playerHeight, String slotUUID, JSONObject pubSettings) {
            super(playerWidth, playerHeight, AdType.VIDEO, slotUUID, pubSettings);
        }
    }

    public static final class DTBInterstitialAdSize
    extends DTBAdSize {
        public DTBInterstitialAdSize(String slotUUID) {
            super(9999, 9999, AdType.INTERSTITIAL, slotUUID, null);
        }
    }
}

