/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.appcompat.content.res.AppCompatResources;
import com.amazon.aps.ads.R;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdInterstitial;
import com.amazon.device.ads.DTBAdMRAIDController;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBMRAIDCloseButtonListener;
import com.amazon.device.ads.DtbLog;
import com.iab.omid.library.amazon.adsession.FriendlyObstructionPurpose;
import java.lang.ref.WeakReference;

public class DTBInterstitialActivity
extends Activity
implements DTBMRAIDCloseButtonListener {
    private static final String LOG_TAG = DTBInterstitialActivity.class.getSimpleName();
    DTBAdInterstitial interstitial;
    WeakReference<DTBAdView> adView;
    private int dtbAdInterstitialID;

    DTBAdView getAdView() {
        if (this.adView != null) {
            return (DTBAdView)this.adView.get();
        }
        return null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
            this.setContentView(R.layout.mdtb_interstitial_ad);
            if (this.getIntent() != null) {
                this.dtbAdInterstitialID = this.getIntent().getIntExtra("INTERSTITIAL_CACHE_KEY", 0);
                this.interstitial = DTBAdInterstitial.getFromCache(this.dtbAdInterstitialID);
            }
            if (this.interstitial == null) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "DTBInterstitialActivity is invoked with the cache data null");
                this.finish();
                return;
            }
            RelativeLayout rl = (RelativeLayout)this.findViewById(R.id.inter_container);
            this.adView = new WeakReference<DTBAdView>(this.interstitial.getAdView());
            this.getAdView().setScrollEnabled(false);
            ViewParent obj = this.getAdView().getParent();
            if (obj != null && obj instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)obj;
                vg.removeView((View)this.getAdView());
            }
            LinearLayout closeIndicatorRegion = (LinearLayout)this.findViewById(R.id.mraid_close_indicator);
            rl.addView((View)this.getAdView(), -1, -1);
            DTBAdMRAIDController controller = this.getAdView().getController();
            controller.setCustomButtonListener(this);
            if (controller.getDtbOmSdkSessionManager() != null) {
                controller.getDtbOmSdkSessionManager().addFriendlyObstruction(closeIndicatorRegion.findViewById(R.id.mraid_close_indicator), FriendlyObstructionPurpose.CLOSE_AD);
            }
            closeIndicatorRegion.setVisibility(this.getUseCustomClose() ? 4 : 0);
            closeIndicatorRegion.bringToFront();
            closeIndicatorRegion.setBackgroundColor(0);
            closeIndicatorRegion.setOrientation(1);
            ImageView iv = new ImageView(this.getAdView().getContext());
            LinearLayout.LayoutParams imageParams = new LinearLayout.LayoutParams(DTBAdUtil.sizeToDevicePixels(24), DTBAdUtil.sizeToDevicePixels(24));
            imageParams.setMargins(DTBAdUtil.sizeToDevicePixels(14), DTBAdUtil.sizeToDevicePixels(14), 0, 0);
            Drawable drawable2 = AppCompatResources.getDrawable((Context)this, (int)R.drawable.mraid_close);
            iv.setImageDrawable(drawable2);
            closeIndicatorRegion.addView((View)iv, (ViewGroup.LayoutParams)imageParams);
            closeIndicatorRegion.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        DTBInterstitialActivity.this.cleanAndFinishAdView(DTBInterstitialActivity.this.getAdView());
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to create DTBInterstitial Activity", e);
            this.finish();
        }
    }

    protected boolean getUseCustomClose() {
        if (!this.isViewAndControllerNotNull(this.getAdView())) {
            DtbLog.info(LOG_TAG, "Failed to get use custom close , due to " + this.interstitial == null ? "null DTBInterstitial instance" : "null AdView/Controller instance");
            return false;
        }
        DTBAdMRAIDController controller = this.getAdView().getController();
        return controller.useCustomClose;
    }

    protected void onDestroy() {
        try {
            RelativeLayout rl = (RelativeLayout)this.findViewById(R.id.inter_container);
            if (rl != null) {
                rl.removeView((View)this.getAdView());
            }
            if (this.getAdView() != null) {
                this.getAdView().evaluateJavascript("window.mraid.close();", null);
                this.cleanup();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to remove DTBAdView on Activity Destroy", e);
        }
        super.onDestroy();
    }

    public void onBackPressed() {
        try {
            if (!this.getUseCustomClose()) {
                this.cleanAndFinishAdView(this.getAdView());
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute onBackPressed method", e);
        }
    }

    void cleanup() {
        DTBAdInterstitial.removeFromCache(this.dtbAdInterstitialID);
        if (this.adView != null) {
            this.adView.clear();
            this.adView = null;
        }
    }

    @Override
    public void useCustomButtonUpdated() {
        new Handler(Looper.getMainLooper()).post(() -> this.findViewById(R.id.mraid_close_indicator).setVisibility(this.getUseCustomClose() ? 4 : 0));
        try {
            if (!this.getUseCustomClose()) {
                this.getAdView().getController().getDtbOmSdkSessionManager().addFriendlyObstruction(this.findViewById(R.id.mraid_close_indicator), FriendlyObstructionPurpose.CLOSE_AD);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, " OMSDK : Unable to add close icon as friendly obstruction on geometry change", e);
        }
    }

    boolean isViewAndControllerNotNull(DTBAdView dtbAdView) {
        return dtbAdView != null && dtbAdView.getController() != null;
    }

    void cleanAndFinishAdView(DTBAdView dtbAdView) {
        if (this.isViewAndControllerNotNull(dtbAdView)) {
            dtbAdView.evaluateJavascript("window.mraid.close();", null);
            this.cleanup();
            this.finish();
        }
    }
}

