/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.view.Display;
import android.view.WindowManager;
import com.amazon.device.ads.AdRegistration;

class DisplayUtils {
    private static final int[][] rotationArray = new int[][]{{1, 0, 9, 8}, {0, 9, 8, 1}};

    DisplayUtils() {
    }

    public static int determineCanonicalScreenOrientation() {
        Context context = AdRegistration.getContext();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int rotation = display.getRotation();
        int orientation = context.getResources().getConfiguration().orientation;
        boolean naturalOrientationIsPortrait = false;
        naturalOrientationIsPortrait = orientation == 1 ? rotation == 0 || rotation == 2 : (orientation == 2 ? rotation == 1 || rotation == 3 : true);
        int rotationSelector = naturalOrientationIsPortrait ? 0 : 1;
        return rotationArray[rotationSelector][rotation];
    }

    static int determineSimpleOrientation() {
        Context context = AdRegistration.getContext();
        int orientation = context.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            return 1;
        }
        if (orientation == 2) {
            return 2;
        }
        return 0;
    }

    static boolean isRotationLocked() {
        boolean isOrientationEnabled;
        Context context = AdRegistration.getContext();
        try {
            isOrientationEnabled = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"accelerometer_rotation") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            isOrientationEnabled = false;
        }
        return !isOrientationEnabled;
    }
}

