/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.browser.customtabs.CustomTabsClient;
import com.amazon.aps.ads.model.ApsSlotInfoExtra;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DTBAdNetwork;
import com.amazon.device.ads.DTBAdNetworkInfo;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDeviceData;
import com.amazon.device.ads.DtbGeoLocation;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbPackageNativeData;
import com.amazon.device.ads.DtbSharedPreferences;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DtbAdRequestParamsBuilder {
    private final String LOG_TAG = DtbAdRequestParamsBuilder.class.getSimpleName();
    private DTBAdNetworkInfo adNetworkInfo;

    DtbAdRequestParamsBuilder(@NonNull DTBAdNetworkInfo adNetworkInfo) {
        this.adNetworkInfo = adNetworkInfo != null ? adNetworkInfo : new DTBAdNetworkInfo(DTBAdNetwork.UNKNOWN);
    }

    public HashMap<String, Object> getParams(Context context, List<DTBAdSize> adSizes, Map<String, String> customTargets, boolean refreshFlag) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.getCommonParams(context));
        params.putAll(this.getSlotParams(adSizes));
        params.putAll(this.getCustomParams(customTargets));
        params.putAll(this.getCustomAttributeParams(refreshFlag, context));
        return params;
    }

    HashMap<String, Object> getCommonParams(Context context) {
        DtbGeoLocation adLocation;
        String geoLocationString;
        String ua;
        JSONObject deviceData;
        Boolean optOut;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isDTBMobile", "true");
        params.put("appId", AdRegistration.getAppKey());
        params.put("adsdk", DtbCommonUtils.getSDKVersion());
        String idfa = DtbSharedPreferences.getInstance().getIdfa();
        if (!DtbCommonUtils.isNullOrEmpty(idfa)) {
            params.put("idfa", idfa);
        }
        if ((optOut = DtbSharedPreferences.getInstance().getOptOut()) != null) {
            params.put("oo", Boolean.toString(optOut));
        }
        if ((deviceData = DtbDeviceData.getDeviceDataInstance().getParamsJson()) != null) {
            params.put("dinfo", deviceData);
        }
        if ((ua = DtbDeviceData.getDeviceDataInstance().getUserAgentString()) != null) {
            params.put("ua", ua);
        }
        JSONObject packageNativeData = DtbPackageNativeData.getPackageNativeDataInstance(context).getParamsJson();
        params.put("pkg", packageNativeData);
        String adId = DtbSharedPreferences.getInstance().getAdId();
        if (adId != null) {
            params.put("ad-id", adId);
        }
        if (AdRegistration.isTestMode()) {
            params.put("isTest", "true");
        }
        if (AdRegistration.isLocationEnabled() && !DtbCommonUtils.isNullOrEmpty(geoLocationString = (adLocation = new DtbGeoLocation()).getLocationParam())) {
            params.put("geoloc", geoLocationString);
        }
        return params;
    }

    private HashMap<String, Object> getSlotParams(List<DTBAdSize> adSizes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONArray arrJson = new JSONArray();
        int count = 1;
        try {
            for (DTBAdSize adSize : adSizes) {
                JSONObject m_json = new JSONObject();
                if (adSize.isInterstitialAd()) {
                    m_json.put("sz", (Object)"interstitial");
                } else {
                    m_json.put("sz", (Object)(adSize.getWidth() + "x" + adSize.getHeight()));
                }
                m_json.put("slot", (Object)adSize.getSlotUUID());
                m_json.put("slotId", count++);
                JSONArray smt = new JSONArray();
                switch (adSize.getDTBAdType()) {
                    case VIDEO: {
                        smt.put((Object)AdType.VIDEO.toString());
                        break;
                    }
                    default: {
                        smt.put((Object)AdType.DISPLAY.toString());
                    }
                }
                m_json.put("supportedMediaTypes", (Object)smt);
                if (adSize.getPubSettings() != null) {
                    m_json.put("ps", (Object)adSize.getPubSettings());
                }
                if (adSize.getSlotInfoExtra() != null) {
                    JSONObject videoJson;
                    if (adSize.getSlotInfoExtra().getPos() != ApsSlotInfoExtra.PosOption.NO_VALUE) {
                        m_json.put("pos", adSize.getSlotInfoExtra().getPos().getValue());
                    }
                    if ((videoJson = adSize.getSlotInfoExtra().getVideoSlotExtraJSON()) != null) {
                        m_json.put("video", (Object)videoJson);
                    }
                }
                arrJson.put((Object)m_json);
            }
            params.put("slots", arrJson);
        }
        catch (JSONException e) {
            DtbLog.warn(this.LOG_TAG, "Error constructing slot parameters");
        }
        return params;
    }

    private HashMap<String, Object> getCustomParams(Map<String, String> customTargets) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (customTargets != null) {
            for (String key : customTargets.keySet()) {
                String value = customTargets.get(key);
                params.put(key, value);
            }
        }
        return params;
    }

    void addOmidPartnerNameAndPartnerVersionToBidRequest() {
        if (AdRegistration.getCustomDictionary() == null) {
            DtbLog.info(this.LOG_TAG, "Custom Dictionary Not found");
            return;
        }
        try {
            if (!DtbCommonUtils.isNullOrEmpty(this.adNetworkInfo.getAdNetworkName()) && DTBAdNetwork.valueOf(this.adNetworkInfo.getAdNetworkName()).isMediation()) {
                AdRegistration.addCustomAttribute("omidPartnerName", DTBMetricsConfiguration.getClientConfigVal("partner_name", "Amazon1", "om_sdk_feature"));
                AdRegistration.addCustomAttribute("omidPartnerVersion", DtbCommonUtils.getSDKVersion());
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to set OM SDK Partner Name and Version in Bid Request", e);
        }
    }

    HashMap<String, Object> getCustomAttributeParams(boolean refreshFlag, Context context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject pjTemplate = DtbSharedPreferences.getInstance().getPJTemplate();
        JSONObject pjJson = new JSONObject();
        this.addOmidPartnerNameAndPartnerVersionToBidRequest();
        this.addCurrentEnvironmentToCustomAtt();
        AdRegistration.addCustomAttribute("autoRefresh", String.valueOf(refreshFlag));
        this.addInAppNativeBrowserToCustomAtt(context);
        Iterator pjKeys = pjTemplate.keys();
        try {
            while (pjKeys.hasNext()) {
                String pjKey = (String)pjKeys.next();
                if (pjTemplate.get(pjKey) instanceof String) {
                    String configDictKey = pjTemplate.getString(pjKey);
                    String customVal = AdRegistration.getCustomDictionary().get(configDictKey);
                    if (DtbCommonUtils.isNullOrEmpty(customVal)) continue;
                    pjJson.put(pjKey, (Object)customVal);
                    continue;
                }
                if (!(pjTemplate.get(pjKey) instanceof JSONObject)) continue;
                JSONObject nestedJsonTemplate = pjTemplate.getJSONObject(pjKey);
                JSONObject nestedJson = new JSONObject();
                Iterator nestedPJKeys = nestedJsonTemplate.keys();
                while (nestedPJKeys.hasNext()) {
                    String nestedPJKey = (String)nestedPJKeys.next();
                    if (!(nestedJsonTemplate.get(nestedPJKey) instanceof String)) continue;
                    String configDictKey = nestedJsonTemplate.getString(nestedPJKey);
                    String customVal = AdRegistration.getCustomDictionary().get(configDictKey);
                    if (DtbCommonUtils.isNullOrEmpty(customVal)) continue;
                    nestedJson.put(nestedPJKey, (Object)customVal);
                }
                if (nestedJson.length() <= 0) continue;
                pjJson.put(pjKey, (Object)nestedJson);
            }
            if (!DtbCommonUtils.isNullOrEmpty(this.adNetworkInfo.getAdNetworkName())) {
                pjJson.put("mediationName", (Object)this.adNetworkInfo.getAdNetworkName());
            }
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error when constructing custom attribute parameters", e);
        }
        if (pjJson.length() > 0) {
            params.put("pj", pjJson);
        }
        return params;
    }

    void addCurrentEnvironmentToCustomAtt() {
        Map<Object, Object> customDictionary = new HashMap();
        if (AdRegistration.getCustomDictionary() != null) {
            customDictionary = AdRegistration.getCustomDictionary();
        }
        if (!customDictionary.containsKey("framework")) {
            String framework = DtbCommonUtils.getSDKFramework();
            AdRegistration.addCustomAttribute("framework", framework);
        }
    }

    void addInAppNativeBrowserToCustomAtt(Context context) {
        boolean featureEnabled = DTBMetricsConfiguration.getInstance().isFeatureEnabled("custom_tab_feature_enabled_flag", true);
        if (featureEnabled) {
            try {
                if (Build.VERSION.SDK_INT >= 31 && DtbCommonUtils.isClassAvailable("androidx.browser.customtabs.CustomTabsClient") && CustomTabsClient.getPackageName((Context)context, Collections.emptyList()) != null) {
                    AdRegistration.addCustomAttribute("inAppNativeBrowser", Boolean.TRUE.toString());
                }
            }
            catch (Exception e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to set inAppNativeBrowser in Bid Request", e);
            }
        }
    }
}

