/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.webkit.WebSettings;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDeviceDataRetriever;
import com.amazon.device.ads.DtbLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class DtbDeviceData {
    private static final String LOG_TAG = DtbDeviceData.class.getSimpleName();
    private static DtbDeviceData deviceDataInstance = null;
    private static final String DEFAULT_USER_AGENT = "Android";
    public static final String DEVICE_DATA_OS_VERSION_KEY = "osVersion";
    public static final String DEVICE_DATA_MODEL_KEY = "model";
    public static final String DEVICE_DATA_SCREEN_SIZE_KEY = "screenSize";
    public static final String DEVICE_DATA_ORIENTATION_KEY = "orientation";
    static final String DEVICE_DATA_OS_KEY = "os";
    static final String DEVICE_DATA_MAKE_KEY = "make";
    static final String DEVICE_DATA_HWV_KEY = "hwv";
    static final String DEVICE_DATA_COUNTRY_KEY = "country";
    static final String DEVICE_DATA_CARRIER_KEY = "carrier";
    static final String DEVICE_DATA_LANGUAGE_KEY = "language";
    static final String DEVICE_DATA_SCALING_FACTOR_KEY = "scalingFactor";
    static final String DEVICE_DATA_PPI_KEY = "ppi";
    static final String DEVICE_DATA_CONNECTION_TYPE_KEY = "connectionType";
    private boolean bad_serial = false;
    private boolean bad_udid = false;
    private boolean bad_mac = false;
    private String sha1_mac = null;
    private String sha1_udid = null;
    private String sha1_serial = null;
    private String ua = null;
    private String screenSize = null;
    private String orientation = null;
    private HashMap<String, Object> deviceParams = new HashMap();
    private JSONObject deviceInfoJson = new JSONObject();

    public static DtbDeviceData getDeviceDataInstance() {
        if (AdRegistration.getContext() == null) {
            DtbLog.debugError("unable to initialize advertising info without setting app context");
            throw new IllegalArgumentException("unable to initialize advertising info without setting app context");
        }
        if (deviceDataInstance == null) {
            if (AdRegistration.getContext() == null) {
                DtbLog.debugError("Invalid intialization of Device Data. Context is null");
                throw new IllegalArgumentException("Invalid intialization of Device Data. Context is null");
            }
            deviceDataInstance = new DtbDeviceData(AdRegistration.getContext());
        }
        return deviceDataInstance;
    }

    public JSONObject getParamsJson() {
        try {
            this.getOrientation();
            this.placeProperty(this.orientation, DEVICE_DATA_ORIENTATION_KEY);
            this.getScreenSize();
            this.placeProperty(this.screenSize, DEVICE_DATA_SCREEN_SIZE_KEY);
        }
        catch (Exception e) {
            DtbLog.error("Error:" + e);
        }
        return this.deviceInfoJson;
    }

    public JSONObject getParamsJsonGetSafe() {
        JSONObject reply = new JSONObject();
        Iterator iter = this.deviceInfoJson.keys();
        while (iter.hasNext()) {
            try {
                String key = (String)iter.next();
                Object value = this.deviceInfoJson.get(key);
                if (!(value instanceof String)) continue;
                reply.put(key, (Object)URLEncoder.encode((String)value, "UTF-8"));
            }
            catch (Exception e) {
                DtbLog.error("Error converting to JsonGetSafe");
                break;
            }
        }
        return reply;
    }

    public HashMap<String, Object> getDeviceParams() {
        if (!this.deviceParams.containsKey("ua") || this.deviceParams.containsKey("ua") && this.deviceParams.get("ua").equals(DEFAULT_USER_AGENT)) {
            this.getUserAgent();
            this.buildDeviceParams();
        }
        return this.deviceParams;
    }

    private DtbDeviceData(Context context) {
        this.getOrientation();
        this.getScreenSize();
        this.getDeviceInfoJson();
        this.getUserAgent();
        this.buildDeviceParams();
    }

    private void buildDeviceParams() {
        this.deviceParams.put("dt", "android");
        this.deviceParams.put("app", "app");
        this.deviceParams.put("aud", "3p");
        if (this.ua != null) {
            this.deviceParams.put("ua", this.ua);
        }
        this.deviceParams.put("sdkVer", DtbCommonUtils.getSDKVersion());
        if (this.deviceInfoJson != null) {
            this.deviceParams.put("dinfo", this.deviceInfoJson);
        }
    }

    private void getDeviceInfoJson() {
        float sF;
        String carrier;
        String os = DEFAULT_USER_AGENT;
        String model = Build.MODEL;
        String make = Build.MANUFACTURER;
        String osVersion = Build.VERSION.RELEASE;
        String hardware = Build.DEVICE;
        String country = Locale.getDefault().getCountry();
        String language = Locale.getDefault().getLanguage();
        String connectionType = DtbDeviceData.getConnectionType();
        int ppi = this.getScreenPpi();
        TelephonyManager tManager = (TelephonyManager)AdRegistration.getContext().getSystemService("phone");
        String string = carrier = tManager != null ? tManager.getNetworkOperatorName() : null;
        if (make.equals("motorola") && model.equals("MB502")) {
            sF = 1.0f;
        } else {
            DisplayMetrics metrics = this.getDisplayMetrics();
            sF = metrics.scaledDensity;
        }
        String scalingFactor = Float.toString(sF);
        try {
            this.placeProperty(os, DEVICE_DATA_OS_KEY);
            this.placeProperty(model, DEVICE_DATA_MODEL_KEY);
            this.placeProperty(make, DEVICE_DATA_MAKE_KEY);
            this.placeProperty(hardware, DEVICE_DATA_HWV_KEY);
            this.placeProperty(osVersion, DEVICE_DATA_OS_VERSION_KEY);
            this.placeProperty(country, DEVICE_DATA_COUNTRY_KEY);
            this.placeProperty(carrier, DEVICE_DATA_CARRIER_KEY);
            this.placeProperty(language, DEVICE_DATA_LANGUAGE_KEY);
            this.placeProperty(this.screenSize, DEVICE_DATA_SCREEN_SIZE_KEY);
            this.placeProperty(scalingFactor, DEVICE_DATA_SCALING_FACTOR_KEY);
            this.placeProperty(Integer.toString(ppi), DEVICE_DATA_PPI_KEY);
            this.placeProperty(this.orientation, DEVICE_DATA_ORIENTATION_KEY);
            this.placeProperty(connectionType, DEVICE_DATA_CONNECTION_TYPE_KEY);
        }
        catch (JSONException e) {
            DtbLog.error(LOG_TAG, "JSONException while producing deviceInfoJson");
        }
        catch (UnsupportedEncodingException e) {
            DtbLog.error(LOG_TAG, "Unsupported encoding");
        }
    }

    void placeProperty(String attribute, String key) throws JSONException, UnsupportedEncodingException {
        if (attribute != null && !attribute.isEmpty()) {
            this.deviceInfoJson.put(key, (Object)attribute);
        }
    }

    private String generateSha1Hash(String s) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(s.getBytes());
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : messageDigest) {
            hexString.append(Integer.toHexString(0xFF & b | 0x100).substring(1));
        }
        return hexString.toString();
    }

    private void getUserAgent() {
        try {
            this.ua = WebSettings.getDefaultUserAgent((Context)AdRegistration.getContext());
        }
        catch (Exception ex) {
            DtbLog.info("Unable to Get User Agent, Setting it to default");
            this.ua = DEFAULT_USER_AGENT;
        }
    }

    String getUserAgentString() {
        return this.ua;
    }

    public static String getConnectionType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)AdRegistration.getContext().getSystemService("connectivity");
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return "0";
        }
        switch (info.getType()) {
            case 1: {
                return "Wifi";
            }
            case 6: {
                return "13";
            }
            case 0: {
                return Integer.toString(info.getSubtype());
            }
        }
        return "0";
    }

    private void getScreenSize() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.screenSize = DtbDeviceDataRetriever.getScreenSize(metrics, this.orientation);
    }

    private void getOrientation() {
        this.orientation = DtbDeviceDataRetriever.getOrientation(AdRegistration.getContext());
    }

    private int getScreenPpi() {
        DisplayMetrics metrics = this.getDisplayMetrics();
        double x = Math.pow((float)metrics.widthPixels / metrics.xdpi, 2.0);
        double y = Math.pow((float)metrics.heightPixels / metrics.ydpi, 2.0);
        double screenInches = Math.sqrt(x + y);
        double res = Math.pow(metrics.widthPixels, 2.0) + Math.pow(metrics.heightPixels, 2.0);
        res = Math.sqrt(res);
        return (int)(res /= screenInches);
    }

    private DisplayMetrics getDisplayMetrics() {
        Resources resources = AdRegistration.getContext().getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return metrics;
    }
}

