/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DtbGooglePlayServices;
import com.amazon.device.ads.DtbLog;

public class DtbFireOSServiceAdapter {
    private static final String LOG_TAG = DtbFireOSServiceAdapter.class.getSimpleName();

    public static DtbFireOSServiceAdapter newAdapter() {
        return new DtbFireOSServiceAdapter();
    }

    private DtbFireOSServiceAdapter() {
    }

    public DtbGooglePlayServices.AdvertisingInfo getAdvertisingIdentifierInfo() {
        String advertisingID;
        boolean limitAdTracking = false;
        try {
            Context adRegistrationContext = AdRegistration.getContext();
            ContentResolver contentResolver = adRegistrationContext.getContentResolver();
            int limitedAdTrackingCode = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking");
            advertisingID = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
            DtbLog.debug(LOG_TAG, " FireID retrieved : " + advertisingID);
            if (limitedAdTrackingCode != 0) {
                DtbLog.debug(LOG_TAG, " Fire device does not allow AdTracking,");
                limitAdTracking = true;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            DtbLog.debug(LOG_TAG, " Advertising setting not found on this device " + e.getLocalizedMessage());
            return new DtbGooglePlayServices.AdvertisingInfo();
        }
        catch (Exception e) {
            DtbLog.debug(LOG_TAG, " Attempt to retrieve fireID failed. Reason : " + e.getLocalizedMessage());
            return new DtbGooglePlayServices.AdvertisingInfo();
        }
        DtbGooglePlayServices.AdvertisingInfo advertisingInfo = new DtbGooglePlayServices.AdvertisingInfo();
        advertisingInfo.setAdvertisingIdentifier(advertisingID);
        advertisingInfo.setLimitAdTrackingEnabled(limitAdTracking);
        return advertisingInfo;
    }
}

